/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.replication.sticky;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyAssetStorage;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyBulkDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyDBPropertiesStorage;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyEntityStorage;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyPhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyPhysicalStoragePolicy;
import com.gridnine.xtrip.server.db.storage.replication.sticky.StickyPhysicalStorageSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StickyPhysicalStorage
implements PhysicalStorage {
    protected final StickyPhysicalStoragePolicy policy;
    private final List<PhysicalStorage> substorageList = new ArrayList<PhysicalStorage>();
    protected final Map<String, PhysicalStorage> substorageMap = new HashMap<String, PhysicalStorage>();
    private final ExecutorServiceFacade executorService;
    private final StickyEntityStorage entityStorage;
    private final StickyDictionaryStorage dictionaryStorage;
    private final StickyBulkDictionaryStorage bulkDictionaryStorage;
    private final StickyAssetStorage assetStorage;
    private final StickyDBPropertiesStorage dbPropertiesStorage;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String uid;

    public StickyPhysicalStorage(StickyPhysicalStorageConfiguration configuration) throws Exception {
        this.log.debug("initializing...");
        this.uid = configuration.getUid();
        this.policy = configuration.getPolicy();
        this.log.debug("creating substorages...");
        for (Map.Entry<String, StickyPhysicalStorageConfiguration.SubstorageConfiguration> entry : configuration.getSubstorageConfigurations().entrySet()) {
            PhysicalStorage substorage = (PhysicalStorage)Class.forName(entry.getValue().className).getConstructor(entry.getValue().configuration.getClass()).newInstance(entry.getValue().configuration);
            LogicalStorageRegistry.get().registerPhysicalStorage(substorage);
            this.log.debug(String.format("created substorage %s", substorage.getUid()));
            this.substorageMap.put(substorage.getUid(), substorage);
            this.substorageList.add(substorage);
        }
        this.log.debug("creating executor service...");
        this.executorService = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newCachedThreadPool("sticky-physical-storage");
        this.log.debug("creating entity storage...");
        this.entityStorage = this.createEntityStorage();
        this.log.debug("creating dictionary storage...");
        this.dictionaryStorage = new StickyDictionaryStorage();
        this.log.debug("creating bulk dictionary storage...");
        this.bulkDictionaryStorage = new StickyBulkDictionaryStorage();
        this.log.debug("creating asset storage...");
        this.assetStorage = new StickyAssetStorage();
        this.log.debug("creating db properties storage...");
        this.dbPropertiesStorage = new StickyDBPropertiesStorage(this.substorageMap.get(this.policy.getDBPropertiesSubstorageUid()));
        this.log.debug("initialized");
    }

    protected StickyEntityStorage createEntityStorage() {
        return new StickyEntityStorage();
    }

    @Override
    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        PhysicalStorage boundSubstorage = this.substorageMap.get(this.policy.getSubstorageUid(context));
        PhysicalStorageSession boundSubsession = boundSubstorage.createSession(context);
        return new StickyPhysicalStorageSession(boundSubsession, boundSubstorage);
    }

    @Override
    public void setupScheme(boolean cleanupMode) throws Exception {
        ArrayList<SetupSchemeCallable> tasks = new ArrayList<SetupSchemeCallable>(this.substorageList.size());
        for (int i = 0; i < this.substorageList.size(); ++i) {
            tasks.add(new SetupSchemeCallable(this.substorageList.get(i), cleanupMode));
        }
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        for (int i = 0; i < this.substorageList.size(); ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.log.debug(String.format("setupScheme succeeded for substorage %s", this.substorageList.get(i).getUid()));
                continue;
            }
            catch (Throwable t) {
                success = false;
                this.log.error(String.format("setupScheme failed for substorage %s", this.substorageList.get(i).getUid()), t);
            }
        }
        if (!success) {
            throw new Exception("setupScheme failed");
        }
    }

    @Override
    public boolean checkHealth() {
        boolean result = true;
        for (int i = 0; i < this.substorageList.size(); ++i) {
            if (this.substorageList.get(i).checkHealth()) continue;
            this.log.error("checkHealth failed for substorage " + this.substorageList.get(i).getUid());
            result = false;
        }
        return result;
    }

    @Override
    public void dispose() {
        ArrayList<DisposeCallable> tasks = new ArrayList<DisposeCallable>(this.substorageList.size());
        for (int i = 0; i < this.substorageList.size(); ++i) {
            tasks.add(new DisposeCallable(this.substorageList.get(i)));
        }
        try {
            this.executorService.invokeAll(tasks);
        }
        catch (Throwable t) {
            this.log.error("failed disposing substorages", t);
        }
        this.executorService.dispose();
    }

    @Override
    public EntityPhysicalStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public DictionaryPhysicalStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @Override
    public BulkDictionaryPhysicalStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }

    @Override
    public AssetPhysicalStorage getAssetStorage() {
        return this.assetStorage;
    }

    @Override
    public DBPropertiesPhysicalStorage getDBPropertiesStorage() {
        return this.dbPropertiesStorage;
    }

    @Override
    public void maintain() throws Exception {
        ArrayList<MaintainCallable> tasks = new ArrayList<MaintainCallable>(this.substorageList.size());
        for (int i = 0; i < this.substorageList.size(); ++i) {
            tasks.add(new MaintainCallable(this.substorageList.get(i)));
        }
        List futures = this.executorService.invokeAll(tasks);
        boolean success = true;
        for (int i = 0; i < this.substorageList.size(); ++i) {
            try {
                ((Future)futures.get(i)).get();
                this.log.debug(String.format("maintain succeeded for substorage %s", this.substorageList.get(i).getUid()));
                continue;
            }
            catch (Throwable t) {
                success = false;
                this.log.error(String.format("maintain failed for substorage %s", this.substorageList.get(i).getUid()), t);
            }
        }
        if (!success) {
            throw new Exception("maintain failed");
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    private static class MaintainCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;

        MaintainCallable(PhysicalStorage substorage) {
            this.substorage = substorage;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.maintain();
            return null;
        }
    }

    private static class DisposeCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;

        DisposeCallable(PhysicalStorage substorage) {
            this.substorage = substorage;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.dispose();
            return null;
        }
    }

    private static class SetupSchemeCallable
    implements Callable<Object> {
        private final PhysicalStorage substorage;
        private final boolean cleanupMode;

        SetupSchemeCallable(PhysicalStorage substorage, boolean cleanupMode) {
            this.substorage = substorage;
            this.cleanupMode = cleanupMode;
        }

        @Override
        public Object call() throws Exception {
            this.substorage.setupScheme(this.cleanupMode);
            return this.substorage.getUid();
        }
    }
}

