/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.standard;

import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullIndexHandler<E extends BaseEntity>
implements IndexHandler<E, EntityIndex<E>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<? extends BaseIndexData<E, EntityIndex<E>>> dataCls;
    private final Class<EntityIndex<E>> indexCls;
    private final Class<E> entityCls;

    public NullIndexHandler(String indexId, String entityId) {
        MetaRegistry registry = MetaRegistry.get();
        EntityType entityType = (EntityType)registry.getEntities().get(entityId);
        if (entityType == null) {
            throw new IllegalArgumentException("no entity is registered for id " + entityId);
        }
        try {
            this.dataCls = XSHelper.getClassForName((String)(indexId + "Data"));
            this.indexCls = XSHelper.getClassForName((String)indexId);
            this.entityCls = XSHelper.getClassForName((String)entityId);
        }
        catch (Exception e) {
            this.log.error("unable to instantiate classes", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Class<? extends BaseIndexData<E, EntityIndex<E>>> getDataClass() {
        return this.dataCls;
    }

    @Override
    public Class<EntityIndex<E>> getIndexClass() {
        return this.indexCls;
    }

    @Override
    public Class<E> getEntityType() {
        return this.entityCls;
    }

    @Override
    public void create(EntityContainer<E> etc, Collection<BaseIndexData<E, EntityIndex<E>>> indexes) {
    }
}

