/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.standard;

import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.server.assets.AssetDeleteInterceptor;
import com.gridnine.xtrip.server.assets.AssetModificationInterceptor;
import com.gridnine.xtrip.server.assets.ModifiedDateAssetsInterceptor;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheDBOperationsInterceptor;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheOperationCompletedInterceptor;
import com.gridnine.xtrip.server.cache.entity.advanced.AECDbOperationsInterceptor;
import com.gridnine.xtrip.server.cache.entity.advanced.AECOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageConfigurator;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.standard.NullIndexHandler;
import com.gridnine.xtrip.server.db.storage.standard.SimpleIndexHandler;
import com.gridnine.xtrip.server.dicts.DictionaryDeleteInterceptor;
import com.gridnine.xtrip.server.dicts.ModifiedDateDictionaryInterceptor;
import com.gridnine.xtrip.server.entity.EntityDeleteInterceptor;
import com.gridnine.xtrip.server.entity.EntityModificationInterceptor;
import com.gridnine.xtrip.server.entity.IbusDataSourceInterceptor;
import com.gridnine.xtrip.server.entity.ModifiedDateEntityInterceptor;
import com.gridnine.xtrip.server.scheduler.ScheduledTaskSettingsInterceptor;

public class ServerLogicalStorageConfigurator
implements LogicalStorageConfigurator {
    @Override
    public void configure(LogicalStorageRegistry registry) {
        registry.registerEntityInterceptor(new ScheduledTaskSettingsInterceptor());
        registry.registerAssetOperationStartedInterceptor(new ModifiedDateAssetsInterceptor());
        registry.registerEntityInterceptor(new ModifiedDateEntityInterceptor());
        registry.registerDictionaryOperationStartedInterceptor(new ModifiedDateDictionaryInterceptor());
        registry.registerEntityOperationCompletedInterceptor(new AECOperationCompletedInterceptor());
        registry.registerAssetOperationCompletedInterceptor(new AssetsCacheOperationCompletedInterceptor());
        registry.registerEntityOperationCompletedInterceptor(new EntityModificationInterceptor());
        registry.registerAssetOperationCompletedInterceptor(new AssetModificationInterceptor());
        registry.registerEntityInterceptor(new EntityDeleteInterceptor());
        registry.registerAssetOperationCompletedInterceptor(new AssetDeleteInterceptor());
        registry.registerDictionaryOperationCompletedInterceptor(new DictionaryDeleteInterceptor());
        registry.registerDbInterceptor(new AECDbOperationsInterceptor());
        registry.registerDbInterceptor(new AssetsCacheDBOperationsInterceptor());
        this.registerSimpleIndexHandlers(registry);
        registry.registerEntityInterceptor(new IbusDataSourceInterceptor());
    }

    private void registerSimpleIndexHandlers(LogicalStorageRegistry registry) {
        for (IndexType indexType : MetaRegistry.get().getIndexes().values()) {
            if ("true".equals(indexType.getParameters().get("useSimpleIndexHandler"))) {
                registry.registerIndexHandler(new SimpleIndexHandler(indexType.getEntityId()));
            }
            if (!"true".equals(indexType.getParameters().get("useNullIndexHandler"))) continue;
            registry.registerIndexHandler(new NullIndexHandler(indexType.getId(), indexType.getEntityId()));
        }
    }
}

