/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.standard;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIndexHandler<E extends BaseEntity>
implements IndexHandler<E, EntityIndex<E>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<? extends BaseIndexData<E, EntityIndex<E>>> dataCls;
    private final Class<EntityIndex<E>> indexCls;
    private final Class<E> entityCls;
    private final SimpleIndexHandlerInterceptor<E> interceptor;

    public SimpleIndexHandler(String entityId) {
        MetaRegistry registry = MetaRegistry.get();
        EntityType entityType = (EntityType)registry.getEntities().get(entityId);
        if (entityType == null) {
            throw new IllegalArgumentException("no entity is registered for id " + entityId);
        }
        IndexType indexType = null;
        for (IndexType item : registry.getIndexes().values()) {
            if (!item.getEntityId().equals(entityId)) continue;
            indexType = item;
            break;
        }
        if (indexType == null) {
            throw new IllegalArgumentException("no index is registered for entity " + entityId);
        }
        try {
            this.dataCls = XSHelper.getClass((String)(indexType.getId() + "Data"));
            this.indexCls = XSHelper.getClass((String)indexType.getId());
            this.entityCls = XSHelper.getClass((String)entityId);
            String className = (String)indexType.getParameters().get("indexHandlerInterceptor");
            this.interceptor = className != null ? XSHelper.getClass((String)className).newInstance() : null;
        }
        catch (Exception e) {
            this.log.error("unable to instantiate classes", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Class<? extends BaseIndexData<E, EntityIndex<E>>> getDataClass() {
        return this.dataCls;
    }

    @Override
    public Class<EntityIndex<E>> getIndexClass() {
        return this.indexCls;
    }

    @Override
    public Class<E> getEntityType() {
        return this.entityCls;
    }

    @Override
    public void create(EntityContainer<E> etc, Collection<BaseIndexData<E, EntityIndex<E>>> indexes) {
        BaseIndexData<E, EntityIndex<E>> object;
        Object value;
        BaseEntity value1;
        BaseIndexData<E, EntityIndex<E>> data = null;
        try {
            data = this.dataCls.newInstance();
        }
        catch (Exception e) {
            this.log.error("unable to instantiate data class " + this.dataCls, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        indexes.add(data);
        DataAggregator aggregator = new DataAggregator();
        BaseEntity ett = etc.getEntity();
        data.setNavigationKey(ett.getUid());
        MetaRegistry metaRegistry = MetaRegistry.get();
        IndexType indexType = (IndexType)metaRegistry.getIndexes().get(this.indexCls.getName());
        Iterator iterator = indexType.getProperties().values().iterator();
        while (iterator.hasNext()) {
            value1 = ett;
            IndexProperty property = (IndexProperty)iterator.next();
            value = ReflectionUtil.getValue(this.entityCls, (Object)value1, (String)property.getId());
            if (value != null) {
                EntityReference ref;
                if (value instanceof L10nString) {
                    object = data;
                    ReflectionUtil.setValue(this.dataCls, object, (String)property.getId(), (Object)((L10nString)value).getStringValue());
                } else if (value instanceof EntityReference) {
                    ref = (EntityReference)value;
                    BaseIndexData<E, EntityIndex<E>> object2 = data;
                    ReflectionUtil.setValue(this.dataCls, object2, (String)property.getId(), (Object)ref.getUid());
                    BaseIndexData<E, EntityIndex<E>> object1 = data;
                    ReflectionUtil.setValue(this.dataCls, object1, (String)String.format("%sEntityClassName", property.getId()), (Object)ref.getType().getName());
                    BaseIndexData<E, EntityIndex<E>> object22 = data;
                    ReflectionUtil.setValue(this.dataCls, object22, (String)String.format("%sReferenceCaption", property.getId()), (Object)ref.getCaption());
                } else if (value instanceof DictionaryReference) {
                    ref = (DictionaryReference)value;
                    ReflectionUtil.setValue(this.dataCls, data, (String)property.getId(), (Object)ref.getCode());
                } else {
                    object = data;
                    Object value2 = value;
                    ReflectionUtil.setValue(this.dataCls, object, (String)property.getId(), (Object)value2);
                }
            }
            if (value instanceof Date) continue;
            aggregator.aggregate(value);
        }
        iterator = indexType.getCollections().values().iterator();
        while (iterator.hasNext()) {
            value1 = ett;
            IndexCollection coll = (IndexCollection)iterator.next();
            value = ReflectionUtil.getValue(this.entityCls, (Object)value1, (String)coll.getId());
            if (value != null && value instanceof Collection) {
                object = data;
                ReflectionUtil.setMethodValue(this.dataCls, object, (String)coll.getId(), (Object)value);
            }
            aggregator.aggregate(value);
        }
        if (this.interceptor != null) {
            this.interceptor.update(data, aggregator, etc);
        }
        data.setAggregatedData(aggregator.toString());
    }

    public static interface SimpleIndexHandlerInterceptor<E extends BaseEntity> {
        public void update(BaseIndexData<E, EntityIndex<E>> var1, DataAggregator var2, EntityContainer<E> var3);
    }
}

