/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.dicts;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.model.tasks.standard.RepairSecondaryStorageTaskSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationCompletedInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryDeleteInterceptor
implements DictionaryStorageOperationCompletedInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DictionaryDeleteInterceptor.class);
    private static final String SETTINGS_UID = "REPAIR_SECONDARY_STORAGE_TASK_SETTINGS";

    @Override
    public boolean isSystem() {
        return true;
    }

    public double getPriority() {
        return 0.0;
    }

    @Override
    public void afterSave(SessionCallback ss, BaseDictionary data) {
    }

    @Override
    public void afterDelete(SessionCallback ss, BaseDictionary data) {
        log.warn("Dictionary deleted successfully: type={}, code={}, deleted by={}, deleted time={}", new Object[]{data.getClass().getName(), data.getCode(), data.getModifiedBy(), data.getModified()});
        if (DictionaryDeleteInterceptor.ignoreIt(data)) {
            return;
        }
        LogicalStorage.get().getAssetStorage().save(new DeletedObjectReference(data));
    }

    private static boolean ignoreIt(BaseDictionary data) {
        RepairSecondaryStorageTaskSettings settings = DictionaryDeleteInterceptor.getSettings();
        return settings == null || !settings.isEnableToTrackDeletedObjects();
    }

    private static RepairSecondaryStorageTaskSettings getSettings() {
        EntityContainer etc = EntityStorage.get().load(RepairSecondaryStorageTaskSettings.class, SETTINGS_UID);
        return etc != null ? (RepairSecondaryStorageTaskSettings)etc.getEntity() : null;
    }
}

