/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.dicts;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.DictionaryVersion;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.storage.DictionaryStorage;

public class DictionaryVersionInterceptor
implements DictionaryStorageOperationStartedInterceptor,
DictionaryStorageOperationCompletedInterceptor {
    public double getPriority() {
        return Double.MAX_VALUE;
    }

    @Override
    public void beforeSave(SessionCallback ss, BaseDictionary data) throws Exception {
        Object oldDictionary;
        if (data.getCode() != null && (oldDictionary = DictionaryStorage.get().load(data.getClass(), data.getCode())) != null) {
            DictionaryVersion version = new DictionaryVersion(oldDictionary);
            Callback callback = c -> {
                DictionaryVersion cfr_ignored_0 = (DictionaryVersion)AssetsStorage.get().save((BaseAsset)version);
            };
            ss.addCallback(callback);
        }
    }

    @Override
    public void afterDelete(SessionCallback ss, BaseDictionary data) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DictionaryVersion.Property.dictId.name(), (Object)data.getClass().getName()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DictionaryVersion.Property.code.name(), (Object)data.getCode()));
        query.getPreferredProperties().add("uid");
        for (DictionaryVersion version : AssetsStorage.get().search(DictionaryVersion.class, query).getData()) {
            AssetsStorage.get().delete((BaseAsset)version);
        }
    }

    @Override
    public void beforeDelete(SessionCallback ss, BaseDictionary data) throws Exception {
    }

    @Override
    public void afterSave(SessionCallback ss, BaseDictionary data) throws Exception {
    }
}

