/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.model.tasks.standard.RepairSecondaryStorageTaskSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;

public class EntityDeleteInterceptor
implements EntityInterceptor {
    private static final String SETTINGS_UID = "REPAIR_SECONDARY_STORAGE_TASK_SETTINGS";

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    @Override
    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (EntityDeleteInterceptor.ignoreIt(data)) {
            return;
        }
        LogicalStorage.get().getAssetStorage().save(new DeletedObjectReference(data));
    }

    public double getPriority() {
        return Double.MAX_VALUE;
    }

    private static <E extends BaseEntity> boolean ignoreIt(EntityContainer<E> data) {
        RepairSecondaryStorageTaskSettings settings = EntityDeleteInterceptor.getSettings();
        return settings == null || !settings.isEnableToTrackDeletedObjects();
    }

    private static RepairSecondaryStorageTaskSettings getSettings() {
        EntityContainer etc = EntityStorage.get().load(RepairSecondaryStorageTaskSettings.class, SETTINGS_UID);
        return etc != null ? (RepairSecondaryStorageTaskSettings)etc.getEntity() : null;
    }
}

