/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.cache.advanced.GroupsHandlerManager;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.cache.common.OperationType;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.server.db.PollingConfiguration;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityOperationContextData;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import java.util.List;

public class EntityModificationInterceptor
implements EntityStorageOperationCompletedInterceptor {
    public double getPriority() {
        return 0.0;
    }

    @Override
    public <E extends BaseEntity> void afterSave(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes, boolean withCheckPoint, EntityOperationContextData context) throws Exception {
        if (EntityModificationInterceptor.ignoreIt(data)) {
            return;
        }
        LogicalStorage.get().getAssetStorage().save(new ModifiedObjectReference(data, GroupsHandlerManager.getGroups(data), OperationType.MODIFIED));
    }

    @Override
    public <E extends BaseEntity> void afterDelete(SessionCallback ss, EntityContainer<E> data, EntityOperationContextData context) throws Exception {
        if (EntityModificationInterceptor.ignoreIt(data)) {
            return;
        }
        LogicalStorage.get().getAssetStorage().save(new ModifiedObjectReference(data, GroupsHandlerManager.getGroups(data), OperationType.DELETED));
    }

    @Override
    public <E extends BaseEntity> void afterRollback(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes) throws Exception {
    }

    @Override
    public <E extends BaseEntity> void afterRestore(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes) throws Exception {
    }

    @Override
    public <E extends BaseEntity> void afterIndexUpdate(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes) throws Exception {
    }

    private static <E extends BaseEntity> boolean ignoreIt(EntityContainer<E> data) {
        return !PollingConfiguration.isNewPolling() || !EntityCacheManager.get().isCached(data.getEntityType());
    }
}

