/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.entity;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusDataSourceInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 0.0;
    }

    @Override
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (TextUtil.isBlank((String)data.getVersionInfo().getDataSource()) || !LogicalEntityStorage.isDataSourceModified(data.getVersionInfo())) {
            if (IntegrationBusHelper.getThreadContext() != null) {
                data.getVersionInfo().setDataSource(String.format("%s (ibus)", IntegrationBusHelper.getThreadContext().getRouteId()));
                this.log.debug(String.format("datasource of %s was set to %s", data.toString(), data.getVersionInfo().getDataSource()));
                return;
            }
            this.log.debug(String.format("datasource of %s was not set because thread context is null", data.toString()));
        }
    }

    @Override
    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

