/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.format.object;

import com.gridnine.xtrip.common.format.object.FormatObject;
import com.gridnine.xtrip.common.format.object.FormatObjectBinder;
import com.gridnine.xtrip.common.format.object.FormatObjectProperty;
import com.gridnine.xtrip.common.format.object.FormatObjectPropertyHandler;
import com.gridnine.xtrip.common.format.object.FormatObjectProxy;
import com.gridnine.xtrip.common.format.object.FormatObjectProxyBuilder;
import com.gridnine.xtrip.common.format.object.FormatObjectsRegistry;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Format {
    private static Logger log = LoggerFactory.getLogger(Format.class);
    private final Entry root;

    public static Format of(String pattern) {
        return new Format(pattern);
    }

    private Format(String pattern) {
        this.root = new CompoundEntry(pattern, 0, pattern.length());
    }

    public String format(FormatObjectData objectData, EntityStorageContext storageContext) {
        return this.format(objectData, storageContext, LocaleManager.get().getCurrentLocale());
    }

    public String format(FormatObjectData objectData, EntityStorageContext storageContext, Locale locale) {
        try {
            if (objectData == null) {
                log.error("object data is not specified");
                throw new Exception("object data is not specified");
            }
            if (objectData.getObject() == null || objectData.getObjectId() == null || objectData.getRootObject() == null || objectData.getRootObjectId() == null) {
                log.error("object data is corrupted");
                throw new Exception("object data is corrupted");
            }
            FormatObjectProxy proxy = this.buildProxy(objectData);
            return this.root.format(proxy, storageContext, locale, true);
        }
        catch (Exception e) {
            throw new FormatException(e);
        }
    }

    private FormatObjectProxy buildProxy(FormatObjectData objectData) throws Exception {
        FormatObject object = FormatObjectsRegistry.get().getObject(objectData.getObjectId());
        if (object == null) {
            log.error(String.format("object %s is not found", objectData.getObjectId()));
            throw new Exception(String.format("object %s is not found", objectData.getObjectId()));
        }
        String proxyBuilderId = FormatObjectsRegistry.get().getObjectProxyBuilder(object.getId());
        if (proxyBuilderId == null) {
            log.debug(String.format("proxy builder id for %s is not found", object.getId()));
            throw new Exception(String.format("proxy builder id for %s is not found", object.getId()));
        }
        FormatObjectProxyBuilder proxyBuilder = FormatObjectsRegistry.get().getProxyBuilder(proxyBuilderId);
        if (proxyBuilder == null) {
            log.error(String.format("object proxy builder %s is not found", proxyBuilderId));
            throw new Exception(String.format("object proxy builder %s is not found", proxyBuilderId));
        }
        String id = proxyBuilder.buildProxy(objectData.getObject(), null).getId();
        HashMap<String, FormatObjectProxy> proxies = new HashMap<String, FormatObjectProxy>();
        this.buildProxies(objectData.getRootObject(), objectData.getRootObjectId(), objectData.getParentProxy(), proxies);
        FormatObjectProxy proxy = (FormatObjectProxy)proxies.get(id);
        if (proxy == null) {
            log.error(String.format("proxy %s is not found", id));
            throw new Exception(String.format("proxy %s is not found", id));
        }
        return proxy;
    }

    private void buildProxies(Object object, String objectId, FormatObjectProxy parentProxy, Map<String, FormatObjectProxy> proxies) throws Exception {
        FormatObject objectt = FormatObjectsRegistry.get().getObject(objectId);
        if (objectt == null) {
            log.error(String.format("object %s is not found", objectId));
            throw new Exception(String.format("object %s is not found", objectId));
        }
        String proxyBuilderId = FormatObjectsRegistry.get().getObjectProxyBuilder(objectt.getId());
        if (proxyBuilderId == null) {
            log.debug(String.format("proxy builder id for %s is not found", objectId));
            throw new Exception(String.format("proxy builder id for %s is not found", objectId));
        }
        FormatObjectProxyBuilder proxyBuilder = FormatObjectsRegistry.get().getProxyBuilder(proxyBuilderId);
        if (proxyBuilder == null) {
            log.error(String.format("object proxy builder %s is not found", proxyBuilderId));
            throw new Exception(String.format("object proxy builder %s is not found", proxyBuilderId));
        }
        FormatObjectProxy proxy = proxyBuilder.buildProxy(object, parentProxy);
        proxies.put(proxy.getId(), proxy);
        Collection binderIds = FormatObjectsRegistry.get().getObjectBinders(objectId);
        for (String binderId : binderIds) {
            FormatObjectBinder binder = FormatObjectsRegistry.get().getBinder(binderId);
            if (binder == null) {
                log.error(String.format("object binder %s is not found", binderId));
                throw new Exception(String.format("object binder %s is not found", binderId));
            }
            for (Object bindObject : binder.getBindObjects(object)) {
                this.buildProxies(bindObject, binder.getBindObjectId(), proxy, proxies);
            }
        }
    }

    private static String unescape(String pattern) {
        StringBuilder result = new StringBuilder(pattern);
        boolean escape = false;
        for (int i = 0; i < result.length(); ++i) {
            if (result.charAt(i) != '\'') continue;
            if (escape) {
                result.delete(i, i + 1);
                escape = false;
                --i;
                continue;
            }
            if (i + 1 < result.length() && result.charAt(i + 1) == '\'') {
                result.delete(i, i + 1);
                continue;
            }
            result.delete(i, i + 1);
            escape = true;
            --i;
        }
        return result.toString();
    }

    public static class FormatException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 7066255632583484859L;

        public FormatException(String message) {
            super(message);
        }

        public FormatException(Throwable cause) {
            super(cause);
        }

        public FormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PatternSyntaxException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 777679550037206037L;
        private final String description;
        private final String pattern;
        private final int index;

        public PatternSyntaxException(String description, String pattern, int index) {
            this.description = description;
            this.pattern = pattern;
            this.index = index;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String getMessage() {
            StringBuilder message = new StringBuilder();
            message.append(this.description);
            if (this.index >= 0) {
                message.append(" near index ");
                message.append(this.index);
            }
            message.append("\n");
            message.append(this.pattern);
            if (this.index >= 0) {
                message.append("\n");
                for (int i = 0; i < this.index; ++i) {
                    message.append(' ');
                }
                message.append('^');
            }
            return message.toString();
        }
    }

    public static class FormatObjectDataBuilder {
        private Object object;
        private String objectId;
        private Object rootObject;
        private String rootObjectId;
        private FormatObjectProxy parentProxy;

        public static FormatObjectDataBuilder get() {
            return new FormatObjectDataBuilder();
        }

        private FormatObjectDataBuilder() {
        }

        public FormatObjectDataBuilder object(Object object, String objectId) {
            this.object = object;
            this.objectId = objectId;
            if (this.rootObject == null || this.rootObjectId == null) {
                this.rootObject = object;
                this.rootObjectId = objectId;
            }
            return this;
        }

        public FormatObjectDataBuilder rootObject(Object rootObject, String rootObjectId) {
            this.rootObject = rootObject;
            this.rootObjectId = rootObjectId;
            return this;
        }

        public FormatObjectDataBuilder parentProxy(FormatObjectProxy parentProxy) {
            this.parentProxy = parentProxy;
            return this;
        }

        public FormatObjectData build() {
            return FormatObjectData.of(this.object, this.objectId, this.rootObject, this.rootObjectId, this.parentProxy);
        }
    }

    public static class FormatObjectData {
        private final Object object;
        private final String objectId;
        private final Object rootObject;
        private final String rootObjectId;
        private final FormatObjectProxy parentProxy;

        public static FormatObjectData of(Object object, String objectId, Object rootObject, String rootObjectId, FormatObjectProxy parentProxy) {
            return new FormatObjectData(object, objectId, rootObject, rootObjectId, parentProxy);
        }

        private FormatObjectData(Object object, String objectId, Object rootObject, String rootObjectId, FormatObjectProxy parentProxy) {
            this.object = object;
            this.objectId = objectId;
            this.rootObject = rootObject;
            this.rootObjectId = rootObjectId;
            this.parentProxy = parentProxy;
        }

        public Object getObject() {
            return this.object;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public Object getRootObject() {
            return this.rootObject;
        }

        public String getRootObjectId() {
            return this.rootObjectId;
        }

        public FormatObjectProxy getParentProxy() {
            return this.parentProxy;
        }
    }

    static final class CompoundEntry
    implements Entry {
        private final List<Entry> entries = new ArrayList<Entry>();

        CompoundEntry(String pattern, int beginIndex, int endIndex) {
            this.parsePattern(pattern, beginIndex, endIndex);
        }

        private void parsePattern(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing compound -> " + pattern.substring(beginIndex, endIndex));
            }
            boolean escape = false;
            int escapeBeginIndex = 0;
            int entryBeginIndex = beginIndex;
            int hitCount = 0;
            Type type = null;
            for (int i = beginIndex; i < endIndex; ++i) {
                if (escape) {
                    if (pattern.charAt(i) == '\'') {
                        escape = false;
                    }
                } else if (pattern.charAt(i) == '{') {
                    if (type == Type.SIMPLE) {
                        this.entries.add(new SimpleEntry(pattern, entryBeginIndex, i));
                        type = null;
                    }
                    if (type == null) {
                        type = Type.VARIABLE;
                        entryBeginIndex = i + 1;
                    }
                    if (type == Type.VARIABLE) {
                        ++hitCount;
                    }
                } else if (pattern.charAt(i) == '}') {
                    if (type == null || type == Type.SIMPLE) {
                        throw new PatternSyntaxException("missing start of variable", pattern, i);
                    }
                    if (type == Type.VARIABLE && --hitCount == 0) {
                        this.entries.add(new VariableEntry(pattern, entryBeginIndex, i));
                        type = null;
                    }
                } else if (pattern.charAt(i) == '[') {
                    if (type == Type.SIMPLE) {
                        this.entries.add(new SimpleEntry(pattern, entryBeginIndex, i));
                        type = null;
                    }
                    if (type == null) {
                        type = Type.OPTIONAL;
                        entryBeginIndex = i + 1;
                    }
                    if (type == Type.OPTIONAL) {
                        ++hitCount;
                    }
                } else if (pattern.charAt(i) == ']') {
                    if (type == null || type == Type.SIMPLE) {
                        throw new PatternSyntaxException("missing start of optional", pattern, i);
                    }
                    if (type == Type.OPTIONAL && --hitCount == 0) {
                        this.entries.add(new OptionalEntry(pattern, entryBeginIndex, i));
                        type = null;
                    }
                } else if (pattern.charAt(i) == '<') {
                    if (type == Type.SIMPLE) {
                        this.entries.add(new SimpleEntry(pattern, entryBeginIndex, i));
                        type = null;
                    }
                    if (type == null) {
                        type = Type.CONDITIONAL;
                        entryBeginIndex = i + 1;
                    }
                    if (type == Type.CONDITIONAL) {
                        ++hitCount;
                    }
                } else if (pattern.charAt(i) == '>') {
                    if (type == null || type == Type.SIMPLE) {
                        throw new PatternSyntaxException("missing start of conditional", pattern, i);
                    }
                    if (type == Type.CONDITIONAL && --hitCount == 0) {
                        this.entries.add(new ConditionalEntry(pattern, entryBeginIndex, i));
                        type = null;
                    }
                } else {
                    if (type == null) {
                        type = Type.SIMPLE;
                        entryBeginIndex = i;
                    }
                    if (pattern.charAt(i) == '\'') {
                        escape = true;
                        escapeBeginIndex = i;
                    }
                }
                if (i != endIndex - 1) continue;
                if (escape) {
                    throw new PatternSyntaxException("missing end of esacape sequence", pattern, escapeBeginIndex);
                }
                if (type == Type.SIMPLE) {
                    this.entries.add(new SimpleEntry(pattern, entryBeginIndex, endIndex));
                    continue;
                }
                if (type == Type.VARIABLE) {
                    throw new PatternSyntaxException("missing end of variable", pattern, entryBeginIndex);
                }
                if (type != Type.OPTIONAL) continue;
                throw new PatternSyntaxException("missing end of optional", pattern, entryBeginIndex);
            }
        }

        @Override
        public String format(FormatObjectProxy proxy, EntityStorageContext storageContext, Locale locale, boolean empty) throws Exception {
            StringBuilder result = new StringBuilder();
            for (Entry entry : this.entries) {
                String format = entry.format(proxy, storageContext, locale, empty && result.length() == 0);
                if (TextUtil.isBlank((String)format, (boolean)false)) continue;
                result.append(format);
            }
            return result.toString();
        }
    }

    static final class ConditionalEntry
    implements Entry {
        private Entry value;
        private Entry defaultt;
        private final Map<String, Entry> results = new LinkedHashMap<String, Entry>();

        ConditionalEntry(String pattern, int beginIndex, int endIndex) {
            this.parsePattern(pattern, beginIndex, endIndex);
        }

        private void parsePattern(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing conditional -> " + pattern.substring(beginIndex, endIndex));
            }
            boolean escape = false;
            int propertyBeginIndex = beginIndex;
            int hitCount = 0;
            Type type = null;
            boolean complex = this.isComplexProperty(pattern, beginIndex, endIndex);
            for (int i = beginIndex; i < endIndex; ++i) {
                if (escape) {
                    if (pattern.charAt(i) == '\'') {
                        escape = false;
                    }
                } else {
                    if (complex) {
                        if (pattern.charAt(i) == '{') {
                            if (type == null) {
                                type = Type.VARIABLE;
                            }
                            if (type == Type.VARIABLE) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == '}') {
                            if (type == Type.VARIABLE && --hitCount == 0) {
                                type = null;
                            }
                        } else if (pattern.charAt(i) == '[') {
                            if (type == null) {
                                type = Type.OPTIONAL;
                            }
                            if (type == Type.OPTIONAL) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == ']') {
                            if (type == Type.OPTIONAL && --hitCount == 0) {
                                type = null;
                            }
                        } else if (pattern.charAt(i) == '<') {
                            if (type == null) {
                                type = Type.CONDITIONAL;
                            }
                            if (type == Type.CONDITIONAL) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == '>' && type == Type.CONDITIONAL && --hitCount == 0) {
                            type = null;
                        }
                    }
                    if (pattern.charAt(i) == '|') {
                        if (hitCount == 0) {
                            this.parseProperty(pattern, propertyBeginIndex, i);
                            propertyBeginIndex = i + 1;
                            complex = this.isComplexProperty(pattern, propertyBeginIndex, endIndex);
                        }
                    } else if (pattern.charAt(i) == '\'') {
                        escape = true;
                    }
                }
                if (i != endIndex - 1) continue;
                this.parseProperty(pattern, propertyBeginIndex, endIndex);
            }
            if (this.value == null) {
                throw new PatternSyntaxException("missing mandatory conditional property \"value\"", pattern, endIndex);
            }
        }

        public void parseProperty(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing property of conditional -> " + pattern.substring(beginIndex, endIndex));
            }
            MiscUtil.Pair property = null;
            boolean escape = false;
            for (int i = beginIndex; i < endIndex; ++i) {
                if (escape) {
                    if (pattern.charAt(i) != '\'') continue;
                    escape = false;
                    continue;
                }
                if (pattern.charAt(i) == '=') {
                    property = new MiscUtil.Pair((Object)pattern.substring(beginIndex, i), (Object)pattern.substring(i + 1, endIndex));
                    if (TextUtil.isBlank((String)((String)property.getFirst()), (boolean)false)) {
                        throw new PatternSyntaxException("missing conditional property name", pattern, beginIndex);
                    }
                    if (TextUtil.isBlank((String)((String)property.getSecond()), (boolean)false)) {
                        throw new PatternSyntaxException("missing conditional property value", pattern, endIndex);
                    }
                    String name = Format.unescape((String)property.getFirst());
                    if (name.equals("value")) {
                        this.value = new CompoundEntry(pattern, i + 1, endIndex);
                        break;
                    }
                    if (name.equals("default")) {
                        this.defaultt = new CompoundEntry(pattern, i + 1, endIndex);
                        break;
                    }
                    if (this.results.containsKey(name)) break;
                    this.results.put(name, new CompoundEntry(pattern, i + 1, endIndex));
                    break;
                }
                if (pattern.charAt(i) != '\'') continue;
                escape = true;
            }
            if (property == null) {
                throw new PatternSyntaxException("corrupted conditional property", pattern, beginIndex);
            }
        }

        private boolean isComplexProperty(String pattern, int beginIndex, int endIndex) {
            return true;
        }

        @Override
        public String format(FormatObjectProxy proxy, EntityStorageContext storageContext, Locale locale, boolean empty) throws Exception {
            String format = this.value.format(proxy, storageContext, locale, true);
            if (!TextUtil.isBlank((String)format, (boolean)false)) {
                String result = null;
                for (String regex : this.results.keySet()) {
                    if (!format.matches(regex)) continue;
                    result = this.results.get(regex).format(proxy, storageContext, locale, true);
                    break;
                }
                if (TextUtil.isBlank(result, (boolean)false) && this.defaultt != null) {
                    result = this.defaultt.format(proxy, storageContext, locale, true);
                }
                return result;
            }
            return null;
        }
    }

    static final class OptionalEntry
    implements Entry {
        private static final List<String> complexProperties = Arrays.asList("value");
        private String padding;
        private String prefix;
        private String suffix;
        private Entry value;

        OptionalEntry(String pattern, int beginIndex, int endIndex) {
            this.parsePattern(pattern, beginIndex, endIndex);
        }

        private void parsePattern(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing optional -> " + pattern.substring(beginIndex, endIndex));
            }
            boolean escape = false;
            int propertyBeginIndex = beginIndex;
            int hitCount = 0;
            Type type = null;
            boolean complex = this.isComplexProperty(pattern, beginIndex, endIndex);
            for (int i = beginIndex; i < endIndex; ++i) {
                if (escape) {
                    if (pattern.charAt(i) == '\'') {
                        escape = false;
                    }
                } else {
                    if (complex) {
                        if (pattern.charAt(i) == '{') {
                            if (type == null) {
                                type = Type.VARIABLE;
                            }
                            if (type == Type.VARIABLE) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == '}') {
                            if (type == Type.VARIABLE && --hitCount == 0) {
                                type = null;
                            }
                        } else if (pattern.charAt(i) == '[') {
                            if (type == null) {
                                type = Type.OPTIONAL;
                            }
                            if (type == Type.OPTIONAL) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == ']') {
                            if (type == Type.OPTIONAL && --hitCount == 0) {
                                type = null;
                            }
                        } else if (pattern.charAt(i) == '<') {
                            if (type == null) {
                                type = Type.CONDITIONAL;
                            }
                            if (type == Type.CONDITIONAL) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == '>' && type == Type.CONDITIONAL && --hitCount == 0) {
                            type = null;
                        }
                    }
                    if (pattern.charAt(i) == '|') {
                        if (hitCount == 0) {
                            this.parseProperty(pattern, propertyBeginIndex, i);
                            propertyBeginIndex = i + 1;
                            complex = this.isComplexProperty(pattern, propertyBeginIndex, endIndex);
                        }
                    } else if (pattern.charAt(i) == '\'') {
                        escape = true;
                    }
                }
                if (i != endIndex - 1) continue;
                this.parseProperty(pattern, propertyBeginIndex, endIndex);
            }
            if (this.value == null) {
                throw new PatternSyntaxException("missing mandatory optional property \"value\"", pattern, endIndex);
            }
        }

        public void parseProperty(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing property of optional -> " + pattern.substring(beginIndex, endIndex));
            }
            MiscUtil.Pair property = null;
            boolean escape = false;
            for (int i = beginIndex; i < endIndex; ++i) {
                if (escape) {
                    if (pattern.charAt(i) != '\'') continue;
                    escape = false;
                    continue;
                }
                if (pattern.charAt(i) == '=') {
                    property = new MiscUtil.Pair((Object)pattern.substring(beginIndex, i), (Object)pattern.substring(i + 1, endIndex));
                    if (TextUtil.isBlank((String)((String)property.getFirst()), (boolean)false)) {
                        throw new PatternSyntaxException("missing optional property name", pattern, beginIndex);
                    }
                    if (TextUtil.isBlank((String)((String)property.getSecond()), (boolean)false)) {
                        throw new PatternSyntaxException("missing optional property value", pattern, endIndex);
                    }
                    String name = Format.unescape((String)property.getFirst());
                    if (name.equals("padding")) {
                        this.padding = Format.unescape((String)property.getSecond());
                        break;
                    }
                    if (name.equals("prefix")) {
                        this.prefix = Format.unescape((String)property.getSecond());
                        break;
                    }
                    if (name.equals("suffix")) {
                        this.suffix = Format.unescape((String)property.getSecond());
                        break;
                    }
                    if (name.equals("value")) {
                        this.value = new CompoundEntry(pattern, i + 1, endIndex);
                        break;
                    }
                    throw new PatternSyntaxException(String.format("unsupported optional property \"%s\"", name), pattern, beginIndex);
                }
                if (pattern.charAt(i) != '\'') continue;
                escape = true;
            }
            if (property == null) {
                throw new PatternSyntaxException("corrupted optional property", pattern, beginIndex);
            }
        }

        private boolean isComplexProperty(String pattern, int beginIndex, int endIndex) {
            return complexProperties.stream().anyMatch(item -> Format.unescape(pattern.substring(beginIndex, endIndex)).startsWith((String)item));
        }

        @Override
        public String format(FormatObjectProxy proxy, EntityStorageContext storageContext, Locale locale, boolean empty) throws Exception {
            String format = this.value.format(proxy, storageContext, locale, true);
            if (!TextUtil.isBlank((String)format, (boolean)false)) {
                StringBuilder result = new StringBuilder();
                if (!TextUtil.isBlank((String)this.padding, (boolean)false) && !empty) {
                    result.append(this.padding);
                }
                if (!TextUtil.isBlank((String)this.prefix, (boolean)false)) {
                    result.append(this.prefix);
                }
                result.append(format);
                if (!TextUtil.isBlank((String)this.suffix, (boolean)false)) {
                    result.append(this.suffix);
                }
                return result.toString();
            }
            return null;
        }
    }

    static final class VariableEntry
    implements Entry {
        private static final List<String> complexProperties = Arrays.asList("pattern", "default");
        private String parentId;
        private String id;
        private String separator;
        private String patternn;
        private Entry defaultt;
        private Locale local;

        VariableEntry(String pattern, int beginIndex, int endIndex) {
            this.parsePattern(pattern, beginIndex, endIndex);
        }

        public void parsePattern(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing variable -> " + pattern.substring(beginIndex, endIndex));
            }
            boolean escape = false;
            int propertyBeginIndex = beginIndex;
            int hitCount = 0;
            Type type = null;
            boolean complex = this.isComplexProperty(pattern, beginIndex, endIndex);
            for (int i = beginIndex; i < endIndex; ++i) {
                if (escape) {
                    if (pattern.charAt(i) == '\'') {
                        escape = false;
                    }
                } else {
                    if (complex) {
                        if (pattern.charAt(i) == '{') {
                            if (type == null) {
                                type = Type.VARIABLE;
                            }
                            if (type == Type.VARIABLE) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == '}') {
                            if (type == Type.VARIABLE && --hitCount == 0) {
                                type = null;
                            }
                        } else if (pattern.charAt(i) == '[') {
                            if (type == null) {
                                type = Type.OPTIONAL;
                            }
                            if (type == Type.OPTIONAL) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == ']') {
                            if (type == Type.OPTIONAL && --hitCount == 0) {
                                type = null;
                            }
                        } else if (pattern.charAt(i) == '<') {
                            if (type == null) {
                                type = Type.CONDITIONAL;
                            }
                            if (type == Type.CONDITIONAL) {
                                ++hitCount;
                            }
                        } else if (pattern.charAt(i) == '>' && type == Type.CONDITIONAL && --hitCount == 0) {
                            type = null;
                        }
                    }
                    if (pattern.charAt(i) == '|') {
                        if (hitCount == 0) {
                            this.parseProperty(pattern, propertyBeginIndex, i);
                            propertyBeginIndex = i + 1;
                            complex = this.isComplexProperty(pattern, propertyBeginIndex, endIndex);
                        }
                    } else if (pattern.charAt(i) == '\'') {
                        escape = true;
                    }
                }
                if (i != endIndex - 1) continue;
                this.parseProperty(pattern, propertyBeginIndex, endIndex);
            }
            if (this.id == null) {
                throw new PatternSyntaxException("missing mandatory optional property \"id\"", pattern, endIndex);
            }
        }

        public void parseProperty(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing property of variable -> " + pattern.substring(beginIndex, endIndex));
            }
            MiscUtil.Pair property = null;
            boolean escape = false;
            for (int i = beginIndex; i < endIndex; ++i) {
                if (escape) {
                    if (pattern.charAt(i) != '\'') continue;
                    escape = false;
                    continue;
                }
                if (pattern.charAt(i) == '=') {
                    property = new MiscUtil.Pair((Object)pattern.substring(beginIndex, i), (Object)pattern.substring(i + 1, endIndex));
                    if (TextUtil.isBlank((String)((String)property.getFirst()), (boolean)false)) {
                        throw new PatternSyntaxException("missing variable property name", pattern, beginIndex);
                    }
                    if (TextUtil.isBlank((String)((String)property.getSecond()), (boolean)false)) {
                        throw new PatternSyntaxException("missing variable property value", pattern, endIndex);
                    }
                    String name = Format.unescape((String)property.getFirst());
                    if (name.equals("id")) {
                        String[] entries = Format.unescape((String)property.getSecond()).split(":", 2);
                        if (entries.length == 2) {
                            this.parentId = entries[0];
                            this.id = entries[1];
                            break;
                        }
                        throw new PatternSyntaxException(String.format("corrupted variable property \"%s\" format: <object_id>:<variable_id> expected", name), pattern, beginIndex);
                    }
                    if (name.equals("separator")) {
                        this.separator = Format.unescape((String)property.getSecond());
                        break;
                    }
                    if (name.equals("pattern")) {
                        this.patternn = (String)property.getSecond();
                        break;
                    }
                    if (name.equals("default")) {
                        this.defaultt = new CompoundEntry(pattern, i + 1, endIndex);
                        break;
                    }
                    if (name.equals("locale")) {
                        this.local = TextUtil.nonBlank((String)((String)property.getSecond())) ? LocaleHelper.getLocale((String)((String)property.getSecond()).toLowerCase().trim()) : null;
                        break;
                    }
                    throw new PatternSyntaxException(String.format("unsupported variable property \"%s\"", name), pattern, beginIndex);
                }
                if (pattern.charAt(i) != '\'') continue;
                escape = true;
            }
            if (property == null) {
                throw new PatternSyntaxException("corrupted variable property", pattern, beginIndex);
            }
        }

        private boolean isComplexProperty(String pattern, int beginIndex, int endIndex) {
            return complexProperties.stream().anyMatch(item -> Format.unescape(pattern.substring(beginIndex, endIndex)).startsWith((String)item));
        }

        @Override
        public String format(FormatObjectProxy proxy, EntityStorageContext storageContext, Locale locale, boolean empty) throws Exception {
            FormatObjectProxy parentProxy;
            for (parentProxy = proxy; parentProxy != null; parentProxy = parentProxy.getParent()) {
                FormatObject object = FormatObjectsRegistry.get().getObject(parentProxy.getObjectId());
                if (object == null) {
                    log.error(String.format("object %s is not found", parentProxy.getObjectId()));
                    throw new Exception(String.format("object %s is not found", parentProxy.getObjectId()));
                }
                if (MiscUtil.equals((Object)this.parentId, (Object)object.getId()) || MiscUtil.equals((Object)this.parentId, (Object)object.getTag())) break;
            }
            if (parentProxy == null) {
                log.error(String.format("object proxy %s is not found", this.parentId));
                throw new Exception(String.format("object proxy %s is not found", this.parentId));
            }
            Collection propertyIds = FormatObjectsRegistry.get().getObjectProperties(parentProxy.getObjectId());
            for (String propertyId : propertyIds) {
                FormatObjectProperty property = FormatObjectsRegistry.get().getProperty(propertyId);
                if (property == null) {
                    log.error(String.format("property %s is not found", propertyId));
                    throw new Exception(String.format("property %s is not found", propertyId));
                }
                if (!MiscUtil.equals((Object)this.id, (Object)property.getId()) && !MiscUtil.equals((Object)this.id, (Object)property.getTag())) continue;
                String handlerId = FormatObjectsRegistry.get().getPropertyHandler(property.getId());
                if (handlerId == null) {
                    log.debug(String.format("handler id for %s is not found", property.getId()));
                    throw new Exception(String.format("handler id for %s is not found", property.getId()));
                }
                FormatObjectPropertyHandler handler = FormatObjectsRegistry.get().getHandler(handlerId);
                if (handler == null) {
                    log.error(String.format("handler %s is not found", handlerId));
                    throw new Exception(String.format("handler %s is not found", handlerId));
                }
                String result = handler.getValue(parentProxy, this.separator, this.patternn, handler.isLocaleOptional() ? this.local : (this.local != null ? this.local : locale), storageContext);
                if (TextUtil.isBlank((String)result, (boolean)false) && this.defaultt != null) {
                    result = this.defaultt.format(proxy, storageContext, locale, true);
                }
                return result;
            }
            log.error(String.format("object property %s is not found", this.id));
            throw new Exception(String.format("object property %s is not found", this.id));
        }
    }

    static final class SimpleEntry
    implements Entry {
        String value;

        SimpleEntry(String pattern, int beginIndex, int endIndex) {
            this.parsePattern(pattern, beginIndex, endIndex);
        }

        private void parsePattern(String pattern, int beginIndex, int endIndex) {
            if (log.isDebugEnabled()) {
                log.debug("parsing simple -> " + pattern.substring(beginIndex, endIndex));
            }
            this.value = Format.unescape(pattern.substring(beginIndex, endIndex));
        }

        @Override
        public String format(FormatObjectProxy proxy, EntityStorageContext storageContext, Locale locale, boolean empty) {
            return this.value;
        }
    }

    static interface Entry {
        public String format(FormatObjectProxy var1, EntityStorageContext var2, Locale var3, boolean var4) throws Exception;
    }

    static enum Type {
        SIMPLE,
        VARIABLE,
        OPTIONAL,
        CONDITIONAL;

    }
}

