/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gen.storage;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.type.TextArrayType;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.slf4j.LoggerFactory;

final class ArrayCollectionGenerator {
    static void generateDataMembers(JavaWriter writer, IndexCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        MetaRegistry metaRegistry = ctx.getMetaRegistry();
        String type = ArrayCollectionGenerator.getType(coll, ctx);
        boolean isEntityReference = BaseEntity.class.getName().equals(coll.getElementType()) || metaRegistry.getEntities().containsKey(coll.getElementType());
        boolean isNestedEntityReference = ModelCodeGenHelper.isNestedEntityReferenceType((String)coll.getElementType());
        String id = coll.getId();
        if (!isEntityReference && !isNestedEntityReference) {
            writer.code("@%s(type = \"%s\")", new Object[]{Type.class.getName(), TextArrayType.class.getName()});
            if (coll.isSearchable() && coll.isDbIndexed()) {
                writer.code("@%s(name = \"%s_%s\")", new Object[]{Index.class.getName(), GenUtil.getSimpleClassName((String)bt.getId()), id});
            }
            writer.code("private String[] %s;", new Object[]{id});
        } else {
            writer.code("@%s(type = \"%s\")", new Object[]{Type.class.getName(), TextArrayType.class.getName()});
            if (coll.isSearchable() && coll.isDbIndexed()) {
                writer.code("@%s(name = \"%s_%s\")", new Object[]{Index.class.getName(), GenUtil.getSimpleClassName((String)bt.getId()), id});
            }
            writer.code("private String[] %s;", new Object[]{id});
            writer.code("@%s(type = \"%s\")", new Object[]{Type.class.getName(), TextArrayType.class.getName()});
            writer.code("private String[] %sEntityClassName;", new Object[]{id});
            writer.code("@%s(type = \"%s\")", new Object[]{Type.class.getName(), TextArrayType.class.getName()});
            writer.code("private String[] %sReferenceCaption;", new Object[]{id});
        }
        writer.blank();
        writer.beginBlock("public void set%s(%s<%s> value)", new Object[]{GenUtil.capitalize((String)coll.getId()), Collection.class.getName(), type});
        if (isNestedEntityReference) {
            writer.code("value = value.stream().filter(%s::nonNull).collect(%s.toList());", new Object[]{Objects.class.getName(), Collectors.class.getName()});
            writer.beginBlock("if (value.isEmpty())", new Object[0]);
            writer.code("final String[] emptyValue = new String[0];", new Object[0]);
            writer.code("this.%s = emptyValue;", new Object[]{coll.getId()});
            writer.code("this.%sEntityClassName = emptyValue;", new Object[]{coll.getId()});
            writer.code("this.%sReferenceCaption = emptyValue;", new Object[]{coll.getId()});
            writer.code("return;", new Object[0]);
            writer.endBlock();
            writer.code("this.%s = value.stream().map(i-> i != null ? i.getNestedEntityUid() + \"|\" + i.getUid() : null).toArray(String[]::new);", new Object[]{coll.getId()});
            writer.code("this.%sEntityClassName = value.stream().map(i-> i != null ? (i.getNestedEntityType() != null ? i.getNestedEntityType().getName() : null) + \"|\" + (i.getType() != null ? i.getType().getName() : null) : null).toArray(String[]::new);", new Object[]{coll.getId()});
            writer.code("this.%sReferenceCaption = value.stream().map(i-> i != null ? i.getCaption() : null).toArray(String[]::new);", new Object[]{coll.getId()});
        } else if (isEntityReference) {
            writer.code("value = value.stream().filter(%s::nonNull).collect(%s.toList());", new Object[]{Objects.class.getName(), Collectors.class.getName()});
            writer.beginBlock("if (value.isEmpty())", new Object[0]);
            writer.code("final String[] emptyValue = new String[0];", new Object[0]);
            writer.code("this.%s = emptyValue;", new Object[]{coll.getId()});
            writer.code("this.%sEntityClassName = emptyValue;", new Object[]{coll.getId()});
            writer.code("this.%sReferenceCaption = emptyValue;", new Object[]{coll.getId()});
            writer.code("return;", new Object[0]);
            writer.endBlock();
            writer.code("this.%s = value.stream().map(i-> i != null ? i.getUid() : null).toArray(String[]::new);", new Object[]{coll.getId()});
            writer.code("this.%sEntityClassName = value.stream().map(i-> i != null && i.getType() != null ? i.getType().getName() : null).toArray(String[]::new);", new Object[]{coll.getId()});
            writer.code("this.%sReferenceCaption = value.stream().map(i-> i != null ? i.getCaption() : null).toArray(String[]::new);", new Object[]{coll.getId()});
        } else if ("String".equals(type)) {
            writer.code("this.%s = value.isEmpty() ? new String[0] : value.toArray(new String[value.size()]);", new Object[]{coll.getId()});
        } else {
            String ig = metaRegistry.getEnums().containsKey(coll.getElementType()) ? "i != null ? i.name() : null" : (metaRegistry.getEntities().containsKey(coll.getElementType()) ? "i != null ? i.getUid() : null" : (metaRegistry.getDictionaries().containsKey(coll.getElementType()) ? "i != null ? i.getCode() : null" : "i != null ? i.toString() : null"));
            writer.code("this.%s = value.isEmpty() ? new String[0] : value.stream().map(i->" + ig + ").toArray(String[]::new);", new Object[]{coll.getId()});
        }
        writer.endBlock();
    }

    static void generateToIndex(JavaWriter writer, IndexCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        boolean entityRef;
        writer.comment("COLLECTION %s", new Object[]{coll.getId()});
        writer.code("result.get%s().clear();", new Object[]{GenUtil.capitalize((String)coll.getId())});
        MetaRegistry metaRegistry = ctx.getMetaRegistry();
        boolean bl = entityRef = metaRegistry.getEntities().containsKey(coll.getElementType()) || metaRegistry.getEntityRefs().containsKey(coll.getElementType());
        if (!coll.isSystem()) {
            writer.beginBlock("if (preferredProperties.isEmpty() || preferredProperties.contains(\"%s\"))", new Object[]{coll.getId()});
        }
        if (ModelCodeGenHelper.isNestedEntityReferenceType((String)coll.getElementType())) {
            writer.beginBlock("if (%s != null)", new Object[]{coll.getId()});
            writer.code("final String[] uidBunch = %s;", new Object[]{coll.getId()});
            writer.code("final String[] classNameBunch = %sEntityClassName;", new Object[]{coll.getId()});
            writer.code("final String[] captions = %sReferenceCaption;", new Object[]{coll.getId()});
            writer.code("final int count = Math.min(uidBunch.length, classNameBunch.length);", new Object[]{coll.getId()});
            writer.beginBlock("for (int i = 0; i < count; i++)", new Object[]{coll.getId()});
            writer.code("final String item = uidBunch[i];", new Object[0]);
            writer.beginBlock("if (!%s.isBlank(item))", new Object[]{TextUtil.class.getName()});
            writer.beginBlock("try", new Object[0]);
            writer.code("final String[] uids = item.split(\"\\\\|\");", new Object[0]);
            writer.code("final String nestedEntityUid = uids[0];", new Object[0]);
            writer.code("final String uid = uids[1];", new Object[0]);
            writer.code("final String[] classNames = classNameBunch[i].split(\"\\\\|\");", new Object[]{coll.getId()});
            MiscUtil.Pair types = ModelCodeGenHelper.getNestedEntityReferenceTypes((String)coll.getElementType());
            String mainType = (String)types.getFirst();
            String nestedType = (String)types.getSecond();
            writer.code("String nestedEntityClassName = classNames[0];", new Object[0]);
            for (String renamer : ModelCodeGenHelper.getEntityRenamersClassNames((MetaRegistry)ctx.getMetaRegistry(), (String)nestedType)) {
                writer.beginBlock("if(%s.get().findEntityRenamer(\"%s\") != null)", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.code("nestedEntityClassName = %s.get().findEntityRenamer(\"%s\").renameIndexClassNameField(className);", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.endBlock();
            }
            writer.code("String className = classNames[1];", new Object[0]);
            for (String renamer : ModelCodeGenHelper.getEntityRenamersClassNames((MetaRegistry)ctx.getMetaRegistry(), (String)mainType)) {
                writer.beginBlock("if(%s.get().findEntityRenamer(\"%s\") != null)", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.code("className = %s.get().findEntityRenamer(\"%s\").renameIndexClassNameField(className);", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.endBlock();
            }
            writer.code("final Class<%s> nestedEntityType = (Class<%1$s>) %s.getClass(nestedEntityClassName);", new Object[]{nestedType, XHelper.class.getName()});
            writer.code("final Class<%s> etType = (Class<%1$s>) %s.getClass(className);", new Object[]{mainType, XHelper.class.getName()});
            writer.code("final String caption = i < captions.length ? captions[i] : null;", new Object[0]);
            writer.code("result.get%s().add(item != null ? new %s<%s, %s>(uid, etType, nestedEntityUid, nestedEntityType, caption) : null);", new Object[]{GenUtil.capitalize((String)coll.getId()), NestedEntityReference.class.getName(), types.getFirst(), types.getSecond()});
            writer.restartBlock("catch(Exception e)", new Object[0]);
            writer.code("%s.getLogger(getClass()).error(\"error occured while setting property %s\", e);", new Object[]{LoggerFactory.class.getName(), coll.getId()});
            writer.endBlock();
            writer.endBlock();
            writer.endBlock();
            writer.endBlock();
        } else if (!entityRef) {
            writer.beginBlock("if (%s != null)", new Object[]{coll.getId()});
            String type = ArrayCollectionGenerator.getType(coll, ctx);
            if ("String".equals(type)) {
                writer.code("java.util.Arrays.stream(%s).filter(%s::nonBlank).forEach(result.get%s()::add);", new Object[]{coll.getId(), TextUtil.class.getName(), GenUtil.capitalize((String)coll.getId())});
            } else if (metaRegistry.getDictionaries().containsKey(coll.getElementType())) {
                writer.code("java.util.Arrays.stream(%s).filter(%s::nonBlank).map(%sReference::new).forEach(result.get%s()::add);", new Object[]{coll.getId(), TextUtil.class.getName(), coll.getElementType(), GenUtil.capitalize((String)coll.getId())});
            } else if (metaRegistry.getEntities().containsKey(coll.getElementType()) || metaRegistry.getEntityRefs().containsKey(coll.getElementType())) {
                writer.code("java.util.Arrays.stream(%s).filter(%s::nonBlank).map(%s::new).forEach(result.get%s()::add);", new Object[]{coll.getId(), TextUtil.class.getName(), type, GenUtil.capitalize((String)coll.getId())});
            } else if (metaRegistry.getEnums().containsKey(coll.getElementType())) {
                writer.code("java.util.Arrays.stream(%s).filter(%s::nonBlank).map(i->%s.findEnumConstant(%s.class, i)).filter(java.util.Objects::nonNull).forEach(result.get%s()::add);", new Object[]{coll.getId(), TextUtil.class.getName(), CollectionUtil.class.getName(), type, GenUtil.capitalize((String)coll.getId())});
            } else {
                throw new Exception(String.format("fromXML(): unsupported element type %s of collection %s in entity index %s", coll.getElementType(), coll.getId(), bt.getId()));
            }
            writer.endBlock();
        } else {
            writer.beginBlock("if (%s != null)", new Object[]{coll.getId()});
            writer.code("final String[] items = %s;", new Object[]{coll.getId()});
            writer.code("final String[] classNames = %sEntityClassName;", new Object[]{coll.getId()});
            writer.code("final String[] captions = %sReferenceCaption;", new Object[]{coll.getId()});
            writer.code("final int count = Math.min(items.length, classNames.length);", new Object[]{coll.getId()});
            writer.beginBlock("for (int i = 0; i < count; i++)", new Object[]{coll.getId()});
            writer.code("final String item = items[i];", new Object[0]);
            writer.beginBlock("if (%s.nonBlank(item))", new Object[]{TextUtil.class.getName()});
            writer.beginBlock("try", new Object[0]);
            writer.code("String className = classNames[i];", new Object[0]);
            for (String renamer : ModelCodeGenHelper.getEntityRenamersClassNames((MetaRegistry)ctx.getMetaRegistry(), (String)coll.getElementType())) {
                writer.beginBlock("if(%s.get().findEntityRenamer(\"%s\") != null)", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.code("className = %s.get().findEntityRenamer(\"%s\").renameIndexClassNameField(className);", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.endBlock();
            }
            writer.code("final Class<%s> etType = (Class<%1$s>) %s.getClass(className);", new Object[]{coll.getElementType(), XHelper.class.getName()});
            writer.code("final String caption = i < captions.length ? captions[i] : null;", new Object[0]);
            writer.code("result.get%s().add(item != null ? new %s<%s>(item, etType, caption) : null);", new Object[]{GenUtil.capitalize((String)coll.getId()), EntityReference.class.getName(), coll.getElementType(), XHelper.class.getName()});
            writer.restartBlock("catch(Exception e)", new Object[0]);
            writer.code("%s.getLogger(getClass()).error(\"error occurred while setting property %s\", e);", new Object[]{LoggerFactory.class.getName(), coll.getId()});
            writer.endBlock();
            writer.endBlock();
            writer.endBlock();
            writer.endBlock();
        }
        if (!coll.isSystem()) {
            writer.endBlock();
        }
    }

    private static String getType(IndexCollection coll, GenerationContext ctx) {
        String elementType;
        if (ctx.getMetaRegistry().getDictionaries().containsKey(coll.getElementType())) {
            elementType = String.format("%s<%s>", DictionaryReference.class.getName(), coll.getElementType());
        } else if (ModelCodeGenHelper.isNestedEntityReferenceType((String)coll.getElementType())) {
            MiscUtil.Pair types = ModelCodeGenHelper.getNestedEntityReferenceTypes((String)coll.getElementType());
            elementType = String.format("%s<%s, %s>", NestedEntityReference.class.getName(), types.getFirst(), types.getSecond());
        } else if (BaseEntity.class.getName().equals(coll.getElementType())) {
            elementType = EntityReference.class.getName() + "<? extends " + coll.getElementType() + ">";
        } else if (ctx.getMetaRegistry().getDictionaries().containsKey(coll.getElementType())) {
            elementType = coll.getElementType() + "Reference";
        } else if (ctx.getMetaRegistry().getEntities().containsKey(coll.getElementType()) || ctx.getMetaRegistry().getEntityRefs().containsKey(coll.getElementType())) {
            String subtype = coll.getElementType();
            EntityType ett = (EntityType)ctx.getMetaRegistry().getEntities().get(coll.getElementType());
            if (ett == null || ett.isAbstract()) {
                subtype = "? extends " + subtype;
            }
            elementType = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            elementType = "text".equals(coll.getElementType()) || "java.lang.String".equals(coll.getElementType()) ? "String" : coll.getElementType();
        }
        return elementType;
    }

    private ArrayCollectionGenerator() {
    }
}

