/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gen.storage;

import com.gridnine.xtrip.common.gen.CodeGen;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.gen.storage.ArrayCollectionGenerator;
import com.gridnine.xtrip.server.gen.storage.PropertyGenerator;
import com.gridnine.xtrip.server.gen.storage.StorageCodeGen;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayStorageCodeGen
implements CodeGen {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public static boolean isUseArrayStorage() {
        return !StorageCodeGen.isUseArray() && Boolean.getBoolean("com.gridnine.xtrip.server.array-storage-code-gen.use");
    }

    public void generate(GenerationContext ctx) throws Exception {
        if (!ArrayStorageCodeGen.isUseArrayStorage()) {
            return;
        }
        JavaWriter writer = new JavaWriter();
        ArrayList<IndexType> types = new ArrayList<IndexType>();
        for (IndexType ixt : ctx.getMetaRegistry().getIndexes().values()) {
            if (!ctx.getTypeFilter().accept((Object)ixt)) continue;
            this.generateIndexData(writer, ctx, ixt);
            types.add(ixt);
        }
    }

    private void generateIndexData(JavaWriter writer, GenerationContext ctx, IndexType ixt) throws Exception {
        boolean isNestedEntityReference;
        boolean isEntityReference;
        this.log.debug("generating data for index " + ixt.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), ixt.getId() + "DataArray");
        String baseName = GenUtil.getSimpleClassName((String)ixt.getId());
        if (ixt.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.code("@%s(name=\"%sData\")", new Object[]{Entity.class.getName(), baseName});
        Iterator names = new StringBuilder();
        for (IndexProperty prop : ixt.getProperties().values()) {
            if (!prop.isUnique()) continue;
            if (((StringBuilder)((Object)names)).length() > 0) {
                ((StringBuilder)((Object)names)).append(", ");
            }
            ((StringBuilder)((Object)names)).append('\"' + prop.getId() + '\"');
        }
        if (((StringBuilder)((Object)names)).length() > 0) {
            writer.code("@%s(uniqueConstraints=@%s(columnNames={%s}))", new Object[]{Table.class.getName(), UniqueConstraint.class.getName(), names});
        }
        writer.beginBlock("public class %sDataArray extends %s<%s, %s> implements com.gridnine.xtrip.server.db.storage.model.IndexDataArray<%3$s, %4$s, %1$sData>", new Object[]{baseName, BaseIndexData.class.getName(), ixt.getEntityId(), ixt.getId()});
        writer.blank();
        writer.comment("BEGIN properties", new Object[0]);
        writer.code("@%s(nullable = false)", new Object[]{Column.class.getName()});
        writer.code("@%s(name = \"%s_containerUid\")", new Object[]{Index.class.getName(), GenUtil.getSimpleClassName((String)ixt.getId())});
        writer.code("private String containerUid;", new Object[0]);
        writer.blank();
        writer.beginBlock("public String getContainerUid()", new Object[0]);
        writer.code("return containerUid;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.beginBlock("public void setContainerUid(final String value)", new Object[0]);
        writer.code("containerUid = value;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.code("@%s(nullable = false)", new Object[]{Column.class.getName()});
        writer.code("@%s(name = \"%s_entityType\")", new Object[]{Index.class.getName(), GenUtil.getSimpleClassName((String)ixt.getId())});
        writer.code("private String entityType;", new Object[0]);
        writer.blank();
        writer.beginBlock("public String getEntityType()", new Object[0]);
        writer.code("return entityType;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.beginBlock("public void setEntityType(final String value)", new Object[0]);
        writer.code("entityType = value;", new Object[0]);
        writer.endBlock();
        writer.blank();
        for (IndexProperty prop : ixt.getProperties().values()) {
            PropertyGenerator.generateDataMembers(writer, prop, (BaseType)ixt, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (IndexProperty prop : ixt.getCollections().values()) {
            ArrayCollectionGenerator.generateDataMembers(writer, (IndexCollection)prop, (BaseType)ixt, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public %s toIndex(final %s<String> preferredProperties)", new Object[]{ixt.getId(), Set.class.getName()});
        writer.code("%s result = new %1$s(getUid());", new Object[]{ixt.getId()});
        writer.beginBlock("try", new Object[0]);
        writer.code("Class<%s> entityClass = (Class<%1$s>) %s.getClass(getEntityType());", new Object[]{ixt.getEntityId(), XHelper.class.getName()});
        writer.code("result.setSource(new %s<%s>(getContainerUid(), entityClass, getReferenceCaption()));", new Object[]{EntityReference.class.getName(), ixt.getEntityId()});
        writer.restartBlock("catch(Exception e)", new Object[0]);
        writer.code("result.setSource(null);", new Object[0]);
        writer.code("%s.getLogger(getClass()).error(\"Error occured while setting source of %s\", e);", new Object[]{LoggerFactory.class.getName(), ixt.getId()});
        writer.endBlock();
        writer.code("result.setNavigationKey(getNavigationKey());", new Object[0]);
        writer.code("result.setModified(getModified());", new Object[0]);
        for (IndexProperty prop : ixt.getProperties().values()) {
            PropertyGenerator.generateToIndex(writer, prop, (BaseType)ixt, ctx);
        }
        for (IndexCollection coll : ixt.getCollections().values()) {
            ArrayCollectionGenerator.generateToIndex(writer, coll, (BaseType)ixt, ctx);
        }
        writer.code("return result;", new Object[0]);
        writer.endBlock();
        writer.comment("aggregated data support", new Object[0]);
        writer.blank();
        writer.code("@%s", new Object[]{Lob.class.getName()});
        writer.code("@%s(length = 1024 * 1024 * 1024)", new Object[]{Column.class.getName()});
        writer.code("private String aggregatedData;", new Object[0]);
        writer.blank();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public String getAggregatedData()", new Object[0]);
        writer.code("return aggregatedData;", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void setAggregatedData(final String value)", new Object[0]);
        writer.code("aggregatedData = value;", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public %sData toData()", new Object[]{ixt.getId()});
        writer.code("final %sData result = new %1$sData();", new Object[]{ixt.getId()});
        writer.code("result.setUid(getUid());", new Object[0]);
        writer.code("result.setModified(getModified());", new Object[0]);
        writer.code("result.setReferenceCaption(getReferenceCaption());", new Object[0]);
        writer.code("result.setNavigationKey(getNavigationKey());", new Object[0]);
        writer.code("result.setContainerUid(getContainerUid());", new Object[0]);
        writer.code("result.setEntityType(getEntityType());", new Object[0]);
        writer.code("result.setAggregatedData(getAggregatedData());", new Object[0]);
        MetaRegistry metaRegistry = ctx.getMetaRegistry();
        for (IndexProperty prop : ixt.getProperties().values()) {
            writer.code("%s.setValue(result.getClass(), result, \"%s\", %2$s);", new Object[]{ReflectionUtil.class.getName(), prop.getId()});
            isEntityReference = BaseEntity.class.getName().equals(prop.getType()) || metaRegistry.getEntities().containsKey(prop.getType());
            isNestedEntityReference = ModelCodeGenHelper.isNestedEntityReferenceType((String)prop.getType());
            if (!isNestedEntityReference && !isEntityReference) continue;
            writer.code("%s.setValue(result.getClass(), result, \"%sEntityClassName\", %2$sEntityClassName);", new Object[]{ReflectionUtil.class.getName(), prop.getId()});
            writer.code("%s.setValue(result.getClass(), result, \"%sReferenceCaption\", %2$sReferenceCaption);", new Object[]{ReflectionUtil.class.getName(), prop.getId()});
        }
        for (IndexCollection coll : ixt.getCollections().values()) {
            if (ModelCodeGenHelper.isNestedEntityReferenceType((String)coll.getElementType())) {
                writer.code("%s.setValue(result.getClass(), result, \"%s\", %2$s != null ? java.util.Arrays.stream(%2$s).collect(java.util.stream.Collectors.joining(\"||\", \"||\", \"||\")) : null);", new Object[]{ReflectionUtil.class.getName(), coll.getId()});
                writer.code("%s.setValue(result.getClass(), result, \"%sEntityClassName\", %2$sEntityClassName != null ? java.util.Arrays.stream(%2$sEntityClassName).collect(java.util.stream.Collectors.joining(\"||\", \"||\", \"||\")) : null);", new Object[]{ReflectionUtil.class.getName(), coll.getId()});
                writer.code("%s.setValue(result.getClass(), result, \"%sReferenceCaption\", %2$sReferenceCaption != null ? java.util.Arrays.stream(%2$sReferenceCaption).collect(java.util.stream.Collectors.joining(\"||\", \"||\", \"||\")) : null);", new Object[]{ReflectionUtil.class.getName(), coll.getId()});
                continue;
            }
            if (metaRegistry.getEntities().containsKey(coll.getElementType()) || metaRegistry.getEntityRefs().containsKey(coll.getElementType())) {
                writer.code("%s.setValue(result.getClass(), result, \"%s\", %2$s != null ? java.util.Arrays.stream(%2$s).collect(java.util.stream.Collectors.joining(\"|\", \"|\", \"|\")) : null);", new Object[]{ReflectionUtil.class.getName(), coll.getId()});
                writer.code("%s.setValue(result.getClass(), result, \"%sEntityClassName\", %2$sEntityClassName != null ? java.util.Arrays.stream(%2$sEntityClassName).collect(java.util.stream.Collectors.joining(\"|\", \"|\", \"|\")) : null);", new Object[]{ReflectionUtil.class.getName(), coll.getId()});
                writer.code("%s.setValue(result.getClass(), result, \"%sReferenceCaption\", %2$sReferenceCaption != null ? java.util.Arrays.stream(%2$sReferenceCaption).collect(java.util.stream.Collectors.joining(\"|\", \"|\", \"|\")) : null);", new Object[]{ReflectionUtil.class.getName(), coll.getId()});
                continue;
            }
            writer.code("%s.setValue(result.getClass(), result, \"%s\", %2$s != null ? java.util.Arrays.stream(%2$s).collect(java.util.stream.Collectors.joining(\"|\", \"|\", \"|\")) : null);", new Object[]{ReflectionUtil.class.getName(), coll.getId()});
        }
        writer.code("return result;", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void fromData(%1$sData source)", new Object[]{ixt.getId()});
        writer.code("setUid(source.getUid());", new Object[0]);
        writer.code("setModified(source.getModified());", new Object[0]);
        writer.code("setReferenceCaption(source.getReferenceCaption());", new Object[0]);
        writer.code("setNavigationKey(source.getNavigationKey());", new Object[0]);
        writer.code("setContainerUid(source.getContainerUid());", new Object[0]);
        writer.code("setEntityType(source.getEntityType());", new Object[0]);
        writer.code("setAggregatedData(source.getAggregatedData());", new Object[0]);
        metaRegistry = ctx.getMetaRegistry();
        for (IndexProperty prop : ixt.getProperties().values()) {
            writer.code("%s = %s.getValue(source.getClass(), source, \"%1$s\");", new Object[]{prop.getId(), ReflectionUtil.class.getName()});
            isEntityReference = BaseEntity.class.getName().equals(prop.getType()) || metaRegistry.getEntities().containsKey(prop.getType());
            isNestedEntityReference = ModelCodeGenHelper.isNestedEntityReferenceType((String)prop.getType());
            if (!isNestedEntityReference && !isEntityReference) continue;
            writer.code("%sEntityClassName = %s.getValue(source.getClass(), source, \"%1$sEntityClassName\");", new Object[]{prop.getId(), ReflectionUtil.class.getName()});
            writer.code("%sReferenceCaption = %s.getValue(source.getClass(), source, \"%1$sReferenceCaption\");", new Object[]{prop.getId(), ReflectionUtil.class.getName()});
        }
        for (IndexCollection coll : ixt.getCollections().values()) {
            if (ModelCodeGenHelper.isNestedEntityReferenceType((String)coll.getElementType())) {
                writer.code("%s = java.util.Arrays.stream(%s.guarded((String)%s.getValue(source.getClass(), source, \"%1$s\")).split(\"\\\\|\\\\|\")).filter(com.gridnine.xtrip.common.util.TextUtil::nonBlank).toArray(String[]::new);", new Object[]{coll.getId(), MiscUtil.class.getName(), ReflectionUtil.class.getName()});
                writer.code("%sEntityClassName = java.util.Arrays.stream(%s.guarded((String)%s.getValue(source.getClass(), source, \"%1$sEntityClassName\")).split(\"\\\\|\\\\|\")).filter(com.gridnine.xtrip.common.util.TextUtil::nonBlank).toArray(String[]::new);", new Object[]{coll.getId(), MiscUtil.class.getName(), ReflectionUtil.class.getName()});
                writer.code("%sReferenceCaption = java.util.Arrays.stream(%s.guarded((String)%s.getValue(source.getClass(), source, \"%1$sReferenceCaption\")).split(\"\\\\|\\\\|\")).filter(com.gridnine.xtrip.common.util.TextUtil::nonBlank).toArray(String[]::new);", new Object[]{coll.getId(), MiscUtil.class.getName(), ReflectionUtil.class.getName()});
                continue;
            }
            if (metaRegistry.getEntities().containsKey(coll.getElementType()) || metaRegistry.getEntityRefs().containsKey(coll.getElementType())) {
                writer.code("%s = java.util.Arrays.stream(%s.guarded((String)%s.getValue(source.getClass(), source, \"%1$s\")).split(\"\\\\|\")).filter(com.gridnine.xtrip.common.util.TextUtil::nonBlank).toArray(String[]::new);", new Object[]{coll.getId(), MiscUtil.class.getName(), ReflectionUtil.class.getName()});
                writer.code("%sEntityClassName = java.util.Arrays.stream(%s.guarded((String)%s.getValue(source.getClass(), source, \"%1$sEntityClassName\")).split(\"\\\\|\")).filter(com.gridnine.xtrip.common.util.TextUtil::nonBlank).toArray(String[]::new);", new Object[]{coll.getId(), MiscUtil.class.getName(), ReflectionUtil.class.getName()});
                writer.code("%sReferenceCaption = java.util.Arrays.stream(%s.guarded((String)%s.getValue(source.getClass(), source, \"%1$sReferenceCaption\")).split(\"\\\\|\")).filter(com.gridnine.xtrip.common.util.TextUtil::nonBlank).toArray(String[]::new);", new Object[]{coll.getId(), MiscUtil.class.getName(), ReflectionUtil.class.getName()});
                continue;
            }
            writer.code("%s = java.util.Arrays.stream(%s.guarded((String)%s.getValue(source.getClass(), source, \"%1$s\")).split(\"\\\\|\")).filter(com.gridnine.xtrip.common.util.TextUtil::nonBlank).toArray(String[]::new);", new Object[]{coll.getId(), MiscUtil.class.getName(), ReflectionUtil.class.getName()});
        }
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private String getCommonPackageName(List<IndexType> types) {
        if (types.size() == 1) {
            return GenUtil.getPackageName((String)types.get(0).getId());
        }
        ArrayList<String> ids = new ArrayList<String>(types.size());
        for (IndexType indexType : types) {
            ids.add(GenUtil.getPackageName((String)indexType.getId()));
        }
        String result = ArrayStorageCodeGen.getCommonPackageName(ids.toArray(new String[ids.size()]));
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String getCommonPackageName(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        String result = null;
        for (String string : strings) {
            if (string == null) continue;
            result = result == null ? string : ArrayStorageCodeGen.getCommonPackageName(result, string);
        }
        return result;
    }

    private static String getCommonPackageName(String str1, String str2) {
        if (str2.startsWith(str1)) {
            return str1;
        }
        int p = str1.lastIndexOf(46);
        while (p != -1) {
            String str = str1.substring(0, p);
            if (str2.startsWith(str)) {
                return str;
            }
            p = str1.lastIndexOf(46, p - 1);
        }
        return "";
    }
}

