/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gen.storage;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;
import org.slf4j.LoggerFactory;

public final class PropertyGenerator {
    static void generateDataMembers(JavaWriter writer, IndexProperty prop, BaseType bt, GenerationContext ctx) throws Exception {
        String type = PropertyGenerator.getType(prop, ctx.getMetaRegistry());
        MetaRegistry metaRegistry = ctx.getMetaRegistry();
        if (metaRegistry.getEnums().containsKey(prop.getType())) {
            writer.code("@%s(%s.%s)", new Object[]{Enumerated.class.getName(), EnumType.class.getName(), EnumType.STRING.name()});
        } else if ("text".equals(prop.getType()) || prop.isLocalizable()) {
            writer.code("@%s", new Object[]{Lob.class.getName()});
            writer.code("@%s(length = 1024 * 1024 * 1024)", new Object[]{Column.class.getName()});
        } else if (Date.class.getName().equals(prop.getType())) {
            writer.code("@%s(%s.%s)", new Object[]{Temporal.class.getName(), TemporalType.class.getName(), TemporalType.TIMESTAMP.name()});
        } else if ("byte[]".equals(prop.getType())) {
            writer.code("@%s", new Object[]{Lob.class.getName()});
            writer.code("@%s(length = 1024 * 1024 * 1024)", new Object[]{Column.class.getName()});
        }
        if (prop.isSearchable() && prop.isDbIndexed()) {
            writer.code("@%s(name = \"%s_%s\")", new Object[]{Index.class.getName(), GenUtil.getSimpleClassName((String)bt.getId()), prop.getId()});
        }
        boolean isDictionary = metaRegistry.getDictionaries().containsKey(prop.getType());
        boolean isEntityReference = BaseEntity.class.getName().equals(prop.getType()) || metaRegistry.getEntities().containsKey(prop.getType());
        boolean isNestedEntityReference = ModelCodeGenHelper.isNestedEntityReferenceType((String)prop.getType());
        String id = prop.getId();
        if (isNestedEntityReference || isEntityReference) {
            writer.code("private String %s;", new Object[]{id});
            writer.code("private String %sEntityClassName;", new Object[]{id});
            writer.code("private String %sReferenceCaption;", new Object[]{id});
        } else if (isDictionary) {
            writer.code("private String %s;", new Object[]{id});
        } else if ("boolean".equals(prop.getType())) {
            writer.code("private Boolean %s = Boolean.FALSE;", new Object[]{id});
        } else {
            writer.code("private %s %s;", new Object[]{type, id});
        }
        writer.blank();
        if (prop.isLocalizable()) {
            writer.beginBlock("public void set%s(final %s value)", new Object[]{GenUtil.capitalize((String)id), L10nString.class.getName()});
        } else {
            writer.beginBlock("public void set%s(final %s value)", new Object[]{GenUtil.capitalize((String)id), type});
        }
        if (isNestedEntityReference) {
            writer.code("this.%s = value != null? value.getNestedEntityUid() + \"||\" + value.getUid() : null;", new Object[]{id});
            writer.code("this.%sEntityClassName = value != null? value.getNestedEntityType().getName() + \"||\" + value.getType().getName() : null;", new Object[]{id});
            writer.code("this.%sReferenceCaption = value != null? value.toString() : null;", new Object[]{id});
        } else if (isEntityReference) {
            writer.code("this.%s = value != null? value.getUid() : null;", new Object[]{id});
            writer.code("this.%sEntityClassName = value != null? value.getType().getName() : null;", new Object[]{id});
            writer.code("this.%sReferenceCaption = value != null? value.toString() : null;", new Object[]{id});
        } else if (isDictionary) {
            writer.code("this.%s = value != null? value.getCode() : null;", new Object[]{id});
        } else if (prop.isLocalizable()) {
            writer.code("this.%s = value.getStringValue();", new Object[]{id});
        } else {
            writer.code("this.%s = value;", new Object[]{id});
        }
        if (prop.isAggregated()) {
            writer.blank();
            writer.code("if (aggregator != null) aggregator.aggregate(value);", new Object[0]);
        }
        writer.endBlock();
    }

    static void generateToIndex(JavaWriter writer, IndexProperty prop, BaseType bt, GenerationContext ctx) throws Exception {
        boolean isEntityReference;
        String id = prop.getId();
        writer.comment("PROPERTY %s", new Object[]{id});
        if (!prop.isSystem()) {
            writer.beginBlock("if (preferredProperties.isEmpty() || preferredProperties.contains(\"%s\"))", new Object[]{id});
        }
        MetaRegistry metaRegistry = ctx.getMetaRegistry();
        boolean isDictionary = metaRegistry.getDictionaries().containsKey(prop.getType());
        boolean bl = isEntityReference = BaseEntity.class.getName().equals(prop.getType()) || metaRegistry.getEntities().containsKey(prop.getType());
        if (ModelCodeGenHelper.isNestedEntityReferenceType((String)prop.getType())) {
            MiscUtil.Pair types = ModelCodeGenHelper.getNestedEntityReferenceTypes((String)prop.getType());
            writer.beginBlock("try", new Object[0]);
            writer.beginBlock("if (%s != null)", new Object[]{id});
            writer.code("String[] uids = %s.split(\"[|]{2}\");", new Object[]{id});
            writer.code("String[] classNames = %sEntityClassName.split(\"[|]{2}\");", new Object[]{id});
            writer.code("String nestedEntityUid = uids[0];", new Object[]{id});
            writer.code("String uid = uids[1];", new Object[]{id});
            writer.code("Class<%s> nestedEntityType = (Class<%1$s>) %s.getClass(classNames[0]);", new Object[]{types.getSecond(), XHelper.class.getName()});
            writer.code("Class<%s> etType = (Class<%1$s>) %s.getClass(classNames[1]);", new Object[]{types.getFirst(), XHelper.class.getName()});
            writer.code("result.set%s(new %s<%s, %s>(new %s<%s>(uid, etType, null), nestedEntityUid, nestedEntityType, %sReferenceCaption));", new Object[]{GenUtil.capitalize((String)id), NestedEntityReference.class.getName(), types.getFirst(), types.getSecond(), EntityReference.class.getName(), types.getFirst(), id});
            writer.restartBlock("else", new Object[0]);
            writer.code("result.set%s(null);", new Object[]{GenUtil.capitalize((String)id)});
            writer.endBlock();
            writer.restartBlock("catch(Exception e)", new Object[0]);
            writer.code("result.set%s(null);", new Object[]{GenUtil.capitalize((String)id)});
            writer.code("%s.getLogger(getClass()).error(\"error occured while setting property %s\", e);", new Object[]{LoggerFactory.class.getName(), id});
            writer.endBlock();
        } else if (isEntityReference) {
            writer.beginBlock("try", new Object[0]);
            writer.beginBlock("if (%s != null)", new Object[]{id});
            writer.code("String className = %sEntityClassName;", new Object[]{id});
            for (String renamer : ModelCodeGenHelper.getEntityRenamersClassNames((MetaRegistry)ctx.getMetaRegistry(), (String)prop.getType())) {
                writer.beginBlock("if(%s.get().findEntityRenamer(\"%s\") != null)", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.code("className = %s.get().findEntityRenamer(\"%s\").renameIndexClassNameField(className);", new Object[]{MetaRegistry.class.getName(), renamer});
                writer.endBlock();
            }
            writer.code("Class<%s> etType = (Class<%1$s>) %s.getClass(className);", new Object[]{prop.getType(), XHelper.class.getName()});
            writer.code("result.set%s(new %s<%s>(%4$s, etType, %4$sReferenceCaption));", new Object[]{GenUtil.capitalize((String)id), EntityReference.class.getName(), prop.getType(), id});
            writer.restartBlock("else", new Object[0]);
            writer.code("result.set%s(null);", new Object[]{GenUtil.capitalize((String)id)});
            writer.endBlock();
            writer.restartBlock("catch(Exception e)", new Object[0]);
            writer.code("result.set%s(null);", new Object[]{GenUtil.capitalize((String)id)});
            writer.code("%s.getLogger(getClass()).error(\"error occured while setting property %s\", e);", new Object[]{LoggerFactory.class.getName(), id});
            writer.endBlock();
        } else if (isDictionary) {
            writer.code("result.set%s((%s != null) ? new %sReference(%2$s) : null);", new Object[]{GenUtil.capitalize((String)id), id, prop.getType()});
        } else if (prop.isLocalizable()) {
            writer.code("result.get%s().setStringValue(%s);", new Object[]{GenUtil.capitalize((String)id), id});
        } else if (Date.class.getName().equals(prop.getType())) {
            writer.code("result.set%s(%s.cloneDate(%s));", new Object[]{GenUtil.capitalize((String)id), MiscUtil.class.getName(), id});
        } else if ("boolean".equals(prop.getType())) {
            writer.code("result.set%s(%s == null ? false : %s.booleanValue());", new Object[]{GenUtil.capitalize((String)id), id, id});
        } else {
            writer.code("result.set%s(%s);", new Object[]{GenUtil.capitalize((String)id), id});
        }
        if (!prop.isSystem()) {
            writer.endBlock();
        }
    }

    public static String getType(IndexProperty prop, MetaRegistry metaRegistry) {
        String type;
        EntityType ett = (EntityType)metaRegistry.getEntities().get(prop.getType());
        if (metaRegistry.getDictionaries().containsKey(prop.getType())) {
            type = String.format("%s<%s>", DictionaryReference.class.getName(), prop.getType());
        } else if (ModelCodeGenHelper.isNestedEntityReferenceType((String)prop.getType())) {
            MiscUtil.Pair types = ModelCodeGenHelper.getNestedEntityReferenceTypes((String)prop.getType());
            type = String.format("%s<%s, %s>", NestedEntityReference.class.getName(), types.getFirst(), types.getSecond());
        } else if (BaseEntity.class.getName().equals(prop.getType())) {
            type = EntityReference.class.getName() + "<? extends " + prop.getType() + ">";
        } else if (metaRegistry.getEntities().containsKey(prop.getType())) {
            String subtype = ett.isAbstract() ? "? extends " + ett.getId() : ett.getId();
            type = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            type = "text".equals(prop.getType()) ? "String" : ("boolean".equals(prop.getType()) ? "Boolean" : prop.getType());
        }
        return type;
    }

    private PropertyGenerator() {
    }
}

