/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gen.storage;

import com.gridnine.xtrip.common.gen.CodeGen;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.PersistedClasses;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.gen.storage.ArrayStorageCodeGen;
import com.gridnine.xtrip.server.gen.storage.CollectionGenerator;
import com.gridnine.xtrip.server.gen.storage.PropertyGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCodeGen
implements CodeGen {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public static boolean isUseArray() {
        return Boolean.getBoolean("com.gridnine.xtrip.server.storage-code-gen.use-array");
    }

    public void generate(GenerationContext ctx) throws Exception {
        JavaWriter writer = new JavaWriter();
        ArrayList<IndexType> types = new ArrayList<IndexType>();
        for (IndexType ixt : ctx.getMetaRegistry().getIndexes().values()) {
            if (!ctx.getTypeFilter().accept((Object)ixt)) continue;
            this.generateIndexData(writer, ctx, ixt);
            types.add(ixt);
        }
        this.generatePersistedClassesDescriptor(writer, ctx, types);
        new ArrayStorageCodeGen().generate(ctx);
    }

    private void generateIndexData(JavaWriter writer, GenerationContext ctx, IndexType ixt) throws Exception {
        this.log.debug("generating data for index " + ixt.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), ixt.getId() + "Data");
        String baseName = GenUtil.getSimpleClassName((String)ixt.getId());
        if (ixt.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.code("@%s", new Object[]{Entity.class.getName()});
        Iterator names = new StringBuilder();
        for (IndexProperty prop : ixt.getProperties().values()) {
            if (!prop.isUnique()) continue;
            if (((StringBuilder)((Object)names)).length() > 0) {
                ((StringBuilder)((Object)names)).append(", ");
            }
            ((StringBuilder)((Object)names)).append('\"' + prop.getId() + '\"');
        }
        if (((StringBuilder)((Object)names)).length() > 0) {
            writer.code("@%s(uniqueConstraints=@%s(columnNames={%s}))", new Object[]{Table.class.getName(), UniqueConstraint.class.getName(), names});
        }
        writer.beginBlock("public class %sData extends %s<%s, %s>", new Object[]{baseName, BaseIndexData.class.getName(), ixt.getEntityId(), ixt.getId()});
        writer.blank();
        writer.code("private static final long serialVersionUID = %sL;", new Object[]{GenUtil.generateSerialVersionUID((String)ixt.getId(), (Map)ixt.getProperties())});
        writer.blank();
        writer.code("@javax.persistence.Transient", new Object[0]);
        writer.code("private com.gridnine.xtrip.server.db.storage.model.DataAggregator aggregator = null;", new Object[0]);
        writer.blank();
        writer.beginBlock("public void setAggregator(com.gridnine.xtrip.server.db.storage.model.DataAggregator value)", new Object[0]);
        writer.code("this.aggregator = value;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.comment("BEGIN properties", new Object[0]);
        writer.code("@%s(nullable = false)", new Object[]{Column.class.getName()});
        writer.code("@%s(name = \"%s_containerUid\")", new Object[]{Index.class.getName(), GenUtil.getSimpleClassName((String)ixt.getId())});
        writer.code("private String containerUid;", new Object[0]);
        writer.blank();
        writer.beginBlock("public String getContainerUid()", new Object[0]);
        writer.code("return containerUid;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.beginBlock("public void setContainerUid(final String value)", new Object[0]);
        writer.code("containerUid = value;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.code("@%s(nullable = false)", new Object[]{Column.class.getName()});
        writer.code("@%s(name = \"%s_entityType\")", new Object[]{Index.class.getName(), GenUtil.getSimpleClassName((String)ixt.getId())});
        writer.code("private String entityType;", new Object[0]);
        writer.blank();
        writer.beginBlock("public String getEntityType()", new Object[0]);
        writer.code("return entityType;", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.beginBlock("public void setEntityType(final String value)", new Object[0]);
        writer.code("entityType = value;", new Object[0]);
        writer.endBlock();
        writer.blank();
        for (IndexProperty prop : ixt.getProperties().values()) {
            PropertyGenerator.generateDataMembers(writer, prop, (BaseType)ixt, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (IndexProperty prop : ixt.getCollections().values()) {
            CollectionGenerator.generateDataMembers(writer, (IndexCollection)prop, (BaseType)ixt, ctx);
        }
        writer.comment("END collections", new Object[0]);
        int index = ixt.getId().lastIndexOf(".");
        String instrumentedIndexClassName = String.format("%s.Instrumented%s", ixt.getId().substring(0, index), ixt.getId().substring(index + 1));
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public %s toIndex(final %s<String> preferredProperties)", new Object[]{ixt.getId(), Set.class.getName()});
        writer.code("%s result = %s.get().isStatEnabled()? new %s(getUid()):  new %1$s(getUid());", new Object[]{ixt.getId(), IndexUsageHandler.class.getName(), instrumentedIndexClassName});
        writer.beginBlock("try", new Object[0]);
        writer.code("Class<%s> entityClass = (Class<%1$s>) %s.getClass(getEntityType());", new Object[]{ixt.getEntityId(), XHelper.class.getName()});
        writer.code("result.setSource(new %s<%s>(getContainerUid(), entityClass, getReferenceCaption()));", new Object[]{EntityReference.class.getName(), ixt.getEntityId()});
        writer.restartBlock("catch(Exception e)", new Object[0]);
        writer.code("result.setSource(null);", new Object[0]);
        writer.code("%s.getLogger(getClass()).error(\"Error occured while setting source of %s\", e);", new Object[]{LoggerFactory.class.getName(), ixt.getId()});
        writer.endBlock();
        writer.code("result.setNavigationKey(getNavigationKey());", new Object[0]);
        writer.code("result.setModified(getModified());", new Object[0]);
        for (IndexProperty prop : ixt.getProperties().values()) {
            PropertyGenerator.generateToIndex(writer, prop, (BaseType)ixt, ctx);
        }
        for (IndexCollection coll : ixt.getCollections().values()) {
            CollectionGenerator.generateToIndex(writer, coll, (BaseType)ixt, ctx);
        }
        writer.code("return result;", new Object[0]);
        writer.endBlock();
        writer.comment("aggregated data support", new Object[0]);
        writer.blank();
        writer.code("@%s", new Object[]{Lob.class.getName()});
        writer.code("@%s(length = 1024 * 1024 * 1024)", new Object[]{Column.class.getName()});
        writer.code("private String aggregatedData;", new Object[0]);
        writer.blank();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public String getAggregatedData()", new Object[0]);
        writer.code("return aggregatedData;", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void setAggregatedData(final String value)", new Object[0]);
        writer.code("aggregatedData = value;", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generatePersistedClassesDescriptor(JavaWriter writer, GenerationContext ctx, List<IndexType> types) throws Exception {
        if (types.isEmpty()) {
            return;
        }
        this.log.debug("generating persisted classes descriptor");
        writer.beginCompilationUnit(ctx.getOutFolder(), this.getCommonPackageName(types) + ".storage.ModelPersistedClasses");
        writer.beginBlock("public class ModelPersistedClasses implements %s", new Object[]{PersistedClasses.class.getName()});
        writer.code("private final %s<Class<?>> classes = new %s<Class<?>>();", new Object[]{Collection.class.getName(), ArrayList.class.getName()});
        writer.blank();
        writer.beginBlock();
        for (IndexType ixt : types) {
            writer.code("classes.add(%sData.class);", new Object[]{ixt.getId()});
        }
        writer.endBlock();
        writer.beginBlock("public %s<Class<?>> getClasses()", new Object[]{Collection.class.getName()});
        writer.code("return %s.unmodifiableCollection(classes);", new Object[]{Collections.class.getName()});
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private String getCommonPackageName(List<IndexType> types) {
        if (types.size() == 1) {
            return GenUtil.getPackageName((String)types.get(0).getId());
        }
        ArrayList<String> ids = new ArrayList<String>(types.size());
        for (IndexType indexType : types) {
            ids.add(GenUtil.getPackageName((String)indexType.getId()));
        }
        String result = StorageCodeGen.getCommonPackageName(ids.toArray(new String[ids.size()]));
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String getCommonPackageName(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        String result = null;
        for (String string : strings) {
            if (string == null) continue;
            result = result == null ? string : StorageCodeGen.getCommonPackageName(result, string);
        }
        return result;
    }

    private static String getCommonPackageName(String str1, String str2) {
        if (str2.startsWith(str1)) {
            return str1;
        }
        int p = str1.lastIndexOf(46);
        while (p != -1) {
            String str = str1.substring(0, p);
            if (str2.startsWith(str)) {
                return str;
            }
            p = str1.lastIndexOf(46, p - 1);
        }
        return "";
    }
}

