/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gracefulstop;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gracefulstop.GracefulStoppable;
import com.gridnine.xtrip.common.gracefulstop.ShutdownStatus;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.Service;
import com.gridnine.xtrip.server.ShutdownCoordinator;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.gracefulstop.HealthCheck;
import java.io.File;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulStop
implements ShutdownCoordinator {
    private static final Logger log = LoggerFactory.getLogger(GracefulStop.class);
    private static final String KEY_ENABLED = "graceful-stop.enabled";
    protected AtomicBoolean shutdown = new AtomicBoolean();
    private final CountDownLatch THAT_IS_ALL = new CountDownLatch(1);
    protected final ReentrantLock LOCK = new ReentrantLock();
    private int unbroken = 0;
    private final boolean enabled;

    public GracefulStop() {
        ExtendedProperties props = ServerConfiguration.get().getConfiguration();
        this.enabled = Boolean.parseBoolean(props.getProperty(KEY_ENABLED, "true"));
    }

    public static GracefulStop get() {
        return (GracefulStop)Environment.getPublished(ShutdownCoordinator.class);
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public void shutdown() throws InterruptedException {
        try {
            ShutdownStatus.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.shutdown.getAndSet(true) || !this.enabled) {
            return;
        }
        log.info("graceful stop sequence activated");
        this.initiateShutdown();
        this.waitForCanStop(TimeUnit.MINUTES.toMillis(5L));
        this.stopUnbrokenSequences(-1L);
        log.info("shutdown sequence continues");
    }

    private void initiateShutdown() {
        ServerApplication serverApplication = (ServerApplication)Environment.getPublished(ServerApplication.class);
        Service[] services = serverApplication.getServiceList();
        if (services == null) {
            return;
        }
        for (Service service : services) {
            if (!(service instanceof GracefulStoppable)) continue;
            try {
                log.info("initiate shutdown service " + service);
                ((GracefulStoppable)service).initiateShutdown();
            }
            catch (Throwable t) {
                log.error("failed to initiate shutdown service " + service.getUid(), t);
            }
        }
        for (Object obj : Environment.getPublishedObjects().values()) {
            if (!(obj instanceof GracefulStoppable)) continue;
            try {
                log.info("initiate shutdown " + obj);
                ((GracefulStoppable)obj).initiateShutdown();
            }
            catch (Throwable t) {
                log.error("failed to initiate shutdown", t);
            }
        }
    }

    private void waitForCanStop(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        boolean info = false;
        while (!this.canStop()) {
            if (!info && System.currentTimeMillis() - start > 5000L) {
                info = true;
                log.info("wait for the services can stop...");
            }
            if (timeout >= 0L && System.currentTimeMillis() - start > timeout) {
                log.warn("wait so long that services can stop");
                break;
            }
            Thread.sleep(250L);
        }
    }

    private boolean canStop() {
        ServerApplication serverApplication = (ServerApplication)Environment.getPublished(ServerApplication.class);
        Service[] services = serverApplication.getServiceList();
        if (services != null) {
            for (Service service : services) {
                try {
                    if (service instanceof GracefulStoppable && !((GracefulStoppable)service).canStop()) {
                        return false;
                    }
                }
                catch (Throwable t) {
                    log.error("failed get stop status for service " + service.getUid(), t);
                }
            }
        }
        for (Object obj : Environment.getPublishedObjects().values()) {
            try {
                if (!(obj instanceof GracefulStoppable) || ((GracefulStoppable)obj).canStop()) continue;
                return false;
            }
            catch (Throwable t) {
                log.error("failed get stop status", t);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopUnbrokenSequences(long timeout) throws InterruptedException {
        ReentrantLock lock = this.LOCK;
        lock.lock();
        try {
            if (this.unbroken == 0) {
                log.info("critical unbroken sequence not found");
                this.THAT_IS_ALL.countDown();
            } else {
                log.info("critical unbroken sequence found");
            }
        }
        finally {
            lock.unlock();
        }
        if (this.THAT_IS_ALL.getCount() != 0L) {
            log.info("wait for all done...");
        }
        if (timeout >= 0L) {
            this.THAT_IS_ALL.await(timeout, TimeUnit.MILLISECONDS);
        } else {
            this.THAT_IS_ALL.await();
        }
    }

    public Context getUnbrokenContext() throws ShutdownException {
        return this.getUnbrokenContext(false);
    }

    public Context getUnbrokenContext(boolean force) throws ShutdownException {
        ReentrantLock lock = this.LOCK;
        lock.lock();
        try {
            if (this.shutdown.get() && (!force || this.THAT_IS_ALL.getCount() == 0L)) {
                throw new ShutdownException();
            }
            ++this.unbroken;
        }
        finally {
            lock.unlock();
        }
        return () -> {
            lock.lock();
            try {
                --this.unbroken;
                if (this.shutdown.get() && this.unbroken == 0) {
                    this.THAT_IS_ALL.countDown();
                }
            }
            finally {
                lock.unlock();
            }
        };
    }

    public boolean healthCheck(boolean skipCheckBalance) {
        String sign = GracefulStop.get().getHealthSign(skipCheckBalance);
        try {
            Long.parseLong(sign);
            return true;
        }
        catch (NumberFormatException t) {
            return false;
        }
    }

    public String getXmlHealthSign() {
        return this.getHealthSign(false, true);
    }

    public String getHealthSign(boolean skipCheckBalance) {
        return this.getHealthSign(skipCheckBalance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getHealthSign(boolean skipCheckBalance, boolean xml) {
        try {
            if (new File(Environment.getRootFolder(), ".shutdown").exists()) {
                return "SHUTDOWN";
            }
            if (!skipCheckBalance && HealthCheck.canBalaceOnNode() == xml) {
                return "CAN'T BALANCE ON THE NODE";
            }
            try {
                ServerApplication app = (ServerApplication)Environment.getPublished(ServerApplication.class);
                if (!app.isApplicationStarted()) {
                    return "APPLICATION STARTING...";
                }
            }
            catch (Throwable t) {
                return "APPLICATION ISN'T RUNNING";
            }
            if (this.isShutdown()) {
                return "SHUTDOWN SEQUENCE ACTIVATED";
            }
            long databaseTime = System.currentTimeMillis();
            try {
                if (!HealthCheck.databaseHealthCheck()) {
                    String string = "POTENTIAL DATABASE CONNECTION FAILURE";
                    return string;
                }
            }
            finally {
                LoggerFactory.getLogger((String)"health").debug("health database time=" + Long.toString(System.currentTimeMillis() - databaseTime));
            }
            if (!HealthCheck.lockHealthCheck()) {
                return "POTENTIAL LOCK MANAGER FAILURE";
            }
            if (!HealthCheck.criticalExceptionCheck()) {
                return "POTENTIAL CRITICAL EXCEPTION FAILURE";
            }
            Date time = UpdateIndexFile.get().getModified();
            if (time == null) return "CANT'T GET SERVER PLUGINS SIGNATURE";
            String string = Long.toString(time.getTime());
            return string;
        }
        catch (Throwable t) {
            return "INTERNAL SERVER ERROR";
        }
    }

    public static class ShutdownException
    extends Exception {
        private static final long serialVersionUID = 6529941085793616803L;

        public ShutdownException() {
            super("Shutdown sequence activated");
        }
    }

    public static interface Context {
        public void close();
    }
}

