/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gracefulstop;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.SystemUtils;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheck {
    protected static final Logger healthCheckLog;
    protected static volatile boolean criticalExceptionFound;
    private static final int CRITICAL_EXCEPTION_CHECK_TIMEOUT = 120000;
    private static final Thread criticalExceptionChecker;

    public static boolean databaseHealthCheck() {
        try {
            ExtendedProperties config = ServerConfiguration.get().getConfiguration();
            LogicalStorage.get().authorizeAsSystem((Properties)config);
            boolean bl = LogicalStorage.get().checkHealth();
            return bl;
        }
        catch (Throwable ex) {
            healthCheckLog.error("healthcheck failed", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            LogicalStorage.reset();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lockHealthCheck() {
        try {
            LockManager lockManager = (LockManager)Environment.getPublished(LockManager.class);
            try (NamedLock lock = lockManager.getLock((Object)"healthcheck-".concat(UUID.randomUUID().toString()), 1000L);){
                if (!lock.tryLock("healthcheck", 1L, TimeUnit.SECONDS)) {
                    healthCheckLog.error("healthcheck failed - tryLock returned false");
                    boolean bl = false;
                    return bl;
                }
                lock.unlock();
                return true;
            }
        }
        catch (Throwable ex) {
            healthCheckLog.error("healthcheck failed", ex);
            return false;
        }
    }

    public static boolean canBalaceOnNode() {
        return !new File(Environment.getRootFolder(), ".ban_balance").exists();
    }

    public static boolean criticalExceptionCheck() {
        return !criticalExceptionFound;
    }

    protected static boolean criticalExceptionCheck0() {
        try {
            if (SystemUtils.IS_OS_LINUX) {
                String error;
                Process cmd = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "for f in $(ls logs/midoffice-server.log* | sort -V); do     last=$(grep -ohE 'OutOfMemoryError|LinkageError|\\.ServerApplication : server started$' \"$f\" | tail -n 1);    if [[ \"$last\" = 'OutOfMemoryError' || \"$last\" = 'LinkageError' ]]; then         exit 1;    elif [[ \"$last\" = '.ServerApplication : server started' ]]; then         exit 0;    fi;done;exit 0"});
                int result = cmd.waitFor();
                String out = HealthCheck.getString(cmd.getInputStream());
                if (!TextUtil.isBlank((String)out)) {
                    healthCheckLog.info(out);
                }
                if (!TextUtil.isBlank((String)(error = HealthCheck.getString(cmd.getErrorStream())))) {
                    healthCheckLog.error(error);
                    return false;
                }
                return result == 0;
            }
            return true;
        }
        catch (Throwable ex) {
            healthCheckLog.error("healthcheck failed", ex);
            return false;
        }
    }

    private static String getString(InputStream in) throws IOException {
        int b;
        if (in.available() <= 0) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            baos.write(b);
        }
        return new String(baos.toByteArray(), System.getProperty("file.encoding"));
    }

    static {
        boolean isCheckCriticalException;
        healthCheckLog = LoggerFactory.getLogger((String)"healthcheck");
        criticalExceptionFound = false;
        boolean bl = isCheckCriticalException = "true".equals(System.getProperty("midoffice.health.check-log", "false")) && "true".equals(ServerConfiguration.get().getConfiguration().getProperty("midoffice.health.check-log", "false"));
        if (isCheckCriticalException) {
            criticalExceptionChecker = new Thread(MiscUtil.getSimpleClassName(HealthCheck.class) + "-CriticalExceptionChecker"){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (!criticalExceptionFound) {
                            if (!HealthCheck.criticalExceptionCheck0()) {
                                criticalExceptionFound = true;
                            }
                            try {
                                if (criticalExceptionFound) continue;
                                1.sleep(120000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        return;
                    }
                    catch (Throwable t) {
                        healthCheckLog.error("Unexpected error while check critical exception: " + t.getMessage(), t);
                    }
                }
            };
            criticalExceptionChecker.setDaemon(true);
            criticalExceptionChecker.start();
        } else {
            criticalExceptionChecker = null;
        }
    }
}

