/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.http.sender;

import com.gridnine.xtrip.server.http.sender.HttpDataSenderQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpDataSender {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String METHOD_GET = "get";
    private static final String METHOD_POST = "post";
    private static final String CONTENT_PROPERTY_NAME = "content";
    private static final HostnameVerifier verifier = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sslSession) {
            return true;
        }
    };
    private static final X509TrustManager trustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    protected HttpDataSenderQueue queue;

    public void configure(ExtendedProperties config) throws Exception {
        if (this.queue == null) {
            this.queue = new HttpDataSenderQueue(this.getQueueFileName());
        }
    }

    public void start() throws Exception {
        this.queue.load();
    }

    public void stop() throws Exception {
        if (this.queue != null) {
            this.queue.save();
        }
    }

    public void send() throws Exception {
        this.log.debug(String.format("queue size: %s", this.queue.size()));
        int statusCode = 0;
        for (int i = 0; i < this.queue.size(); ++i) {
            HttpDataSenderQueue.RequestData requestData = this.queue.get(i);
            this.log.debug(String.format("sending request to %s, method = %s, properties = %s,content:\r\n%s", requestData.getUrl(), requestData.getProperties(), requestData.getProperties(), requestData.getContent()));
            statusCode = this.sendData(requestData);
            this.log.debug(String.format("status code: %s", statusCode));
            if (statusCode == 200) {
                this.queue.remove(requestData);
                this.queue.save();
                this.log.debug(String.format("data was send succesfully", new Object[0]));
                --i;
                continue;
            }
            this.log.debug(String.format("data was not send. Will try later...", new Object[0]));
        }
    }

    public boolean addRequestData(HttpDataSenderQueue.RequestData requestData) {
        return this.queue.add(requestData);
    }

    private String getRequestQuery(HttpDataSenderQueue.RequestData requestData) throws Exception {
        StringBuilder requestQuery = new StringBuilder();
        for (Map.Entry<String, String> entry : requestData.getProperties().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (requestQuery.length() > 0) {
                requestQuery.append("&");
            }
            requestQuery.append(String.format("%s=%s", key, URLEncoder.encode(value, requestData.getCharset())));
        }
        if (requestQuery.length() > 0) {
            requestQuery.append("&");
        }
        requestQuery.append(String.format("%s=%s", CONTENT_PROPERTY_NAME, URLEncoder.encode(requestData.getContent(), requestData.getCharset())));
        return requestQuery.toString();
    }

    protected int sendData(HttpDataSenderQueue.RequestData requestData) throws Exception {
        String method = requestData.getMethod();
        if (METHOD_GET.equalsIgnoreCase(method)) {
            return this.getData(requestData);
        }
        if (METHOD_POST.equalsIgnoreCase(method)) {
            return this.postData(requestData);
        }
        throw new Exception(String.format("request method %s is not supported", method));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getData(HttpDataSenderQueue.RequestData requestData) throws Exception {
        String requestQuery = this.getRequestQuery(requestData);
        URL url = new URL(requestData.getUrl() + "?" + requestQuery);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Accept-Charset", requestData.getCharset());
        urlConnection.setRequestProperty("Content-Type", String.format("%s; charset=%s", requestData.getContentType(), requestData.getCharset()));
        if (!requestData.isHostVerify() && HttpsURLConnection.class.isAssignableFrom(urlConnection.getClass())) {
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(verifier);
        }
        if (!requestData.isCertVerify() && HttpsURLConnection.class.isAssignableFrom(urlConnection.getClass())) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
        }
        int statusCode = -1;
        urlConnection.connect();
        BufferedReader reader = null;
        try {
            statusCode = ((HttpURLConnection)urlConnection).getResponseCode();
        }
        catch (IOException e) {
            try {
                reader = new BufferedReader(new InputStreamReader(((HttpURLConnection)urlConnection).getErrorStream()));
                StringBuilder error = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    error.append(line);
                }
                this.log.error(error.toString(), new Throwable(error.toString()));
            }
            catch (IOException ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int postData(HttpDataSenderQueue.RequestData requestData) throws Exception {
        URL url = new URL(requestData.getUrl());
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("Accept-Charset", requestData.getCharset());
        urlConnection.setRequestProperty("Content-Type", String.format("%s; charset=%s", requestData.getContentType(), requestData.getCharset()));
        for (Map.Entry<String, String> entry : requestData.getProperties().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            urlConnection.setRequestProperty(key, value);
        }
        urlConnection.setRequestProperty("Content-Length", String.valueOf(requestData.getContent().getBytes(requestData.getCharset()).length));
        if (!requestData.isHostVerify() && HttpsURLConnection.class.isAssignableFrom(urlConnection.getClass())) {
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(verifier);
        }
        if (!requestData.isCertVerify() && HttpsURLConnection.class.isAssignableFrom(urlConnection.getClass())) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
        }
        int statusCode = -1;
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(urlConnection.getOutputStream(), requestData.getCharset());
            writer.write(requestData.getContent());
            writer.flush();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            int value = statusCode;
            return value;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        BufferedReader reader = null;
        try {
            statusCode = ((HttpURLConnection)urlConnection).getResponseCode();
        }
        catch (IOException e) {
            try {
                reader = new BufferedReader(new InputStreamReader(((HttpURLConnection)urlConnection).getErrorStream()));
                StringBuilder error = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    error.append(line);
                }
                this.log.error(error.toString(), new Throwable(error.toString()));
            }
            catch (IOException e2) {
                this.log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return statusCode;
    }

    protected abstract String getQueueFileName();
}

