/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.http.sender;

import com.gridnine.xtrip.common.Environment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDataSenderQueue {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<RequestData> queue = Collections.synchronizedList(new ArrayList());
    private final File queueFile;

    public HttpDataSenderQueue(String queueFileName) throws IOException {
        this.queueFile = new File(Environment.getDataFolder(), queueFileName);
        if (!this.queueFile.exists()) {
            this.queueFile.createNewFile();
        }
    }

    public boolean add(RequestData queueEntry) {
        return this.queue.add(queueEntry);
    }

    public boolean remove(RequestData queueEntry) {
        return this.queue.remove(queueEntry);
    }

    public RequestData get(int index) {
        return this.queue.get(index);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean save() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.queueFile)));
            oos.writeObject(this.queue.toArray(new RequestData[this.queue.size()]));
            oos.flush();
            oos.close();
            return true;
        }
        catch (IOException e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }

    public boolean load() {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.queueFile)));
            RequestData[] arrayRequests = (RequestData[])objectInputStream.readObject();
            this.queue.clear();
            this.queue.addAll(Arrays.asList(arrayRequests));
            objectInputStream.close();
            return true;
        }
        catch (ClassNotFoundException e) {
            this.log.error("", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("", (Throwable)e);
        }
        return false;
    }

    public static class RequestData
    implements Serializable {
        private static final long serialVersionUID = 5354155332088196272L;
        private String url;
        private String contentType;
        private String charset;
        private String method;
        private final Map<String, String> properties = new HashMap<String, String>();
        private String content;
        private boolean hostVerify;
        private boolean certVerify;

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setHostVerify(boolean hostVerify) {
            this.hostVerify = hostVerify;
        }

        public boolean isHostVerify() {
            return this.hostVerify;
        }

        public void setCertVerify(boolean certVerify) {
            this.certVerify = certVerify;
        }

        public boolean isCertVerify() {
            return this.certVerify;
        }
    }
}

