/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus;

import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;
import java.util.function.Supplier;

public final class IbusHelper {
    public static <E> E getObjectN(MessageContext ctx, String key, Supplier<E> newValue) {
        Objects.requireNonNull(ctx, "missing MessageContext");
        Objects.requireNonNull(key, "missing key");
        Objects.requireNonNull(newValue, "missing SetNewValue");
        Object e = ctx.getObject(key);
        if (e == null) {
            e = newValue.get();
            ctx.putObject(key, e);
        }
        return (E)e;
    }

    public static <E> E getObjectN(MessageContext ctx, Enum key, Supplier<E> newValue) {
        Objects.requireNonNull(key, "missing key");
        return IbusHelper.getObjectN(ctx, MessageContext.enumKeyToString(key), newValue);
    }

    @Deprecated
    public static <E> E getObject(MessageContext ctx, String key, E newObject) {
        Object e = ctx.getObject(key);
        if (e == null) {
            e = newObject;
            ctx.putObject(key, e);
        }
        return (E)e;
    }

    public static <E> E getForceObject(MessageContext ctx, String key, E newObject) {
        ctx.putObject(key, newObject);
        return newObject;
    }

    public static <E> E getForceObject(MessageContext ctx, String key, Supplier<E> newObject) {
        E e = newObject.get();
        ctx.putObject(key, e);
        return e;
    }

    public static <E> E getCopyObject(MessageContext ctx, String key, String copyKey) {
        Object res = ctx.getObject(key);
        ctx.putObject(copyKey, res);
        return (E)res;
    }

    public static <E> E getCopyObjectN(MessageContext ctx, String key, String copyKey, Supplier<E> newValue) {
        Objects.requireNonNull(ctx, "missing MessageContext");
        Objects.requireNonNull(key, "missing key");
        Objects.requireNonNull(copyKey, "missing copyKey");
        Objects.requireNonNull(newValue, "missing SetNewValue");
        Object res = ctx.getObject(key);
        if (res == null) {
            res = newValue.get();
        }
        ctx.putObject(copyKey, res);
        return (E)res;
    }

    public static <E> E getCopyObjectN(MessageContext ctx, Enum<?> key, Enum<?> copyKey, Supplier<E> newValue) {
        return IbusHelper.getCopyObjectN(ctx, key.name(), copyKey.name(), newValue);
    }

    @Deprecated
    public static <E> E getObject(MessageContext ctx, Enum key, E newObject) {
        return IbusHelper.getObject(ctx, key.name(), newObject);
    }

    public static <E> E getForceObject(MessageContext ctx, Enum key, E newObject) {
        return IbusHelper.getForceObject(ctx, key.name(), newObject);
    }

    public static <E> E getForceObject(MessageContext ctx, Enum key, Supplier<E> newObject) {
        return IbusHelper.getForceObject(ctx, key.name(), newObject.get());
    }

    public static <E> E getCopyObject(MessageContext ctx, Enum key, Enum<?> copyKey) {
        return IbusHelper.getCopyObject(ctx, key.name(), copyKey.name());
    }

    public static <E> E getOrDefault(MessageContext ctx, Enum key, Supplier<E> defaultSupplier) {
        return IbusHelper.getOrDefault(ctx, key.name(), defaultSupplier);
    }

    public static <E> E getOrDefault(MessageContext ctx, String key, Supplier<E> defaultSupplier) {
        Object e = ctx.getObject(key);
        return (E)(Objects.isNull(e) ? defaultSupplier.get() : e);
    }
}

