/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus;

import com.gridnine.xtrip.common.jmx.AbstractAnnotatedJmxBean;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.impl.standard.statistics.MulticallNodeStatistics;
import java.util.ArrayList;
import java.util.Collections;
import org.weakref.jmx.Managed;

public class IbusJmxBean
extends AbstractAnnotatedJmxBean {
    private final String appName;
    private static final String DEFAULT_APP_NAME = "Midoffice";

    public IbusJmxBean() {
        this.appName = DEFAULT_APP_NAME;
    }

    public IbusJmxBean(String appName) {
        this.appName = !TextUtil.isBlank((String)appName) ? appName : DEFAULT_APP_NAME;
    }

    protected String getOname() {
        return this.appName + ":name=ibus";
    }

    @Managed
    public int getActiveRoutesCount() {
        return IntegrationBusFacade.get().getActiveRoutesCount();
    }

    @Managed
    public String getMulticallTargets(String id) {
        if (null == id) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (MulticallNodeStatistics.MulticallTargetId key : MulticallNodeStatistics.TARGET_DATA.keySet()) {
            if (!id.equals(key.getMulticallId())) continue;
            targets.add(IntegrationBusHelper.getTargetName(key.getTarget()));
        }
        Collections.sort(targets);
        StringBuilder sb = new StringBuilder();
        sb.append("{\"data\":[");
        boolean f = true;
        for (String target : targets) {
            if (f) {
                f = false;
            } else {
                sb.append(',');
            }
            sb.append("{\"{#TARGET}\":\"").append(target).append("\"}");
        }
        sb.append("]}");
        return sb.toString();
    }
}

