/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus;

import com.gridnine.xtrip.server.ibus.model.AdapterDescription;
import com.gridnine.xtrip.server.ibus.model.AdviceDescription;
import com.gridnine.xtrip.server.ibus.model.BaseElementMetadata;
import com.gridnine.xtrip.server.ibus.model.BaseEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.DebugHandlerDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntegrationBusRegistry {
    private final Map<String, BaseNodeDescription> nodes = new HashMap<String, BaseNodeDescription>();
    private final Map<String, BaseEndpointDescription> endpoints = new HashMap<String, BaseEndpointDescription>();
    private final Map<String, BaseElementMetadata> metadata = new HashMap<String, BaseElementMetadata>();
    private final Map<String, AdapterDescription> requestReplyAdapters = new HashMap<String, AdapterDescription>();
    private final Map<String, AdviceDescription> advices = new HashMap<String, AdviceDescription>();
    private final Map<String, DebugHandlerDescription> debugHandlers = new HashMap<String, DebugHandlerDescription>();

    public BaseNodeDescription getNode(String id) {
        return this.nodes.get(id);
    }

    public <T extends BaseNodeDescription> T getNode(String id, Class<T> cls) {
        return (T)this.nodes.get(id);
    }

    public <T extends BaseNodeDescription> List<T> getAllNodes(Class<T> cls) {
        ArrayList<BaseNodeDescription> result = new ArrayList<BaseNodeDescription>();
        for (BaseNodeDescription item : this.nodes.values()) {
            if (!item.getClass().equals(cls)) continue;
            result.add(item);
        }
        return result;
    }

    public void registerNode(BaseNodeDescription proc) {
        this.nodes.put(proc.getId(), proc);
    }

    public BaseEndpointDescription getEndpoint(String id) {
        return this.endpoints.get(id);
    }

    public <T extends BaseEndpointDescription> T getEndpoint(String id, Class<T> cls) {
        return (T)this.getEndpoint(id);
    }

    public void registerEndpoint(BaseEndpointDescription endpoint) {
        this.endpoints.put(endpoint.getId(), endpoint);
    }

    public void registerDebugHandler(DebugHandlerDescription endpoint) {
        this.debugHandlers.put(endpoint.getId(), endpoint);
    }

    public DebugHandlerDescription getDebugHandler(String id) {
        return this.debugHandlers.get(id);
    }

    public AdapterDescription getRequestReplyAdapter(String id) {
        return this.requestReplyAdapters.get(id);
    }

    public void registerRequestReplyAdapter(AdapterDescription adapter) {
        this.requestReplyAdapters.put(adapter.getId(), adapter);
    }

    public AdviceDescription getAdvice(String id) {
        return this.advices.get(id);
    }

    public void registerAdvice(AdviceDescription adapter) {
        this.advices.put(adapter.getId(), adapter);
    }

    public Collection<AdapterDescription> getAllRequestReplyAdapters() {
        return this.requestReplyAdapters.values();
    }

    public Collection<BaseEndpointDescription> getAllEndpoints() {
        return this.endpoints.values();
    }

    public Collection<AdviceDescription> getAllAdvices() {
        return this.advices.values();
    }

    public BaseElementMetadata getMetadata(String id) {
        return this.metadata.get(id);
    }

    public <T extends BaseElementMetadata> T getMetadata(String id, Class<T> cls) {
        return (T)this.metadata.get(id);
    }

    public void registerMetadata(BaseElementMetadata item) {
        this.metadata.put(item.getId(), item);
    }
}

