/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.components;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.components.Processor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProcessor
implements Processor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void configure(Map<String, String> parameters) {
    }

    protected int parseInt(String value) {
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    protected boolean parseBoolean(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    protected void logDebug(MessageContext ctx, String key, Object ... parameters) {
        this.log(ctx, MessageType.MESSAGE, key, null, parameters);
    }

    protected void logWarn(MessageContext ctx, String key, Throwable t, Object ... parameters) {
        this.log(ctx, MessageType.WARNING, key, t, parameters);
    }

    protected void logError(MessageContext ctx, String key, Throwable t, Object ... parameters) {
        this.log(ctx, MessageType.ERROR, key, t, parameters);
    }

    private void log(MessageContext ctx, MessageType messageType, String key, Throwable t, Object ... parameters) {
        String message = L10nResourcesManager.replace((String)key, (Object[])parameters);
        switch (messageType) {
            case MESSAGE: {
                if (t == null) {
                    this.log.debug(message);
                    break;
                }
                this.log.debug(message, t);
                break;
            }
            case WARNING: {
                if (t == null) {
                    this.log.warn(message);
                    break;
                }
                this.log.warn(message, t);
                break;
            }
            case ERROR: {
                if (t == null) {
                    this.log.error(message);
                    break;
                }
                this.log.error(message, t);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"unexpected message type '{0}'", (Object[])new Object[]{messageType});
            }
        }
        if (t == null) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)messageType, (String)key, (Object[])parameters));
        } else {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)messageType, (String)key, (Throwable)t, (Object[])parameters));
        }
    }
}

