/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.components;

import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.StAXRecorder;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.stream.XMLStreamWriter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugData
implements Serializable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 2230241242918587659L;
    private NodeData currentNode;
    private final NodeData rootNode;
    private final String routeId;
    private boolean hasError;
    private final boolean disabled;
    private static final DateTimeFormatter DTF_JODA_DATETIME = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private final Set<String> dumpedParameters = new HashSet<String>();

    public DebugData(String route, boolean disabledValue) {
        this.rootNode = this.currentNode = new NodeData(route, null, DebugNodeType.ROUTE);
        this.routeId = route;
        this.disabled = disabledValue;
    }

    public void startElement(String elementId, DebugNodeType type) {
        if (this.disabled) {
            return;
        }
        this.currentNode = new NodeData(elementId, this.currentNode, type);
    }

    public void message(String msg) {
        if (this.disabled) {
            return;
        }
        new NodeData((String)"message", (NodeData)this.currentNode, (DebugNodeType)DebugNodeType.MESSAGE).message = msg;
    }

    public void message(String msg, Throwable e) {
        if (this.disabled) {
            return;
        }
        new NodeData((String)"message", (NodeData)this.currentNode, (DebugNodeType)DebugNodeType.MESSAGE).message = String.format("%s, details:\r\n%s", msg, TextUtil.getExceptionStackTrace((Throwable)e));
        this.hasError = this.hasError || e != null;
    }

    public void endBlock() {
        if (this.disabled) {
            return;
        }
        if (this.currentNode == null) {
            return;
        }
        this.currentNode.endTime = System.currentTimeMillis();
        this.currentNode = this.currentNode.parentNode;
    }

    public void endRoute() {
        this.rootNode.endTime = System.currentTimeMillis();
    }

    public XMLStreamWriter getArgumentsDump() {
        if (this.disabled) {
            return null;
        }
        this.currentNode.dump = new StAXRecorder();
        return this.currentNode.dump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addElement(XMLStreamWriter writer, NodeData data, boolean skipRoot) throws Exception {
        NodeData firstElm;
        if (this.disabled) {
            return;
        }
        if (data == null) {
            return;
        }
        if (skipRoot && data.nodeType == DebugNodeType.ROUTE && (firstElm = data.children.peek()) != null) {
            this.addElement(writer, firstElm, false);
            return;
        }
        if (data.nodeType == DebugNodeType.MESSAGE) {
            XSHelper.writeString((XMLStreamWriter)writer, (String)data.nodeType.getElementName(), (String)data.message, (boolean)true);
            return;
        }
        String elementName = data.nodeType.getElementName();
        writer.writeStartElement(elementName);
        try {
            writer.writeAttribute("id", data.nodeId);
            writer.writeAttribute("start", DTF_JODA_DATETIME.print(data.startTime));
            if (data.endTime > 0L) {
                writer.writeAttribute("duration", String.format("%s ms", Long.toString(data.endTime - data.startTime)));
            }
            Iterator<NodeData> it = data.children.iterator();
            while (it.hasNext()) {
                try {
                    if (!it.hasNext()) continue;
                    this.addElement(writer, it.next(), true);
                }
                catch (Exception exception) {}
            }
            try {
                if (data.dump != null) {
                    data.dump.writeTo(writer);
                }
            }
            catch (Exception e) {
                this.log.error("unable to adopt node", (Throwable)e);
            }
        }
        finally {
            writer.writeEndElement();
        }
    }

    public String buildDebugInfo(boolean startDocument) {
        return this.buildDebugInfo(startDocument, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buildDebugInfo(boolean startDocument, List<Pair<String>> addInfoList) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(out));){
                if (startDocument) {
                    writer.writeStartDocument();
                }
                writer.writeStartElement("DebugInfo");
                writer.writeAttribute("prepared", DTF_JODA_DATETIME.print(System.currentTimeMillis()));
                if (!addInfoList.isEmpty()) {
                    writer.writeStartElement("AdditionalInfo");
                    for (Pair<String> pair : addInfoList) {
                        writer.writeStartElement((String)pair.getFirst());
                        writer.writeCharacters((String)pair.getLast());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                NodeData rn = this.rootNode;
                while (rn.parentNode != null) {
                    rn = rn.parentNode;
                }
                this.addElement(writer, rn, false);
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            this.log.error("unable to trace debug info", (Throwable)e);
            return TextUtil.getExceptionStackTrace((Throwable)e);
        }
    }

    public void mergeSubroute(DebugData otherData) {
        if (this.disabled) {
            return;
        }
        NodeData root = otherData.rootNode;
        root.parentNode = this.currentNode;
        this.currentNode.children.add(root);
        this.hasError = this.hasError || otherData.hasError;
    }

    public boolean isHasError() {
        return this.hasError;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public Set<String> getDumpedParameters() {
        return this.dumpedParameters;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public static enum DebugNodeType {
        MESSAGE{

            @Override
            public String getElementName() {
                return "message";
            }

            @Override
            protected NodeType getNodeType() {
                return null;
            }
        }
        ,
        WIRETAP{

            @Override
            public String getElementName() {
                return "wiretap";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.WIRETAP;
            }
        }
        ,
        SUBROUTE{

            @Override
            public String getElementName() {
                return "subroute";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.SUBROUTE;
            }
        }
        ,
        SWITCH{

            @Override
            public String getElementName() {
                return "switch";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.SWITCH;
            }
        }
        ,
        SWITCH_CASE{

            @Override
            public String getElementName() {
                return "case";
            }

            @Override
            protected NodeType getNodeType() {
                return null;
            }
        }
        ,
        SWITCH_OTHERWISE{

            @Override
            public String getElementName() {
                return "otherwise";
            }

            @Override
            protected NodeType getNodeType() {
                return null;
            }
        }
        ,
        MULTICALL{

            @Override
            public String getElementName() {
                return "multicall";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.MULTICALL;
            }
        }
        ,
        TARGET{

            @Override
            public String getElementName() {
                return "target";
            }

            @Override
            protected NodeType getNodeType() {
                return null;
            }
        }
        ,
        ITERATOR{

            @Override
            public String getElementName() {
                return "iterator";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.ITERATOR;
            }
        }
        ,
        ROUTE{

            @Override
            public String getElementName() {
                return "route";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.ROUTE;
            }
        }
        ,
        PROCESSOR{

            @Override
            public String getElementName() {
                return "processor";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.PROCESSOR;
            }
        }
        ,
        ADVICE_BEFORE{

            @Override
            public String getElementName() {
                return "advice_before";
            }

            @Override
            protected NodeType getNodeType() {
                return null;
            }
        }
        ,
        ADVICE_ON_EXCEPTION{

            @Override
            public String getElementName() {
                return "advice_on_exception";
            }

            @Override
            protected NodeType getNodeType() {
                return null;
            }
        }
        ,
        WHILE_LOOP{

            @Override
            public String getElementName() {
                return "while";
            }

            @Override
            protected NodeType getNodeType() {
                return NodeType.WHILE_LOOP;
            }
        }
        ,
        ADVICE_AFTER{

            @Override
            public String getElementName() {
                return "advice_after";
            }

            @Override
            protected NodeType getNodeType() {
                return null;
            }
        };


        public abstract String getElementName();

        protected abstract NodeType getNodeType();

        public static DebugNodeType fromNodeType(NodeType type) {
            for (DebugNodeType nt : DebugNodeType.values()) {
                if (nt.getNodeType() != type) continue;
                return nt;
            }
            return null;
        }
    }

    static class NodeData {
        String nodeId;
        long startTime;
        long endTime;
        final ConcurrentLinkedQueue<NodeData> children = new ConcurrentLinkedQueue();
        NodeData parentNode;
        String message;
        StAXRecorder dump;
        DebugNodeType nodeType;

        public NodeData(String id, NodeData parent, DebugNodeType type) {
            this.nodeId = id;
            this.parentNode = parent;
            this.startTime = System.currentTimeMillis();
            this.nodeType = type;
            if (this.parentNode != null) {
                this.parentNode.children.add(this);
            }
        }

        public String toString() {
            return String.format("%s:%s", new Object[]{this.nodeType, this.nodeId});
        }
    }
}

