/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.components;

import com.gridnine.xtrip.common.ibus.LocalMessageContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContextParent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MessageContext
implements Serializable,
LocalMessageContext.Source {
    public static final String MESSAGES_KEY = "messages";
    private static final String JMS_MESSAGE_KEY = "JMS_MESSAGE_KEY";
    private static final long serialVersionUID = 4533628363581426529L;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private boolean returnFlag;
    private String routeId;
    private MessageContextParent parent;

    public MessageContext() {
    }

    public MessageContext(MessageContextParent parent) {
        this.parent = parent;
    }

    public String getRouteDump() {
        return this.parent == null ? null : this.parent.getDebugData().buildDebugInfo(false);
    }

    public StackTraceElement[] getStackTrace() {
        return this.parent == null ? new StackTraceElement[]{} : this.parent.getStackTrace();
    }

    public <T> T getMandatoryObject(String key) {
        T result = this.getObject(key);
        if (result == null) {
            throw new IllegalArgumentException(String.format("missing parameter '%s' in context", key));
        }
        return result;
    }

    public static String enumKeyToString(Enum<?> key) {
        return key.name();
    }

    @Deprecated
    public void clear() {
        this.data.clear();
    }

    public <T> T getMandatoryObject(Enum<?> key) {
        return this.getMandatoryObject(MessageContext.enumKeyToString(key));
    }

    public <T> T getObject(String key) {
        return (T)this.data.get(key);
    }

    public <T> T getObject(Enum<?> key) {
        return (T)this.data.get(MessageContext.enumKeyToString(key));
    }

    public boolean hasObject(String key) {
        return this.data.get(key) != null;
    }

    public boolean hasObject(Enum<?> key) {
        return this.data.get(MessageContext.enumKeyToString(key)) != null;
    }

    public void putObject(String key, Object value) {
        this.data.put(key, value);
    }

    public <T> T removeObject(String key) {
        return (T)this.data.remove(key);
    }

    public <T> T removeObject(Enum<?> key) {
        return (T)this.data.remove(MessageContext.enumKeyToString(key));
    }

    public void putObject(Enum<?> key, Object value) {
        this.data.put(MessageContext.enumKeyToString(key), value);
    }

    public <T extends Serializable> T getJmsMessage() {
        return (T)((Serializable)this.data.get(JMS_MESSAGE_KEY));
    }

    public void setJmsMessage(Serializable message) {
        this.data.put(JMS_MESSAGE_KEY, message);
    }

    private Map<Date, Message> getMessagesMap() {
        TreeMap result = (TreeMap)this.data.get(MESSAGES_KEY);
        if (result == null) {
            result = new TreeMap();
            this.data.put(MESSAGES_KEY, result);
        }
        return result;
    }

    public void clearMessages() {
        this.getMessagesMap().clear();
    }

    public Collection<Message> getMessagesReadOnly() {
        return new ArrayList<Message>(this.getMessagesMap().values());
    }

    public Collection<SysLogItem> getMessagesAsSysLogItems(EntityReference<? extends BaseEntity> ref, String tag) {
        Map<Date, Message> messagesMap = this.getMessagesMap();
        ArrayList<SysLogItem> result = new ArrayList<SysLogItem>(messagesMap.size());
        for (Map.Entry<Date, Message> entry : messagesMap.entrySet()) {
            SysLogItem item = SysLogHelper.newAuditItem(ref, (String)tag, (Message)entry.getValue());
            item.setDate(entry.getKey());
            result.add(item);
        }
        return result;
    }

    public void mergeMessages(MessageContext other) {
        if (other == null) {
            return;
        }
        this.getMessagesMap().putAll(other.getMessagesMap());
    }

    public void addMessage(Message message) {
        this.getMessagesMap().put(new Date(MiscUtil.getTimestamp()), message);
    }

    public void addMessages(Collection<Message> messages) {
        for (Message message : messages) {
            this.addMessage(message);
        }
    }

    public boolean isHasReturnFlag() {
        return this.returnFlag;
    }

    public void setReturn(boolean returnFlag) {
        this.returnFlag = returnFlag;
    }

    public Map<String, Object> getRawData() {
        return this.data;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getDataSource() {
        StackTraceElement[] stackTrace = this.parent.getStackTrace();
        StackTraceElement last = stackTrace.length > 0 ? stackTrace[0] : null;
        String result = last != null ? this.getRouteId() + ", " + last.getClassName() + "." + last.getMethodName() : this.getRouteId();
        return result.length() <= 255 ? result : result.substring(0, 252) + "...";
    }
}

