/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.StandardIntegrationBusFacadeImpl;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusEndPoint;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusStartPoint;
import com.gridnine.xtrip.server.ibus.model.AdapterDescription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.LoggerFactory;

public class StandardIntegrationBusAdapter
implements IntegrationBusAdapter {
    final IbusStartPoint startPoint;
    private final Set<String> returnParameters = new HashSet<String>();
    private final StandardIntegrationBusFacadeImpl engine;

    public StandardIntegrationBusAdapter(String adapterIdValue, IbusStartPoint startPointValue, IbusEndPoint endPointValue, StandardIntegrationBusFacadeImpl engine) {
        this.startPoint = startPointValue;
        IntegrationBusRegistry registry = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        AdapterDescription adapterDescription = registry.getRequestReplyAdapter(adapterIdValue);
        if (null == adapterDescription) {
            throw new IntegrationBusException("no adapter found with id " + adapterIdValue);
        }
        this.returnParameters.addAll(adapterDescription.getReturnParams());
        this.returnParameters.add("messages");
        this.engine = engine;
    }

    @Override
    public void processSync(Map<String, Object> data) throws IntegrationBusException {
        this.engine.checkShutdown();
        IbusMessage msg = new IbusMessage();
        MessageContext ctx = msg.getMessageContext();
        ctx.getRawData().putAll(data);
        try {
            this.startPoint.sendMessage(msg);
        }
        catch (Exception e) {
            throw new IntegrationBusException((Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String item : this.returnParameters) {
            Object value = ctx.getObject(item);
            if (value == null) continue;
            result.put(item, value);
        }
        if (!result.containsKey("messages")) {
            result.put("messages", new TreeMap());
        }
        data.clear();
        data.putAll(result);
        Throwable e = msg.getException();
        if (e != null) {
            throw new IntegrationBusException(e);
        }
    }

    @Override
    public void sendAsync(final Map<String, Object> data) throws IntegrationBusException {
        this.engine.checkShutdown();
        final String currentUser = LogicalStorage.get().getUser();
        final Locale currentLocale = LocaleManager.get().getCurrentLocale();
        this.engine.getService().execute(new Runnable(){

            @Override
            public void run() {
                LogicalStorage.get().setUser(currentUser);
                Locale locale = currentLocale;
                if (locale != null) {
                    LocaleManager.get().setCurrentLocale(locale);
                }
                IbusMessage msg = new IbusMessage();
                msg.getMessageContext().getRawData().putAll(data);
                try {
                    StandardIntegrationBusAdapter.this.startPoint.sendMessage(msg);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(StandardIntegrationBusAdapter.class).error("unable to execute async route", (Throwable)e);
                }
            }
        });
    }
}

