/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gracefulstop.GracefulStoppable;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.Advice;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.EndpointFactoriesRegistry;
import com.gridnine.xtrip.server.ibus.impl.standard.StandardIntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusElement;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusEndPoint;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusStartPoint;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusIteratorNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusMulticallNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusProcessorNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusRouteNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusSubrouteNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusSwitchNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusWhileLoopNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusWireTapNode;
import com.gridnine.xtrip.server.ibus.model.AdapterDescription;
import com.gridnine.xtrip.server.ibus.model.AdviceDescription;
import com.gridnine.xtrip.server.ibus.model.AdviceMetadata;
import com.gridnine.xtrip.server.ibus.model.BaseElementMetadata;
import com.gridnine.xtrip.server.ibus.model.BaseEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.EmailInEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.EndpointType;
import com.gridnine.xtrip.server.ibus.model.IteratorDescription;
import com.gridnine.xtrip.server.ibus.model.IteratorMetadata;
import com.gridnine.xtrip.server.ibus.model.MulticallDescription;
import com.gridnine.xtrip.server.ibus.model.MulticallMetadata;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import com.gridnine.xtrip.server.ibus.model.ProcessorDescription;
import com.gridnine.xtrip.server.ibus.model.ProcessorMetadata;
import com.gridnine.xtrip.server.ibus.model.RouteDescription;
import com.gridnine.xtrip.server.ibus.model.RoutingKeyMetadata;
import com.gridnine.xtrip.server.ibus.model.SubrouteDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchCaseDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchDefaultDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchDescription;
import com.gridnine.xtrip.server.ibus.model.WhileLoopDescription;
import com.gridnine.xtrip.server.ibus.model.WhileLoopMetadata;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardIntegrationBusFacadeImpl
extends IntegrationBusFacade
implements Disposable,
GracefulStoppable {
    protected static final Logger log = LoggerFactory.getLogger(StandardIntegrationBusFacadeImpl.class);
    private final Map<String, IbusNode> nodesCache = new HashMap<String, IbusNode>();
    private final Map<String, IntegrationBusAdapter> adaptersCache = new HashMap<String, IntegrationBusAdapter>();
    private final Map<String, IbusStartPoint> startPointsCache = new HashMap<String, IbusStartPoint>();
    private final Map<String, IbusEndPoint> endPointsCache = new HashMap<String, IbusEndPoint>();
    private final Map<String, IbusStartPoint> consumersCache = new HashMap<String, IbusStartPoint>();
    protected final ExecutorServiceFacade service;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<String, DebugData> debugDataMap = new ConcurrentHashMap();
    private final Map<EndpointType, IbusStartPoint.IbusStartPointFactory<?>> startPointsFactories = new HashMap();
    private final Map<EndpointType, IbusEndPoint.IbusEndPointFactory<?>> endPointsFactories = new HashMap();
    private final Map<NodeType, IbusNode.IbusNodesFactory<?>> nodesFactories = new HashMap();
    private final Map<String, Advice> advicesCache = new HashMap<String, Advice>();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private final IbusNode.IbusNodesFactoryIntegrationBusCallback ROUTE_CALLBACK = new IbusNode.IbusNodesFactoryIntegrationBusCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <E extends IbusNode> void registerNode(String nodeId, E node) {
            Lock writeLock = StandardIntegrationBusFacadeImpl.this.rwLock.writeLock();
            writeLock.lock();
            try {
                StandardIntegrationBusFacadeImpl.this.nodesCache.put(nodeId, node);
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <N extends IbusNode> N getExistingNode(String nodeId) {
            Lock writeLock = StandardIntegrationBusFacadeImpl.this.rwLock.readLock();
            writeLock.lock();
            try {
                IbusNode ibusNode = (IbusNode)StandardIntegrationBusFacadeImpl.this.nodesCache.get(nodeId);
                return (N)ibusNode;
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public <N extends IbusNode> IbusNode.IbusNodesFactory<N> getFactory(NodeType nodeType) {
            return (IbusNode.IbusNodesFactory)StandardIntegrationBusFacadeImpl.this.nodesFactories.get((Object)nodeType);
        }

        @Override
        public Advice getExistingAdvice(String adviceId) {
            return (Advice)StandardIntegrationBusFacadeImpl.this.advicesCache.get(adviceId);
        }

        @Override
        public void registerAdvice(String adviceId, Advice advice) {
            StandardIntegrationBusFacadeImpl.this.advicesCache.put(adviceId, advice);
        }

        @Override
        public void wireTap(IbusMessage msg, String endpoint, String elementId, IbusElement parent) {
            StandardIntegrationBusFacadeImpl.this.wireTap(msg, endpoint, elementId);
        }

        @Override
        public void execute(Runnable runnable) {
            StandardIntegrationBusFacadeImpl.this.service.execute(runnable);
        }

        @Override
        public <T> Future<T> execute(Callable<T> callable) {
            return StandardIntegrationBusFacadeImpl.this.service.submit(callable);
        }
    };

    public StandardIntegrationBusFacadeImpl() throws Exception {
        StandardIntegrationBusFacadeImpl.checkRegistryConsistency();
        this.service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newCachedThreadPool("ibus");
        EndpointFactoriesRegistry reg = (EndpointFactoriesRegistry)Environment.getPublished(EndpointFactoriesRegistry.class);
        for (IbusStartPoint.IbusStartPointFactory<?> ibusStartPointFactory : reg.getAllStartEndpoints()) {
            this.startPointsFactories.put(ibusStartPointFactory.getType(), ibusStartPointFactory);
        }
        for (IbusEndPoint.IbusEndPointFactory ibusEndPointFactory : reg.getAllEndEndpoints()) {
            this.endPointsFactories.put(ibusEndPointFactory.getType(), ibusEndPointFactory);
        }
        this.nodesFactories.put(NodeType.PROCESSOR, new IbusProcessorNode.IbusProcessorNodeFactory());
        this.nodesFactories.put(NodeType.SUBROUTE, new IbusSubrouteNode.IbusSubrouteNodeFactory());
        this.nodesFactories.put(NodeType.ROUTE, new IbusRouteNode.IbusRouteNodeFactory());
        this.nodesFactories.put(NodeType.ITERATOR, new IbusIteratorNode.IbusIteratorNodeFactory());
        this.nodesFactories.put(NodeType.WHILE_LOOP, new IbusWhileLoopNode.IbusWhileLoopNodeFactory());
        this.nodesFactories.put(NodeType.SWITCH, new IbusSwitchNode.IbusSwitchNodeFactory());
        this.nodesFactories.put(NodeType.WIRETAP, new IbusWireTapNode.IbusWireTapNodeFactory());
        this.nodesFactories.put(NodeType.MULTICALL, new IbusMulticallNode.IbusMulticallNodeFactory());
        this.setupEndpoints();
    }

    public void dispose() {
        this.initiateShutdown();
        if (!this.shutdown.getAndSet(true)) {
            this.service.dispose();
            log.info("ibus shut down");
        }
    }

    public void initiateShutdown() {
        if (!this.shuttingDown.getAndSet(true)) {
            log.info("shutting down ibus");
            this.service.initiateShutdown();
        }
    }

    public boolean canStop() {
        return true;
    }

    @Override
    public boolean isShutdown() {
        return this.shuttingDown.get();
    }

    public ExecutorServiceFacade getService() {
        return this.service;
    }

    void checkShutdown() {
        if (this.shuttingDown.get()) {
            throw new IntegrationBusException("shutdown");
        }
    }

    private void setupEndpoints() throws Exception {
        IntegrationBusRegistry registry = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        for (BaseEndpointDescription desc : registry.getAllEndpoints()) {
            if (desc.getType() != EndpointType.JMS_QUEUE_IN && desc.getType() != EndpointType.RESTFUL_IN) continue;
            this.getStartPoint(desc.getId());
        }
    }

    public static void checkRegistryConsistency() throws Exception {
        log.info("ibus registry check in progress...");
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        for (AdviceDescription adviceDescription : reg.getAllAdvices()) {
            AdviceMetadata adviceMetadata = reg.getMetadata(adviceDescription.getMetadataRef(), AdviceMetadata.class);
            if (TextUtil.isBlank((String)adviceDescription.getMetadataRef()) || adviceMetadata != null) continue;
            throw new IllegalStateException(String.format("advice %s refers to nonexistent metadata ref %s", adviceDescription.getId(), adviceDescription.getMetadataRef()));
        }
        HashSet<String> ids = new HashSet<String>();
        for (RouteDescription route : reg.getAllNodes(RouteDescription.class)) {
            ids.clear();
            log.debug("check route: " + route.getId());
            StandardIntegrationBusFacadeImpl.checkSubroute(route, ids, reg);
        }
        log.info("ibus registry check complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSubroute(SubrouteDescription subroute, Collection<String> ids, IntegrationBusRegistry reg) throws Exception {
        if (null == subroute) {
            throw new NullPointerException();
        }
        String subrouteId = subroute.getId();
        if (ids.contains(subrouteId)) {
            throw Xeption.forDeveloper((String)("invocation cycle detected for subroute " + subrouteId), (Object[])new Object[0]);
        }
        ids.add(subrouteId);
        try {
            for (String adviceId : subroute.getAdvices()) {
                AdviceDescription adviceDesc = reg.getAdvice(adviceId);
                if (null == adviceDesc) {
                    throw Xeption.forDeveloper((String)("advice " + adviceId + " not found for subroute " + subrouteId), (Object[])new Object[0]);
                }
                if (adviceDesc.getBeforeSubrouteRef() != null) {
                    SubrouteDescription beforeDesc = reg.getNode(adviceDesc.getBeforeSubrouteRef(), SubrouteDescription.class);
                    if (null == beforeDesc) {
                        throw Xeption.forDeveloper((String)("before " + adviceDesc.getBeforeSubrouteRef() + " of advice " + adviceId + " not found for subroute " + subrouteId), (Object[])new Object[0]);
                    }
                    StandardIntegrationBusFacadeImpl.checkSubroute(beforeDesc, ids, reg);
                }
                if (adviceDesc.getAfterSubrouteRef() != null) {
                    SubrouteDescription afterDesc = reg.getNode(adviceDesc.getAfterSubrouteRef(), SubrouteDescription.class);
                    if (null == afterDesc) {
                        throw Xeption.forDeveloper((String)("after " + adviceDesc.getAfterSubrouteRef() + " of advice " + adviceId + " not found for subroute " + subrouteId), (Object[])new Object[0]);
                    }
                    StandardIntegrationBusFacadeImpl.checkSubroute(afterDesc, ids, reg);
                }
                if (adviceDesc.getExceptionSubrouteRef() == null) continue;
                SubrouteDescription exceptionDesc = reg.getNode(adviceDesc.getExceptionSubrouteRef(), SubrouteDescription.class);
                StandardIntegrationBusFacadeImpl.checkSubroute(exceptionDesc, ids, reg);
            }
            for (String nodeId : subroute.getNodes()) {
                SubrouteDescription subDesc;
                BaseElementMetadata metadata;
                BaseNodeDescription desc = reg.getNode(nodeId);
                if (null == desc) {
                    throw Xeption.forDeveloper((String)"can't find node {0} in {1}", (Object[])new Object[]{nodeId, subrouteId});
                }
                if (desc instanceof RouteDescription) {
                    throw Xeption.forDeveloper((String)"route {0} not allowed in {1}", (Object[])new Object[]{nodeId, subrouteId});
                }
                if (desc instanceof SubrouteDescription) {
                    StandardIntegrationBusFacadeImpl.checkSubroute((SubrouteDescription)desc, ids, reg);
                    continue;
                }
                if (desc instanceof ProcessorDescription) {
                    metadata = reg.getMetadata(((ProcessorDescription)desc).getMetadataRef(), ProcessorMetadata.class);
                    if (null == metadata) {
                        throw Xeption.forDeveloper((String)"no metadata {0} found for processor {1}", (Object[])new Object[]{((ProcessorDescription)desc).getMetadataRef(), desc.getId()});
                    }
                    try {
                        if (XSHelper.getClass((String)((ProcessorMetadata)metadata).getImplementationClassName(), (boolean)false) != null) continue;
                        throw Xeption.forDeveloper((String)"no implementation class specified from metadata {0} for node {1} in subroute {2}", (Object[])new Object[]{metadata.getId(), nodeId, subrouteId});
                    }
                    catch (Xeption e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw Xeption.forDeveloper((String)"unable to load implementation class {0} from metadata {1} for node {2} in subroute {3}", (Object[])new Object[]{((ProcessorMetadata)metadata).getImplementationClassName(), metadata.getId(), nodeId, subrouteId});
                    }
                }
                if (desc instanceof IteratorDescription) {
                    metadata = reg.getMetadata(((IteratorDescription)desc).getMetadataRef(), IteratorMetadata.class);
                    if (null == metadata) {
                        throw Xeption.forDeveloper((String)"no metadata {0} found for iterator {1}", (Object[])new Object[]{((IteratorDescription)desc).getMetadataRef(), desc.getId()});
                    }
                    try {
                        if (XSHelper.getClass((String)((IteratorMetadata)metadata).getTargetsProviderImpl()) == null) {
                            throw Xeption.forDeveloper((String)"no targets provider class specified from metadata {0} for node {1} in subroute {2}", (Object[])new Object[]{metadata.getId(), nodeId, subrouteId});
                        }
                    }
                    catch (Xeption e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw Xeption.forDeveloper((String)"unable to load targets provider class {0} from metadata {1} for node {2} in subroute {3}", (Object[])new Object[]{((IteratorMetadata)metadata).getTargetsProviderImpl(), metadata.getId(), nodeId, subrouteId});
                    }
                    subDesc = reg.getNode(((IteratorDescription)desc).getSubrouteRef(), SubrouteDescription.class);
                    if (null == subDesc) {
                        throw Xeption.forDeveloper((String)"can't find {0} in {1}", (Object[])new Object[]{((IteratorDescription)desc).getSubrouteRef(), desc});
                    }
                    StandardIntegrationBusFacadeImpl.checkSubroute(subDesc, ids, reg);
                    continue;
                }
                if (desc instanceof MulticallDescription) {
                    metadata = reg.getMetadata(((MulticallDescription)desc).getMetadataRef(), MulticallMetadata.class);
                    try {
                        if (XSHelper.getClass((String)((MulticallMetadata)metadata).getTargetsProviderImpl()) == null) {
                            throw Xeption.forDeveloper((String)"no targets provider class specified from metadata {0} for node {1} in subroute {2}", (Object[])new Object[]{metadata.getId(), nodeId, subrouteId});
                        }
                    }
                    catch (Xeption e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw Xeption.forDeveloper((String)"unable to load targets provider class {0} from metadata {1} for node {2} in subroute {3}", (Object[])new Object[]{((MulticallMetadata)metadata).getTargetsProviderImpl(), metadata.getId(), nodeId, subrouteId});
                    }
                    subDesc = reg.getNode(((MulticallDescription)desc).getSubrouteRef(), SubrouteDescription.class);
                    if (null == subDesc) {
                        throw Xeption.forDeveloper((String)"can't find {0} in {1}", (Object[])new Object[]{((MulticallDescription)desc).getSubrouteRef(), desc});
                    }
                    StandardIntegrationBusFacadeImpl.checkSubroute(subDesc, ids, reg);
                    continue;
                }
                if (desc instanceof WhileLoopDescription) {
                    metadata = reg.getMetadata(((WhileLoopDescription)desc).getMetadataRef(), WhileLoopMetadata.class);
                    try {
                        if (XSHelper.getClass((String)((WhileLoopMetadata)metadata).getConditionProviderClass()) == null) {
                            throw Xeption.forDeveloper((String)"no condition provider class specified from metadata {0} for node {1} in subroute {2}", (Object[])new Object[]{metadata.getId(), nodeId, subrouteId});
                        }
                    }
                    catch (Xeption e) {
                        throw e;
                    }
                    catch (Exception e) {
                        String providerClass = metadata != null ? ((WhileLoopMetadata)metadata).getConditionProviderClass() : "NULL";
                        String metadataId = metadata != null ? metadata.getId() : "NULL";
                        throw Xeption.forDeveloper((String)"unable to load condition provider class {0} from metadata {1} for node {2} in subroute {3}", (Object[])new Object[]{providerClass, metadataId, nodeId, subrouteId});
                    }
                    subDesc = reg.getNode(((WhileLoopDescription)desc).getSubrouteRef(), SubrouteDescription.class);
                    if (null == subDesc) {
                        throw Xeption.forDeveloper((String)"can't find {0} in {1}", (Object[])new Object[]{((WhileLoopDescription)desc).getSubrouteRef(), desc});
                    }
                    StandardIntegrationBusFacadeImpl.checkSubroute(subDesc, ids, reg);
                    continue;
                }
                if (!(desc instanceof SwitchDescription)) continue;
                metadata = reg.getMetadata(((SwitchDescription)desc).getMetadataRef(), RoutingKeyMetadata.class);
                if (null == metadata) {
                    throw Xeption.forDeveloper((String)"no metadata {0} found for switch {1}", (Object[])new Object[]{((SwitchDescription)desc).getMetadataRef(), desc.getId()});
                }
                try {
                    if (XSHelper.getClass((String)((RoutingKeyMetadata)metadata).getKeyProviderClass()) == null) {
                        throw Xeption.forDeveloper((String)"no key provider class specified from metadata {0} for node {1} in subroute {2}", (Object[])new Object[]{metadata.getId(), nodeId, subrouteId});
                    }
                }
                catch (Xeption e) {
                    throw e;
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"unable to load key provider class {0} from metadata {1} for node {2} in subroute {3}", (Object[])new Object[]{((RoutingKeyMetadata)metadata).getKeyProviderClass(), metadata.getId(), nodeId, subrouteId});
                }
                for (SwitchCaseDescription caseNodeDescr : ((SwitchDescription)desc).getCases().values()) {
                    SubrouteDescription caseDesc = reg.getNode(caseNodeDescr.getRef(), SubrouteDescription.class);
                    if (null == caseDesc) {
                        throw Xeption.forDeveloper((String)"can't find {0} in {1}", (Object[])new Object[]{caseNodeDescr.getRef(), desc.getId()});
                    }
                    StandardIntegrationBusFacadeImpl.checkSubroute(caseDesc, ids, reg);
                }
                SwitchDefaultDescription defaultRouteDescr = ((SwitchDescription)desc).getDefaultRoute();
                if (defaultRouteDescr == null) continue;
                SubrouteDescription defaultDesc = reg.getNode(defaultRouteDescr.getRef(), SubrouteDescription.class);
                if (null == defaultDesc) {
                    throw Xeption.forDeveloper((String)"can't find {0} in {1}", (Object[])new Object[]{defaultRouteDescr.getRef(), desc});
                }
                StandardIntegrationBusFacadeImpl.checkSubroute(defaultDesc, ids, reg);
            }
        }
        finally {
            ids.remove(subrouteId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegrationBusAdapter getRequestReplyAdapter(String id) {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            IntegrationBusAdapter adapter = this.adaptersCache.get(id);
            if (adapter != null) {
                IntegrationBusAdapter integrationBusAdapter = adapter;
                return integrationBusAdapter;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            IntegrationBusAdapter adapter = this.adaptersCache.get(id);
            if (adapter != null) {
                IntegrationBusAdapter integrationBusAdapter = adapter;
                return integrationBusAdapter;
            }
            try {
                adapter = this.createAdapter(id);
            }
            catch (Exception e) {
                log.error("unable to create adapter " + id, (Throwable)e);
                throw new IntegrationBusException("unable to create adapter " + id);
            }
            this.adaptersCache.put(id, adapter);
            IntegrationBusAdapter integrationBusAdapter = adapter;
            return integrationBusAdapter;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IbusNode getRoute(String routeId) throws Exception {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            IbusNode route = this.nodesCache.get(routeId);
            if (null != route) {
                IbusNode ibusNode = route;
                return ibusNode;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            IbusNode route = this.nodesCache.get(routeId);
            if (null != route) {
                IbusNode ibusNode = route;
                return ibusNode;
            }
            route = this.createRoute(routeId);
            this.nodesCache.put(routeId, route);
            IbusNode ibusNode = route;
            return ibusNode;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void processRouteSync(String routeId, Map<String, Object> data) throws IntegrationBusException {
        IbusNode route;
        this.checkShutdown();
        try {
            route = this.getRoute(routeId);
        }
        catch (IntegrationBusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IntegrationBusException((Throwable)e);
        }
        IbusMessage msg = new IbusMessage();
        MessageContext ctx = msg.getMessageContext();
        ctx.getRawData().putAll(data);
        try {
            long timing = System.currentTimeMillis();
            route.execute(msg);
            Metrics.get().timingAndEvent("profiling.ibus-execute." + Metrics.cleanKeyPart(routeId), timing);
        }
        catch (Exception e) {
            throw new IntegrationBusException((Throwable)e);
        }
        data.clear();
        data.putAll(ctx.getRawData());
        if (!data.containsKey("messages")) {
            data.put("messages", new TreeMap());
        }
        if ((e = msg.getException()) != null) {
            throw new IntegrationBusException(e);
        }
    }

    @Override
    public void sendRouteAsync(String routeId, Map<String, Object> data) throws IntegrationBusException {
        IbusNode route;
        this.checkShutdown();
        try {
            route = this.getRoute(routeId);
        }
        catch (IntegrationBusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IntegrationBusException((Throwable)e);
        }
        IbusMessage msg = new IbusMessage();
        MessageContext ctx = msg.getMessageContext();
        ctx.getRawData().putAll(data);
        String currentUser = LogicalStorage.get().getUser();
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        this.service.execute(() -> {
            try {
                LogicalStorage.get().setUser(currentUser);
                if (currentLocale != null) {
                    LocaleManager.get().setCurrentLocale(currentLocale);
                }
                try {
                    long timing = System.currentTimeMillis();
                    route.execute(msg);
                    Metrics.get().timingAndEvent("profiling.ibus-execute." + Metrics.cleanKeyPart(routeId), timing);
                }
                catch (Exception e) {
                    throw new IntegrationBusException((Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("unable to execute async route", (Throwable)e);
            }
        });
    }

    private IntegrationBusAdapter createAdapter(String id) throws Exception {
        IntegrationBusRegistry registry = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        AdapterDescription adapter = registry.getRequestReplyAdapter(id);
        MiscUtil.Pair<IbusStartPoint, IbusEndPoint> points = this.createEndPoints(adapter.getStartPoint(), adapter.getEndPoint());
        return new StandardIntegrationBusAdapter(id, (IbusStartPoint)points.getFirst(), (IbusEndPoint)points.getSecond(), this);
    }

    private MiscUtil.Pair<IbusStartPoint, IbusEndPoint> createEndPoints(String startPointId, String endPointId) throws Exception {
        IbusStartPoint startPoint = this.startPointsCache.get(startPointId);
        if (null == startPoint) {
            startPoint = this.startPointsCache.get(startPointId);
        }
        if (null == startPoint) {
            startPoint = this.createStartPoint(startPointId);
            this.startPointsCache.put(startPointId, startPoint);
        }
        IbusEndPoint endPoint = endPointId != null ? this.endPointsCache.computeIfAbsent(endPointId, k -> this.endPointsFactories.get((Object)((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getEndpoint(endPointId).getType()).createEndPoint(endPointId)) : null;
        return new MiscUtil.Pair((Object)startPoint, endPoint);
    }

    private void wireTap(IbusMessage msg, String endpoint, String elementId) {
        IbusStartPoint startPoint;
        MessageContext mc = msg.getMessageContext();
        IbusMessage clonedMsg = new IbusMessage();
        MessageContext clonedCtx = clonedMsg.getMessageContext();
        clonedCtx.getRawData().putAll(mc.getRawData());
        clonedCtx.getRawData().remove("messages");
        try {
            startPoint = this.getStartPoint(endpoint);
        }
        catch (Exception e) {
            log.error("unable to create start point " + endpoint, (Throwable)e);
            throw new IllegalArgumentException(String.format("no endpoint is registered for id %s, element = %s", endpoint, elementId));
        }
        String currentUser = LogicalStorage.get().getUser();
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        String parentThreadId = Long.toString(Thread.currentThread().getId());
        String parentThreadName = Thread.currentThread().getName();
        this.service.execute(() -> {
            String currentThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(IntegrationBusHelper.getWireTapThreadName(elementId, parentThreadId, parentThreadName));
            try {
                try {
                    LogicalStorage.get().setUser(currentUser);
                    if (currentLocale != null) {
                        LocaleManager.get().setCurrentLocale(currentLocale);
                    }
                    startPoint.sendMessage(clonedMsg);
                }
                catch (Throwable e) {
                    log.error("unable to execute wire trap route", e);
                }
            }
            finally {
                Thread.currentThread().setName(currentThreadName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IbusStartPoint getStartPoint(String endpoint) throws Exception {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            IbusStartPoint startPoint = this.startPointsCache.get(endpoint);
            if (startPoint != null) {
                IbusStartPoint ibusStartPoint = startPoint;
                return ibusStartPoint;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            IbusStartPoint startPoint = this.startPointsCache.get(endpoint);
            if (startPoint == null) {
                String routeId = this.findRouteByStartPointId(endpoint);
                RouteDescription route = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(routeId, RouteDescription.class);
                startPoint = (IbusStartPoint)this.createEndPoints(endpoint, route.getEndPoint()).getFirst();
            }
            IbusStartPoint ibusStartPoint = startPoint;
            return ibusStartPoint;
        }
        finally {
            writeLock.unlock();
        }
    }

    private IbusStartPoint createStartPoint(final String startPointId) throws Exception {
        final String routeId = this.findRouteByStartPointId(startPointId);
        IbusNode route = this.nodesCache.get(routeId);
        if (null == route) {
            route = this.createRoute(routeId);
            this.nodesCache.put(routeId, route);
        }
        final IbusNode route2 = route;
        return this.startPointsFactories.get((Object)((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getEndpoint(startPointId).getType()).createStartPoint(new IbusStartPoint.IbusStartPointFactoryCallback(){

            @Override
            public void startRoute(IbusMessage msg) throws Exception {
                long timing = System.currentTimeMillis();
                route2.execute(msg);
                Metrics.get().timingAndEvent("profiling.ibus-execute." + Metrics.cleanKeyPart(routeId.contains("auto-") ? startPointId : routeId), timing);
            }

            @Override
            public void execute(Runnable runnable) {
                StandardIntegrationBusFacadeImpl.this.service.execute(runnable);
            }
        }, startPointId);
    }

    private IbusNode createRoute(final String routeId) throws Exception {
        log.debug("publishing route: " + routeId);
        final IbusRouteNode routeNode = (IbusRouteNode)this.nodesFactories.get((Object)NodeType.ROUTE).createNode(routeId, this.ROUTE_CALLBACK);
        final String endPointId = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(routeId, RouteDescription.class).getEndPoint();
        IbusEndPoint endPoint = null;
        if (!TextUtil.isBlank((String)endPointId)) {
            endPoint = this.endPointsCache.computeIfAbsent(endPointId, k -> this.endPointsFactories.get((Object)((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getEndpoint(endPointId).getType()).createEndPoint(endPointId));
        }
        final IbusEndPoint endPoint2 = endPoint;
        return new IbusNode(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(IbusMessage msg) {
                String currentThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName(IntegrationBusHelper.getThreadName(routeId));
                try {
                    DebugData debugData = new DebugData(routeId, routeNode.handler.isDebugDataDisabled(msg.getMessageContext()));
                    msg.setDebugData(debugData);
                    String debugDataId = UUIDGenerator.generate().toString();
                    StandardIntegrationBusFacadeImpl.this.debugDataMap.put(debugDataId, debugData);
                    try {
                        routeNode.execute(msg);
                    }
                    finally {
                        StandardIntegrationBusFacadeImpl.this.debugDataMap.remove(debugDataId);
                    }
                    if (msg.getException() == null) {
                        if (endPoint2 != null) {
                            try {
                                log.debug("outgoing message " + endPointId);
                                endPoint2.sendMessage(msg);
                            }
                            catch (Throwable e) {
                                msg.setException(e);
                            }
                        } else {
                            log.debug("outgoing message " + routeId);
                        }
                    }
                }
                finally {
                    Thread.currentThread().setName(currentThreadName);
                }
            }

            @Override
            public BaseNodeDescription getDescription() {
                return null;
            }
        };
    }

    private String findRouteByStartPointId(String startPointId) {
        for (RouteDescription item : ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getAllNodes(RouteDescription.class)) {
            if (!startPointId.equals(item.getStartPoint())) continue;
            return item.getId();
        }
        throw new IllegalArgumentException(String.format("no route is connected with start point %s", startPointId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IbusStartPoint findEndPointByConsumerId(String id) throws Exception {
        if (null == id) {
            return null;
        }
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            IbusStartPoint endpoint = this.consumersCache.get(id);
            if (endpoint != null) {
                IbusStartPoint ibusStartPoint = endpoint;
                return ibusStartPoint;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            IbusStartPoint endpoint = this.consumersCache.get(id);
            if (endpoint != null) {
                IbusStartPoint ibusStartPoint = endpoint;
                return ibusStartPoint;
            }
            for (BaseEndpointDescription item : ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getAllEndpoints()) {
                if (!(item instanceof EmailInEndpointDescription) || !id.equals(((EmailInEndpointDescription)item).getSettingsUid())) continue;
                endpoint = this.getStartPoint(item.getId());
                this.consumersCache.put(id, endpoint);
                break;
            }
            IbusStartPoint ibusStartPoint = endpoint;
            return ibusStartPoint;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void startConsumer(String id) throws Exception {
        this.checkShutdown();
        IbusStartPoint startPoint = this.findEndPointByConsumerId(id);
        if (null == startPoint) {
            return;
        }
        startPoint.startPolling();
    }

    @Override
    public void refreshConsumer(String id) throws Exception {
        this.checkShutdown();
        IbusStartPoint startPoint = this.findEndPointByConsumerId(id);
        if (null == startPoint) {
            return;
        }
        startPoint.refreshPollingSettings();
    }

    @Override
    public String getRouteDumps() {
        StringBuilder sb = new StringBuilder("<dumps>");
        for (DebugData entry : this.debugDataMap.values()) {
            sb.append("\n").append(entry.buildDebugInfo(false));
        }
        sb.append("\n</dumps>");
        return sb.toString();
    }

    @Override
    public int getActiveRoutesCount() {
        return this.debugDataMap.size();
    }
}

