/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.impl.standard.EndpointFactoriesRegistry;
import com.gridnine.xtrip.server.ibus.impl.standard.StandardIntegrationBusFacadeImpl;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusEndPoint;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusStartPoint;
import com.gridnine.xtrip.server.ibus.parser.IntegrationBusRegistryXmlProcessor;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardIntegrationBusPublisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void publish() throws Exception {
        this.log.info("ibus standard implementation");
        this.register();
        Environment.publish(IntegrationBusFacade.class, (Object)new StandardIntegrationBusFacadeImpl());
        this.log.info("ibus engine ready to use");
    }

    public void register() throws Exception {
        this.publishEndpointHandlers();
        PluginManager pm = PluginManager.lookup((Object)this);
        IntegrationBusRegistry registry = new IntegrationBusRegistry();
        Environment.publish((Object)registry);
        IntegrationBusRegistryXmlProcessor proc = new IntegrationBusRegistryXmlProcessor();
        HashSet<String> registred = new HashSet<String>();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"IntegrationBusDescription")) {
            for (Extension.Parameter param : ext.getParameters("location")) {
                String resource = param.valueAsString();
                if (registred.contains(resource)) continue;
                registred.add(resource);
                this.register(resource, proc, pm, param, registred);
                if (resource.endsWith("/") || pm.getPluginClassLoader(param.getDeclaringPluginDescriptor()).getResources(resource).hasMoreElements()) continue;
                this.register(resource + "/", proc, pm, param, registred);
            }
        }
    }

    private void register(String resource, IntegrationBusRegistryXmlProcessor proc, PluginManager pm, Extension.Parameter param, Set<String> registred) throws Exception {
        Enumeration urls = pm.getPluginClassLoader(param.getDeclaringPluginDescriptor()).getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            File dir = IoUtil.url2file((URL)url);
            if (null == dir) {
                this.log.error("invalid url " + url.toExternalForm());
                continue;
            }
            String local = param.getDeclaringPluginDescriptor().getId() + "/" + resource;
            if (local.endsWith("/")) {
                local = local.substring(0, local.length() - 1);
            }
            this.register(dir, proc, local, registred);
        }
    }

    private void register(File dir, IntegrationBusRegistryXmlProcessor proc, String local, Set<String> registred) throws Exception {
        List<File> files = Arrays.asList(dir.listFiles());
        files.sort(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                int res = this.getTypeIndex(o1) - this.getTypeIndex(o2);
                if (res != 0) {
                    return res;
                }
                return TextUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)false, (boolean)true);
            }

            private int getTypeIndex(File o1) {
                return o1.isFile() ? 0 : 1;
            }
        });
        for (File file : files) {
            URL url;
            String toRegister;
            if (file.isDirectory()) {
                String toRegister2 = file.getCanonicalPath();
                if (registred.contains(toRegister2)) continue;
                registred.add(toRegister2);
                this.register(file, proc, local + "/" + file.getName(), registred);
                continue;
            }
            if (!file.getAbsolutePath().endsWith(".xml") || registred.contains(toRegister = (url = IoUtil.file2url((File)file)).toString())) continue;
            registred.add(toRegister);
            proc.register(url, local + "/" + file.getName());
        }
    }

    private void publishEndpointHandlers() throws Exception {
        EndpointFactoriesRegistry registry = new EndpointFactoriesRegistry();
        Environment.publish((Object)registry);
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm == null) {
            return;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"EndpointFactory")) {
            for (Extension.Parameter param : ext.getParameters("class")) {
                Object factory = JpfUtil.getClass((Extension.Parameter)param).newInstance();
                if (factory instanceof IbusStartPoint.IbusStartPointFactory) {
                    registry.register((IbusStartPoint.IbusStartPointFactory)factory);
                    continue;
                }
                if (factory instanceof IbusEndPoint.IbusEndPointFactory) {
                    registry.register((IbusEndPoint.IbusEndPointFactory)factory);
                    continue;
                }
                throw Xeption.forDeveloper((String)("invalid endpoint factory class " + factory.getClass().getName()), (Object[])new Object[0]);
            }
        }
    }
}

