/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.common;

import com.gridnine.xtrip.common.ibus.Target;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class IntegrationBusHelper {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private static final ThreadLocal<IbusThreadContext> context = new ThreadLocal();

    public static String getTargetName(Object target) {
        String targetStr;
        if (target instanceof Target) {
            targetStr = ((Target)target).getTargetName();
        } else if (target instanceof Enum) {
            targetStr = ((Enum)target).name();
        } else if (target instanceof EntityContainer) {
            EntityContainer ctr = (EntityContainer)target;
            String string = targetStr = ctr.getEntity() instanceof Target ? ((Target)ctr.getEntity()).getTargetName() : null;
            if (TextUtil.isBlank((String)targetStr)) {
                targetStr = ctr.toString();
                if (ctr.getEntity() != null) {
                    if (!TextUtil.isBlank((String)targetStr)) {
                        targetStr = targetStr + ", ";
                    }
                    targetStr = targetStr + ctr.getEntity().toString();
                }
            }
        } else {
            String string = targetStr = target != null ? target.toString() : null;
        }
        if (TextUtil.isBlank((String)targetStr)) {
            targetStr = "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e)";
        }
        return targetStr;
    }

    public static String getThreadName(String id) {
        return String.format("%s%s", IntegrationBusHelper.getPrefixThreadName(id), IntegrationBusHelper.getOwnedBy(Thread.currentThread().getName()));
    }

    protected static String getPrefixThreadName(String id) {
        return IntegrationBusHelper.getPrefixThreadName("id", id);
    }

    protected static String getPrefixThreadName(String name, String id) {
        return String.format("ibus-%s:[%s]-thread:[%s]-start:[%s]", name, id, Long.toString(Thread.currentThread().getId()), DATE_FORMAT.format(new Date()));
    }

    protected static String getOwnedBy(String threadName) {
        return !threadName.startsWith("pool-") ? "\n    owned by: " + threadName : "";
    }

    protected static String getParent(String threadName) {
        return "\n    parent: " + threadName;
    }

    protected static String getWireTaped(String threadName) {
        return "\n    wire tapped by: " + threadName;
    }

    public static String getTargetThreadName(String id, String targetName, String parentThreadId, String parentThreadName) {
        return String.format("%s-target:[%s]-parent:[%s]%s", IntegrationBusHelper.getPrefixThreadName(id), targetName, parentThreadId, IntegrationBusHelper.getParent(parentThreadName));
    }

    public static String getWireTapThreadName(String id, String parentThreadId, String parentThreadName) {
        return String.format("%s-parent:[%s]%s", IntegrationBusHelper.getPrefixThreadName("start-point", id), parentThreadId, IntegrationBusHelper.getWireTaped(parentThreadName));
    }

    public static IbusThreadContext getThreadContext() {
        return context.get();
    }

    public static void setThreadContext(IbusThreadContext ctx) {
        if (ctx == null) {
            context.remove();
            return;
        }
        context.set(ctx);
    }

    public static class IbusThreadContext {
        private String routeId;

        public String getRouteId() {
            return this.routeId;
        }

        public void setRouteId(String value) {
            this.routeId = value;
        }
    }
}

