/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.endpoints;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusStartPoint;
import com.gridnine.xtrip.server.ibus.model.EndpointType;
import com.gridnine.xtrip.server.ibus.model.JmsInEndpointDescription;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.jms.JMSQueueWorker;
import java.io.Serializable;
import org.slf4j.LoggerFactory;

public class IbusJmsQueueInEndpoint
implements IbusStartPoint {
    private final IbusStartPoint.IbusStartPointFactoryCallback clb;

    public IbusJmsQueueInEndpoint(String pointId, IbusStartPoint.IbusStartPointFactoryCallback routeCallback) {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        final JmsInEndpointDescription descr = reg.getEndpoint(pointId, JmsInEndpointDescription.class);
        this.clb = routeCallback;
        ((JMSFacade)Environment.getPublished(JMSFacade.class)).registerQueue(descr.getQueue(), new JMSQueueWorker<Serializable>(){

            @Override
            public boolean processRequest(Serializable message) throws Exception {
                LoggerFactory.getLogger(IbusJmsQueueInEndpoint.class).debug("incomming jms message from queue " + descr.getId());
                IbusMessage msg = new IbusMessage();
                MessageContext ctx = msg.getMessageContext();
                ctx.setJmsMessage(message);
                IbusJmsQueueInEndpoint.this.sendMessage(msg);
                return true;
            }
        });
    }

    @Override
    public void sendMessage(IbusMessage msg) throws Exception {
        this.clb.startRoute(msg);
    }

    @Override
    public boolean canSendMessage() {
        return true;
    }

    @Override
    public boolean isPoller() {
        return false;
    }

    @Override
    public void startPolling() {
    }

    @Override
    public void refreshPollingSettings() {
    }

    @Override
    public EndpointType getType() {
        return EndpointType.JMS_QUEUE_IN;
    }

    public static class IbusJmsQueueInEndpointFactory
    implements IbusStartPoint.IbusStartPointFactory<IbusJmsQueueInEndpoint> {
        @Override
        public IbusJmsQueueInEndpoint createStartPoint(IbusStartPoint.IbusStartPointFactoryCallback pipe, String pointId) {
            return new IbusJmsQueueInEndpoint(pointId, pipe);
        }

        @Override
        public EndpointType getType() {
            return EndpointType.JMS_QUEUE_IN;
        }
    }
}

