/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.endpoints;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusEndPoint;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.model.EndpointType;
import com.gridnine.xtrip.server.ibus.model.JmsOutEndpointDescription;
import com.gridnine.xtrip.server.jms.JMSFacade;
import org.slf4j.LoggerFactory;

public class IbusJmsQueueOutEndpoint
implements IbusEndPoint {
    private final JmsOutEndpointDescription descr;

    public IbusJmsQueueOutEndpoint(String pointId) {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getEndpoint(pointId, JmsOutEndpointDescription.class);
    }

    @Override
    public void sendMessage(IbusMessage msg) throws Exception {
        LoggerFactory.getLogger(IbusJmsQueueOutEndpoint.class).debug("outcomming jms message to queue " + this.descr.getId());
        MessageContext ctx = msg.getMessageContext();
        Object obj = ctx.getJmsMessage();
        if (obj != null) {
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync(this.descr.getQueue(), obj);
        }
    }

    public static class IbusJmsQueueOutEndpointFactory
    implements IbusEndPoint.IbusEndPointFactory<IbusJmsQueueOutEndpoint> {
        @Override
        public IbusJmsQueueOutEndpoint createEndPoint(String pointId) {
            return new IbusJmsQueueOutEndpoint(pointId);
        }

        @Override
        public EndpointType getType() {
            return EndpointType.JMS_QUEUE_OUT;
        }
    }
}

