/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.model;

import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.components.MessageContextParent;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IbusMessage
implements MessageContextParent {
    private static final String DEBUG_HANDLER = "DEBUG_HANDLER";
    private static final String DEBUG_DATA = "DEBUG_DATA";
    private static final String EXCEPTION_KEY = "EXCEPTION_KEY";
    private static Object nullValue = new Object();
    private final ConcurrentHashMap<String, Map<String, Object>> headers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> globalHeader = new ConcurrentHashMap();
    private final ArrayDeque<StackTraceElement> stackTrace = new ArrayDeque();
    private MessageContext ctx = new MessageContext(this);

    public MessageContext getMessageContext() {
        return this.ctx;
    }

    public void setMessageContext(MessageContext value) {
        this.ctx = value;
    }

    public void setGlobalHeader(String key, Object value) {
        this.globalHeader.put(key, value == null ? nullValue : value);
    }

    public <T> T getGlobalHeader(String key) {
        Object result = this.globalHeader.get(key);
        return (T)(result == nullValue ? null : result);
    }

    public void setHeader(String nodeId, String key, Object value) {
        Map values = this.headers.computeIfAbsent(key, k -> new ConcurrentHashMap());
        values.put(nodeId, value == null ? nullValue : value);
    }

    public <T> T getHeader(String key, String nodeId) {
        Map<String, Object> values = this.headers.get(key);
        if (values == null) {
            return null;
        }
        Object result = values.get(nodeId);
        return (T)(result == nullValue ? null : result);
    }

    public void copyHeader(String key) {
        Map<String, Object> values = this.headers.get(key);
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        if (values != null) {
            result.putAll(values);
        }
        this.headers.put(key, result);
    }

    public Throwable getException() {
        return (Throwable)this.globalHeader.get(EXCEPTION_KEY);
    }

    public void setException(Throwable e) {
        if (e != null) {
            this.globalHeader.put(EXCEPTION_KEY, e);
        } else {
            this.globalHeader.remove(EXCEPTION_KEY);
        }
    }

    @Override
    public DebugData getDebugData() {
        return (DebugData)this.globalHeader.get(DEBUG_DATA);
    }

    public void setDebugData(DebugData data) {
        if (data != null) {
            this.globalHeader.put(DEBUG_DATA, data);
        } else {
            this.globalHeader.remove(DEBUG_DATA);
        }
    }

    public DebugHandler getDebugHandler() {
        return (DebugHandler)this.globalHeader.get(DEBUG_HANDLER);
    }

    public void setDebugHandler(DebugHandler handler) {
        if (handler != null) {
            this.globalHeader.put(DEBUG_HANDLER, handler);
        } else {
            this.globalHeader.remove(DEBUG_HANDLER);
        }
    }

    public void beforeExecute(StackTraceElement item) {
        this.stackTrace.push(item);
    }

    public void afterExecute() {
        this.stackTrace.pop();
    }

    public void copyStackTrace(IbusMessage parent) {
        this.stackTrace.addAll(parent.stackTrace);
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.stackTrace.toArray(new StackTraceElement[this.stackTrace.size()]);
    }
}

