/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.components.TargetsProvider;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.IteratorDescription;
import com.gridnine.xtrip.server.ibus.model.IteratorMetadata;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusIteratorNode
implements IbusNode {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TargetsProvider<Object> provider;
    private final IteratorDescription descr;
    private final IteratorMetadata metadata;
    private final IbusNode body;

    IbusIteratorNode(String iteratorId, IbusNode.IbusNodesFactoryIntegrationBusCallback callback) throws Exception {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getNode(iteratorId, IteratorDescription.class);
        this.metadata = reg.getMetadata(this.descr.getMetadataRef(), IteratorMetadata.class);
        this.provider = (TargetsProvider)XHelper.getClass((String)this.metadata.getTargetsProviderImpl()).newInstance();
        this.provider.configure(this.descr.getParameters());
        this.body = this.createNode(callback);
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    private IbusNode createNode(IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
        String nodeId = this.descr.getSubrouteRef();
        BaseNodeDescription node = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(nodeId);
        return clb.getFactory(node.getType()).createNode(nodeId, clb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IbusMessage msg) {
        Collection<Object> targets;
        MessageContext ctx = msg.getMessageContext();
        try {
            targets = this.provider.getTargets(ctx);
        }
        catch (Throwable e) {
            msg.setException(IbusNodesHelper.prepareException(e, msg));
            DebugData debugData = msg.getDebugData();
            debugData.message("unable to get targets", e);
            this.log.error("error getting targets for iterator " + this.descr.getId(), e);
            return;
        }
        DebugData debugData = msg.getDebugData();
        Integer lastIndex = !TextUtil.isBlank((String)this.metadata.getIndexKey()) ? (Integer)ctx.getObject(this.metadata.getIndexKey()) : null;
        Integer lastSize = !TextUtil.isBlank((String)this.metadata.getSizeKey()) ? (Integer)ctx.getObject(this.metadata.getSizeKey()) : null;
        int size = targets.size();
        int i = 0;
        if (!TextUtil.isBlank((String)this.metadata.getSizeKey())) {
            ctx.putObject(this.metadata.getSizeKey(), (Object)size);
        }
        String targetKey = TextUtil.isBlank((String)this.descr.getTargetKey()) ? this.metadata.getTargetKey() : this.descr.getTargetKey();
        try {
            for (Object target : targets) {
                if (msg.getException() != null) {
                    break;
                }
                String targetName = IntegrationBusHelper.getTargetName(target);
                debugData.startElement(targetName, DebugData.DebugNodeType.TARGET);
                try {
                    ctx.putObject(targetKey, target);
                    if (!TextUtil.isBlank((String)this.metadata.getIndexKey())) {
                        ctx.putObject(this.metadata.getIndexKey(), (Object)(++i));
                    }
                    DebugData bodyDebugData = new DebugData(this.descr.getSubrouteRef(), msg.getDebugData().isDisabled());
                    msg.setDebugData(bodyDebugData);
                    debugData.mergeSubroute(bodyDebugData);
                    this.body.execute(msg);
                }
                finally {
                    debugData.endBlock();
                }
            }
        }
        finally {
            msg.setDebugData(debugData);
            ctx.removeObject(targetKey);
            if (lastIndex != null) {
                ctx.putObject(this.metadata.getIndexKey(), (Object)lastIndex);
            }
            if (lastSize != null) {
                ctx.putObject(this.metadata.getSizeKey(), (Object)lastSize);
            }
        }
    }

    public String toString() {
        return String.format("iterator %s", this.descr.getId());
    }

    public static class IbusIteratorNodeFactory
    implements IbusNode.IbusNodesFactory<IbusNode> {
        @Override
        public IbusNode createNode(final String nodeId, final IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return IbusNodesHelper.createNode(nodeId, NodeType.ITERATOR, new IbusNodesHelper.BuilderCallback<IbusIteratorNode>(){

                @Override
                public IbusIteratorNode createNode() throws Exception {
                    return new IbusIteratorNode(nodeId, clb);
                }
            }, clb);
        }
    }
}

