/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.google.common.collect.ArrayListMultimap;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibus.LocalMessageContext;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.util.Mergeables;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.components.RejectException;
import com.gridnine.xtrip.server.ibus.components.TargetsProvider;
import com.gridnine.xtrip.server.ibus.components.TargetsProviderEx;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.impl.standard.jmx.IBusMulticallExTargetMBean;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.impl.standard.statistics.MulticallNodeStatistics;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.MulticallDescription;
import com.gridnine.xtrip.server.ibus.model.MulticallMetadata;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusMulticallNode
implements IbusNode {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IbusNode.IbusNodesFactoryIntegrationBusCallback clb;
    private final TargetsProvider<Object> provider;
    protected final MulticallDescription descr;
    private final MulticallMetadata metadata;
    protected final IbusNode body;

    IbusMulticallNode(String multicallId, IbusNode.IbusNodesFactoryIntegrationBusCallback callback) throws Exception {
        this.clb = callback;
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getNode(multicallId, MulticallDescription.class);
        this.metadata = reg.getMetadata(this.descr.getMetadataRef(), MulticallMetadata.class);
        this.provider = (TargetsProvider)XSHelper.getClass((String)this.metadata.getTargetsProviderImpl()).newInstance();
        this.provider.configure(this.descr.getParameters());
        this.body = this.createNode();
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    private IbusNode createNode() throws Exception {
        String nodeId = this.descr.getSubrouteRef();
        BaseNodeDescription node = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(nodeId);
        return this.clb.getFactory(node.getType()).createNode(nodeId, this.clb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IbusMessage msg) {
        int size;
        Object targets;
        MessageContext ctx = msg.getMessageContext();
        DebugData debugData = msg.getDebugData();
        try {
            Collection<Object> targets2 = this.provider.getTargets(ctx);
            targets = targets2 instanceof List ? (ArrayList<Object>)targets2 : (null == targets2 ? null : new ArrayList<Object>(targets2));
        }
        catch (Throwable e) {
            msg.setException(IbusNodesHelper.prepareException(e, msg));
            debugData.message("unable to get targets", e);
            this.log.error("error getting targets for multicall " + this.descr.getId(), e);
            return;
        }
        int n = size = targets != null ? targets.size() : 0;
        if (size <= 0) {
            debugData.message("targets are empty, bypassing multicall");
            return;
        }
        boolean ex = this.provider instanceof TargetsProviderEx;
        TargetsProviderEx providerEx = ex ? (TargetsProviderEx)this.provider : null;
        Long timeout = ex ? providerEx.getTargetTimeout(ctx, null) : null;
        Integer maxThreadCount = ex ? providerEx.getTargetMaxThreadCount(ctx, null) : null;
        MessageContext mc = msg.getMessageContext();
        ArrayList<TargetExecutionContext> executionList = new ArrayList<TargetExecutionContext>();
        String targetKey = this.metadata.getTargetKey();
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            Object target = iterator.next();
            IbusMessage clonedMsg = new IbusMessage();
            MessageContext clonedCtx = clonedMsg.getMessageContext();
            clonedCtx.getRawData().putAll(mc.getRawData());
            clonedCtx.getRawData().remove("messages");
            clonedCtx.setRouteId(mc.getRouteId());
            clonedCtx.putObject(targetKey, target);
            clonedMsg.setDebugHandler(msg.getDebugHandler());
            clonedMsg.copyStackTrace(msg);
            Long targetTimeout = null;
            Integer targetMaxThreadCount = null;
            if (ex) {
                targetTimeout = providerEx.getTargetTimeout(ctx, target);
                if (null == targetTimeout) {
                    targetTimeout = timeout;
                }
                if (null == (targetMaxThreadCount = providerEx.getTargetMaxThreadCount(ctx, target))) {
                    targetMaxThreadCount = maxThreadCount;
                }
            }
            executionList.add(new TargetExecutionContext(target, clonedMsg, targetTimeout, targetMaxThreadCount));
        }
        String currentUser = LogicalStorage.get().getUser();
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        String multicallId = this.descr.getId();
        String parentThreadId = Long.toString(Thread.currentThread().getId());
        String parentThreadName = Thread.currentThread().getName();
        for (int i = 0; i < size; ++i) {
            TargetExecutionContext tec = (TargetExecutionContext)executionList.get(i);
            IbusMessage subCtx = tec.getMsg();
            Object target = tec.getTarget();
            String targetName = IntegrationBusHelper.getTargetName(target);
            Runnable task = () -> {
                IntegrationBusHelper.IbusThreadContext oldThreadContext;
                String currentThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName(IntegrationBusHelper.getTargetThreadName(multicallId, targetName, parentThreadId, parentThreadName));
                IntegrationBusHelper.IbusThreadContext newThreadContext = oldThreadContext = IntegrationBusHelper.getThreadContext();
                if (newThreadContext == null) {
                    newThreadContext = new IntegrationBusHelper.IbusThreadContext();
                    newThreadContext.setRouteId(mc.getRouteId());
                    IntegrationBusHelper.setThreadContext(newThreadContext);
                }
                try {
                    try {
                        LogicalStorage.get().setUser(currentUser);
                        Locale locale = currentLocale;
                        if (locale != null) {
                            LocaleManager.get().setCurrentLocale(locale);
                        }
                        DebugData subDebugData = new DebugData(this.descr.getSubrouteRef(), msg.getDebugData().isDisabled());
                        subCtx.setDebugData(subDebugData);
                        debugData.mergeSubroute(subDebugData);
                        subDebugData.startElement(targetName, DebugData.DebugNodeType.TARGET);
                        LocalMessageContext.Source old = LocalMessageContext.setLocalMessageContext((LocalMessageContext.Source)subCtx.getMessageContext());
                        try {
                            this.body.execute(subCtx);
                        }
                        finally {
                            LocalMessageContext.setLocalMessageContext((LocalMessageContext.Source)old);
                            subDebugData.endBlock();
                            debugData.endRoute();
                        }
                    }
                    catch (Throwable e) {
                        subCtx.setException(e);
                    }
                }
                finally {
                    IntegrationBusHelper.setThreadContext(oldThreadContext);
                    Thread.currentThread().setName(currentThreadName);
                }
            };
            if (!ex) {
                tec.setTask(this.clb.execute(() -> {
                    task.run();
                    return null;
                }));
                continue;
            }
            AtomicInteger internalCounter = null;
            AtomicInteger realCounter = null;
            boolean failCanHappen = true;
            try {
                Integer targetMaxThreadCount = tec.getTargetMaxThreadCount();
                Long targetTimeout = tec.getTargetTimeout();
                MulticallNodeStatistics.MulticallTargetId key = new MulticallNodeStatistics.MulticallTargetId(multicallId, target);
                MulticallNodeStatistics.TargetData targetData = (MulticallNodeStatistics.TargetData)MulticallNodeStatistics.TARGET_DATA.get(key);
                if (null == targetData && (null != targetMaxThreadCount || targetTimeout != null)) {
                    targetData = new MulticallNodeStatistics.TargetData();
                    MulticallNodeStatistics.TargetData firstCounter = MulticallNodeStatistics.TARGET_DATA.putIfAbsent(key, targetData);
                    if (firstCounter != null) {
                        targetData = firstCounter;
                    } else {
                        try {
                            new IBusMulticallExTargetMBean(multicallId, target).register();
                        }
                        catch (Exception e) {
                            msg.setException(IbusNodesHelper.prepareException(e, msg));
                            String targerStr = String.valueOf(target);
                            this.log.error("unable to register mbean for target " + targerStr + " of multicall " + this.descr.getId(), (Throwable)e);
                            if (failCanHappen && internalCounter != null) {
                                internalCounter.decrementAndGet();
                            }
                            return;
                        }
                    }
                }
                if (targetData != null) {
                    tec.setTargetData(targetData);
                    targetData.setMaxThreads(targetMaxThreadCount != null ? targetMaxThreadCount : -1);
                    targetData.setTimeout(targetTimeout != null ? targetTimeout : -1L);
                    if (null != targetMaxThreadCount) {
                        internalCounter = targetData.getInternalThreadCount();
                        int countValue = internalCounter.incrementAndGet();
                        failCanHappen = true;
                        if (countValue > targetMaxThreadCount) {
                            targetData.reject();
                            IbusMessage subMsg = tec.getMsg();
                            subMsg.setException(IbusNodesHelper.prepareException(new RejectException(multicallId, target), msg));
                            continue;
                        }
                    }
                    realCounter = targetData.getRealThreadCount();
                }
                AtomicInteger internalCounter2 = internalCounter;
                AtomicInteger realCounter2 = realCounter;
                tec.setTask(this.clb.execute(() -> {
                    try {
                        AtomicInteger realCounter3 = realCounter2;
                        if (realCounter3 != null) {
                            realCounter3.incrementAndGet();
                        }
                        try {
                            task.run();
                        }
                        finally {
                            AtomicInteger internalCounter3 = internalCounter2;
                            if (internalCounter3 != null) {
                                internalCounter3.decrementAndGet();
                            }
                            if (realCounter3 != null) {
                                realCounter3.decrementAndGet();
                            }
                        }
                    }
                    catch (Throwable e) {
                        subCtx.setException(IbusNodesHelper.prepareException(e, msg));
                    }
                    return null;
                }));
                failCanHappen = false;
                continue;
            }
            finally {
                if (failCanHappen && internalCounter != null) {
                    internalCounter.decrementAndGet();
                }
            }
        }
        try {
            for (TargetExecutionContext tec : executionList) {
                if (tec.getTask() == null) continue;
                try {
                    if (!ex) {
                        tec.getTask().get();
                        continue;
                    }
                    Long targetTimeout = tec.getTargetTimeout();
                    MulticallNodeStatistics.TargetData targetData = tec.getTargetData();
                    long st = System.currentTimeMillis();
                    if (targetTimeout != null && targetTimeout > 0L) {
                        try {
                            tec.getTask().get(targetTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            tec.getTargetData().timeout();
                            throw e;
                        }
                    } else {
                        tec.getTask().get();
                    }
                    long et = System.currentTimeMillis();
                    if (targetData == null) continue;
                    targetData.success(et - st);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    IbusMessage subMsg = tec.getMsg();
                    subMsg.setException(IbusNodesHelper.prepareException(e, msg));
                }
            }
        }
        catch (InterruptedException e) {
            msg.setException(IbusNodesHelper.prepareException(e, msg));
            debugData.message("interrupted", e);
            this.log.warn("multicall " + this.descr.getId() + " interrupted", (Throwable)e);
            return;
        }
        LinkedHashMap<Object, MessageContext> results = new LinkedHashMap<Object, MessageContext>();
        MulticallException multicallException = null;
        for (TargetExecutionContext tec : executionList) {
            Object target = tec.getTarget();
            IbusMessage subMsg = tec.getMsg();
            results.put(target, subMsg.getMessageContext());
            Throwable subException = subMsg.getException();
            if (null == subException) continue;
            if (null == multicallException) {
                multicallException = new MulticallException(target, subException);
                continue;
            }
            multicallException.addSubrouteException(target, subException);
        }
        if (multicallException != null) {
            msg.setException(IbusNodesHelper.prepareException(multicallException, msg));
        }
        ctx.putObject(this.metadata.getResultKey(), results);
        for (MessageContext subCtx : results.values()) {
            ctx.mergeMessages(subCtx);
        }
        IbusMulticallNode.propagateMergeables(ctx, results);
    }

    private static void propagateMergeables(MessageContext ctx, Map<Object, MessageContext> results) {
        ArrayListMultimap dataGrouped = ArrayListMultimap.create();
        for (MessageContext subCtx : results.values()) {
            Map<String, Object> data = subCtx.getRawData();
            for (Map.Entry<String, Object> ent : data.entrySet()) {
                dataGrouped.put((Object)ent.getKey(), ent.getValue());
            }
        }
        for (String key : dataGrouped.keySet()) {
            Object result;
            List values = dataGrouped.get((Object)key);
            List merged = Mergeables.mergeWhatIsPossible((List)values);
            if (merged.size() != 1 || !((result = merged.get(0)) instanceof Mergeables.IMergeable)) continue;
            ctx.putObject(key, result);
        }
    }

    public TargetsProvider<Object> getProvider() {
        return this.provider;
    }

    public String toString() {
        return String.format("multi call %s", this.descr.getId());
    }

    public static class IbusMulticallNodeFactory
    implements IbusNode.IbusNodesFactory<IbusNode> {
        @Override
        public IbusNode createNode(String nodeId, IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return IbusNodesHelper.createNode(nodeId, NodeType.MULTICALL, () -> new IbusMulticallNode(nodeId, clb), clb);
        }
    }

    private static class TargetExecutionContext {
        private final Object target;
        private final IbusMessage msg;
        private final Long targetTimeout;
        private final Integer targetMaxThreadCount;
        private MulticallNodeStatistics.TargetData targetData;
        private Future<Void> task;

        public TargetExecutionContext(Object target, IbusMessage msg, Long targetTimeout, Integer targetMaxThreadCount) {
            this.target = target;
            this.msg = msg;
            this.targetTimeout = targetTimeout;
            this.targetMaxThreadCount = targetMaxThreadCount;
        }

        public Object getTarget() {
            return this.target;
        }

        public IbusMessage getMsg() {
            return this.msg;
        }

        public Long getTargetTimeout() {
            return this.targetTimeout;
        }

        public Integer getTargetMaxThreadCount() {
            return this.targetMaxThreadCount;
        }

        public MulticallNodeStatistics.TargetData getTargetData() {
            return this.targetData;
        }

        public void setTargetData(MulticallNodeStatistics.TargetData targetData) {
            this.targetData = targetData;
        }

        public Future<Void> getTask() {
            return this.task;
        }

        public void setTask(Future<Void> task) {
            this.task = task;
        }
    }
}

