/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusSubrouteNode;
import com.gridnine.xtrip.server.ibus.model.BaseItemDescription;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.commons.lang.SerializationUtils;

public final class IbusNodesHelper {
    private static final Field THROWABLE_CAUSE;

    static <E extends IbusNode> IbusNode createNode(final String nodeId, final NodeType nodeType, BuilderCallback<E> builderCallback, IbusNode.IbusNodesFactoryIntegrationBusCallback integrationBusCallback) throws Exception {
        Object existingNode = integrationBusCallback.getExistingNode(nodeId);
        if (existingNode != null) {
            return existingNode;
        }
        E newNode = builderCallback.createNode();
        final StackTraceElement stackTrace = IbusNodesHelper.createStackTrace(newNode.getDescription());
        IbusNode node = new IbusNode((IbusNode)newNode){
            final /* synthetic */ IbusNode val$newNode;
            {
                this.val$newNode = ibusNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(IbusMessage msg) {
                if (msg.getException() != null) {
                    return;
                }
                DebugData.DebugNodeType debugNodeType = DebugData.DebugNodeType.fromNodeType(nodeType);
                DebugData debugData = msg.getDebugData();
                debugData.startElement(nodeId, debugNodeType);
                msg.beforeExecute(stackTrace);
                try {
                    this.val$newNode.execute(msg);
                }
                catch (Throwable t) {
                    ExceptionUtil.throwException((Throwable)IbusNodesHelper.prepareException(t, msg));
                }
                finally {
                    msg.afterExecute();
                    debugData.endBlock();
                }
            }

            @Override
            public BaseNodeDescription getDescription() {
                return null;
            }
        };
        integrationBusCallback.registerNode(nodeId, node);
        return node;
    }

    static IbusNode createInternalSubrouteNode(String nodeId, DebugData.DebugNodeType debugNodeType, IbusNode.IbusNodesFactoryIntegrationBusCallback integrationBusCallback) throws Exception {
        final IbusSubrouteNode newNode = new IbusSubrouteNode(nodeId, integrationBusCallback);
        final StackTraceElement stackTrace = IbusNodesHelper.createStackTrace(debugNodeType, nodeId, newNode.getDescription());
        IbusNode node = new IbusNode(){

            @Override
            public void execute(IbusMessage msg) {
                if (msg.getException() != null) {
                    return;
                }
                msg.beforeExecute(stackTrace);
                try {
                    newNode.execute(msg);
                }
                catch (Throwable t) {
                    ExceptionUtil.throwException((Throwable)IbusNodesHelper.prepareException(t, msg));
                }
                finally {
                    msg.afterExecute();
                }
            }

            @Override
            public BaseNodeDescription getDescription() {
                return null;
            }
        };
        return node;
    }

    public static StackTraceElement createStackTrace(BaseNodeDescription descr) {
        return new StackTraceElement(DebugData.DebugNodeType.fromNodeType(descr.getType()).getElementName(), descr.getId(), descr.getFile(), descr.getLineNumber());
    }

    public static StackTraceElement createStackTrace(DebugData.DebugNodeType type, String id, BaseItemDescription descr) {
        return new StackTraceElement(type.getElementName(), id, descr.getFile(), descr.getLineNumber());
    }

    static Throwable prepareException(Throwable t, IbusMessage msg) {
        try {
            Throwable newException = (Throwable)SerializationUtils.clone((Serializable)t);
            StackTraceElement[] newStackTrace = msg.getStackTrace();
            newException.setStackTrace(newStackTrace);
            THROWABLE_CAUSE.set(newException, t);
            return newException;
        }
        catch (Exception e) {
            return t;
        }
    }

    private IbusNodesHelper() {
    }

    static {
        try {
            THROWABLE_CAUSE = Throwable.class.getDeclaredField("cause");
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        THROWABLE_CAUSE.setAccessible(true);
    }

    static interface BuilderCallback<E extends IbusNode> {
        public E createNode() throws Exception;
    }
}

