/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.IbusInternalException;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.components.Processor;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import com.gridnine.xtrip.server.ibus.model.ParameterType;
import com.gridnine.xtrip.server.ibus.model.ProcessorDescription;
import com.gridnine.xtrip.server.ibus.model.ProcessorMetadata;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusProcessorNode
implements IbusNode {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Processor proc;
    private final ProcessorDescription descr;
    private final ProcessorMetadata metadata;

    IbusProcessorNode(String processorId) throws Exception {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getNode(processorId, ProcessorDescription.class);
        this.metadata = reg.getMetadata(this.descr.getMetadataRef(), ProcessorMetadata.class);
        this.proc = (Processor)XSHelper.getClassForName((String)this.metadata.getImplementationClassName()).newInstance();
        this.proc.configure(this.descr.getParameters());
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    @Override
    public void execute(IbusMessage msg) {
        DebugData debugData = msg.getDebugData();
        DebugHandler handler = msg.getDebugHandler();
        try {
            this.proc.process(msg.getMessageContext());
        }
        catch (Throwable e) {
            msg.setException(IbusNodesHelper.prepareException(e, msg));
            if (e instanceof IbusInternalException) {
                debugData.message("internal exception occurred " + MiscUtil.getSimpleClassName(e.getClass()));
                this.trace(debugData, msg.getMessageContext(), handler);
                return;
            }
            debugData.message("exception occurred, other nodes will be skipped", e);
            this.trace(debugData, msg.getMessageContext(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace(DebugData debugData, MessageContext ctx, DebugHandler handler) {
        boolean trace = this.metadata != null && handler.isTraceData(this.descr.getId(), ctx) && (!this.metadata.getInputParameters().isEmpty() || !this.metadata.getAffectedParameters().isEmpty());
        HashSet<String> dumpedParameters = new HashSet<String>();
        if (trace) {
            XMLStreamWriter writer = debugData.getArgumentsDump();
            try {
                try {
                    writer.writeStartElement("input");
                    dumpedParameters.addAll(this.appendSection(writer, ctx, this.metadata.getInputParameters(), debugData.getDumpedParameters()));
                    writer.writeEndElement();
                    writer.writeStartElement("affected");
                    dumpedParameters.addAll(this.appendSection(writer, ctx, this.metadata.getAffectedParameters(), Collections.emptySet()));
                    writer.writeEndElement();
                }
                finally {
                    writer.close();
                }
            }
            catch (Exception e) {
                this.log.error("an unexpected error has occurred", (Throwable)e);
            }
        }
        if (this.metadata != null && this.metadata.getAffectedParameters() != null) {
            debugData.getDumpedParameters().removeAll(this.metadata.getAffectedParameters().keySet());
        }
        debugData.getDumpedParameters().addAll(dumpedParameters);
    }

    private Set<String> appendSection(XMLStreamWriter writer, MessageContext ctx, Map<String, ParameterType> inputParameters, Set<String> ignoredParameters) throws Exception {
        HashSet<String> result = new HashSet<String>();
        for (String item : inputParameters.keySet()) {
            if (ignoredParameters.contains(item)) {
                XSHelper.writeString((XMLStreamWriter)writer, (String)"item", (String)"ALREADY_DUMPED", Collections.singletonMap("name", item));
                continue;
            }
            Object object = ctx.getObject(item);
            if (object == null) continue;
            result.add(item);
            try {
                XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", object, Collections.singletonMap("name", item));
            }
            catch (Exception e) {
                this.log.error("unable to trace item " + item, (Throwable)e);
            }
        }
        return result;
    }

    public String toString() {
        return String.format("processor %s", this.descr.getId());
    }

    public static class IbusProcessorNodeFactory
    implements IbusNode.IbusNodesFactory<IbusNode> {
        @Override
        public IbusNode createNode(final String nodeId, IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return IbusNodesHelper.createNode(nodeId, NodeType.PROCESSOR, new IbusNodesHelper.BuilderCallback<IbusProcessorNode>(){

                @Override
                public IbusProcessorNode createNode() throws Exception {
                    return new IbusProcessorNode(nodeId);
                }
            }, clb);
        }
    }
}

