/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibus.LocalMessageContext;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.DebugHandlerDescription;
import com.gridnine.xtrip.server.ibus.model.DebugHandlerMetadata;
import com.gridnine.xtrip.server.ibus.model.RouteDescription;
import com.gridnine.xtrip.server.ibus.standard.DefaultDebugHandler;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusRouteNode
implements IbusNode {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final RouteDescription descr;
    final IbusNode.IbusNodesFactoryIntegrationBusCallback clb;
    private final IbusNode routeNode;
    public final DebugHandler handler;

    IbusRouteNode(String routeId, IbusNode.IbusNodesFactoryIntegrationBusCallback callback) throws Exception {
        RouteDescription rd;
        try {
            rd = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(routeId, RouteDescription.class);
        }
        catch (ClassCastException e) {
            rd = null;
        }
        if (null == rd) {
            throw new IntegrationBusException("no route found for id " + routeId);
        }
        this.descr = rd;
        this.clb = callback;
        this.routeNode = this.createNode();
        DebugHandler handler2 = null;
        if (this.descr.getDebugHandler() != null) {
            try {
                IntegrationBusRegistry registry = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
                DebugHandlerDescription description = registry.getDebugHandler(this.descr.getDebugHandler());
                handler2 = (DebugHandler)XSHelper.getClassForName((String)registry.getMetadata(description.getMetadataRef(), DebugHandlerMetadata.class).getImplementationClassName()).newInstance();
                handler2.configure(description.getParameters());
            }
            catch (Exception e) {
                this.log.error("unable to instantiate log handler", (Throwable)e);
            }
        }
        if (null == handler2) {
            handler2 = new DefaultDebugHandler();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("loggerName", this.descr.getId().replace(".", "_").replace(" ", "_").replace(";", "_").replace(":", "_"));
            handler2.configure(props);
        }
        this.handler = handler2;
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    private IbusNode createNode() throws Exception {
        final IbusNode node = IbusNodesHelper.createInternalSubrouteNode(this.descr.getId(), DebugData.DebugNodeType.ROUTE, this.clb);
        return new IbusNode(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(IbusMessage msg) {
                msg.setDebugHandler(IbusRouteNode.this.handler);
                DebugData debugData = msg.getDebugData();
                IntegrationBusHelper.IbusThreadContext oldThreadContext = IntegrationBusHelper.getThreadContext();
                if (oldThreadContext == null) {
                    IntegrationBusHelper.setThreadContext(new IntegrationBusHelper.IbusThreadContext());
                    IntegrationBusHelper.getThreadContext().setRouteId(IbusRouteNode.this.descr.getId());
                }
                try {
                    msg.getMessageContext().setRouteId(IbusRouteNode.this.descr.getId());
                    node.execute(msg);
                }
                finally {
                    IntegrationBusHelper.setThreadContext(oldThreadContext);
                    debugData.endRoute();
                    try {
                        IbusRouteNode.this.handler.save(debugData, msg.getMessageContext());
                    }
                    catch (Exception e) {
                        msg.setException(IbusNodesHelper.prepareException(e, msg));
                    }
                }
            }

            @Override
            public BaseNodeDescription getDescription() {
                return null;
            }
        };
    }

    @Override
    public void execute(IbusMessage msg) {
        LocalMessageContext.Source old = LocalMessageContext.setLocalMessageContext((LocalMessageContext.Source)msg.getMessageContext());
        try {
            this.routeNode.execute(msg);
        }
        finally {
            LocalMessageContext.setLocalMessageContext((LocalMessageContext.Source)old);
        }
    }

    public String toString() {
        return String.format("route %s", this.descr.getId());
    }

    public static class IbusRouteNodeFactory
    implements IbusNode.IbusNodesFactory<IbusRouteNode> {
        @Override
        public IbusRouteNode createNode(String nodeId, IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return new IbusRouteNode(nodeId, clb);
        }
    }
}

