/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.Advice;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.model.AdviceDescription;
import com.gridnine.xtrip.server.ibus.model.AdviceMetadata;
import com.gridnine.xtrip.server.ibus.model.BaseElementMetadata;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import com.gridnine.xtrip.server.ibus.model.SubrouteDescription;
import com.gridnine.xtrip.server.ibus.model.SubrouteMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusSubrouteNode
implements IbusNode {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SubrouteDescription descr;
    protected final IbusNode.IbusNodesFactoryIntegrationBusCallback clb;
    private final IbusNode subrouteNode;
    private final Set<String> localVariables;
    private final Set<String> inputParams;
    private final Set<String> affectedParams;

    IbusSubrouteNode(String subrouteId, IbusNode.IbusNodesFactoryIntegrationBusCallback callback) throws Exception {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getNode(subrouteId, SubrouteDescription.class);
        this.clb = callback;
        BaseElementMetadata metadata = reg.getMetadata(this.descr.getMetadataRef());
        this.localVariables = metadata instanceof SubrouteMetadata ? ((SubrouteMetadata)metadata).getLocalVariables() : Collections.emptySet();
        this.inputParams = metadata instanceof SubrouteMetadata ? ((SubrouteMetadata)metadata).getInputParams() : Collections.emptySet();
        this.affectedParams = metadata instanceof SubrouteMetadata ? ((SubrouteMetadata)metadata).getAffectedParams() : Collections.emptySet();
        LinkedList<AdviceParts> advices = this.createAdvicesParts();
        List<IbusNode> nodes = this.createNodes();
        this.subrouteNode = this.wrapWithLocalVariables(this.wrapWithAdvices(advices, nodes));
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    private IbusNode wrapWithLocalVariables(final IbusNode node) {
        final Set<String> lv = this.localVariables;
        final Set<String> ip = this.inputParams;
        final Set<String> ap = this.affectedParams;
        if (lv.isEmpty() && ip.isEmpty() && ap.isEmpty()) {
            return node;
        }
        return new IbusNode(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(IbusMessage msg) {
                if (ip.isEmpty() && ap.isEmpty()) {
                    HashMap existingVariables = new HashMap();
                    MessageContext ctx = msg.getMessageContext();
                    lv.forEach(key -> {
                        Object value = ctx.getObject((String)key);
                        if (null != value) {
                            existingVariables.put(key, value);
                            ctx.removeObject((String)key);
                        }
                    });
                    try {
                        node.execute(msg);
                    }
                    finally {
                        lv.forEach(key -> {
                            Object value = existingVariables.get(key);
                            if (null != value) {
                                ctx.putObject((String)key, value);
                            } else {
                                ctx.removeObject((String)key);
                            }
                        });
                    }
                }
                MessageContext original = msg.getMessageContext();
                MessageContext newContext = new MessageContext(msg);
                newContext.putObject("messages", original.getObject("messages"));
                newContext.setRouteId(original.getRouteId());
                if (!ip.isEmpty()) {
                    ip.stream().filter(key -> !lv.contains(key)).forEach(key -> {
                        Object value = original.getObject((String)key);
                        if (null != value) {
                            newContext.putObject((String)key, value);
                        }
                    });
                } else {
                    original.getRawData().entrySet().stream().filter(e -> !lv.contains(e.getKey()) && e.getValue() != null).forEach(e -> newContext.putObject((String)e.getKey(), e.getValue()));
                }
                msg.setMessageContext(newContext);
                try {
                    node.execute(msg);
                }
                finally {
                    msg.setMessageContext(original);
                    if (!ap.isEmpty()) {
                        ap.forEach(key -> {
                            Object value = newContext.getObject((String)key);
                            if (null != value) {
                                original.putObject((String)key, value);
                            }
                        });
                    } else {
                        newContext.getRawData().entrySet().stream().filter(e -> !lv.contains(e.getKey()) && e.getValue() != null).forEach(e -> original.putObject((String)e.getKey(), e.getValue()));
                    }
                }
            }

            @Override
            public BaseNodeDescription getDescription() {
                return null;
            }
        };
    }

    private IbusNode wrapWithAdvices(LinkedList<AdviceParts> advices, final List<IbusNode> nodes) {
        if (advices.isEmpty()) {
            return new IbusNode(){

                @Override
                public void execute(IbusMessage msg) {
                    try {
                        for (IbusNode node : nodes) {
                            node.execute(msg);
                        }
                    }
                    catch (Throwable t) {
                        msg.setException(t);
                    }
                }

                @Override
                public BaseNodeDescription getDescription() {
                    return null;
                }
            };
        }
        final AdviceParts parts = advices.removeFirst();
        final IbusNode node = this.wrapWithAdvices(advices, nodes);
        return new IbusNode(){

            @Override
            public void execute(IbusMessage msg) {
                if (msg.getException() != null) {
                    return;
                }
                if (parts.beforeNode != null) {
                    try {
                        parts.beforeNode.execute(msg);
                    }
                    catch (Throwable t) {
                        msg.setException(t);
                    }
                    if (msg.getException() != null) {
                        return;
                    }
                }
                try {
                    node.execute(msg);
                }
                catch (Throwable t) {
                    msg.setException(t);
                }
                if (parts.onExceptionNode != null) {
                    try {
                        parts.onExceptionNode.execute(msg);
                    }
                    catch (Throwable t) {
                        msg.setException(t);
                    }
                }
                if (parts.afterNode != null) {
                    try {
                        parts.afterNode.execute(msg);
                    }
                    catch (Throwable t) {
                        msg.setException(t);
                    }
                }
            }

            @Override
            public BaseNodeDescription getDescription() {
                return null;
            }
        };
    }

    private List<IbusNode> createNodes() throws Exception {
        ArrayList<IbusNode> result = new ArrayList<IbusNode>();
        for (String nodeId : this.descr.getNodes()) {
            BaseNodeDescription node = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(nodeId);
            if (node == null) {
                throw Xeption.forDeveloper((String)"can't find node {0}", (Object[])new Object[]{nodeId});
            }
            result.add((IbusNode)this.clb.getFactory(node.getType()).createNode(nodeId, this.clb));
        }
        return result;
    }

    @Override
    public void execute(IbusMessage msg) {
        this.subrouteNode.execute(msg);
    }

    private LinkedList<AdviceParts> createAdvicesParts() throws Exception {
        LinkedList<AdviceParts> result = new LinkedList<AdviceParts>();
        for (final String adviceId : this.descr.getAdvices()) {
            StackTraceElement stackTrace;
            IbusNode subNode;
            AdviceDescription adviceDescr = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getAdvice(adviceId);
            if (adviceDescr == null) {
                throw new NullPointerException(String.format("advice description for id %s not found", adviceId));
            }
            IbusNode beforeNode = null;
            IbusNode onExceptionNode = null;
            IbusNode afterNode = null;
            Advice advice = null;
            if (adviceDescr.getMetadataRef() != null) {
                AdviceMetadata adviceMetadata = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getMetadata(adviceDescr.getMetadataRef(), AdviceMetadata.class);
                if (!TextUtil.isBlank((String)adviceDescr.getMetadataRef()) && adviceMetadata == null) {
                    throw new IllegalStateException(String.format("advice %s refers to nonexistent metadata ref %s", adviceId, adviceDescr.getMetadataRef()));
                }
                if (adviceMetadata.getImplementationClassName() != null && (advice = this.clb.getExistingAdvice(adviceId)) == null) {
                    advice = (Advice)XHelper.getClass((String)adviceMetadata.getImplementationClassName()).newInstance();
                    advice.configure(adviceDescr.getParameters());
                    this.clb.registerAdvice(adviceId, advice);
                }
            }
            final Advice advice2 = advice;
            if (adviceDescr.getBeforeSubrouteRef() != null) {
                subNode = this.createAdviceNodeFromSubroute(adviceDescr.getBeforeSubrouteRef(), DebugData.DebugNodeType.ADVICE_BEFORE);
                beforeNode = new IbusNode(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(IbusMessage msg) {
                        DebugData debugData = msg.getDebugData();
                        debugData.startElement(adviceId, DebugData.DebugNodeType.ADVICE_BEFORE);
                        try {
                            subNode.execute(msg);
                        }
                        catch (Throwable e) {
                            msg.setException(e);
                            IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by before advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                            debugData.message(String.format("exception was thrown for subroute %s, by before advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                        }
                        finally {
                            debugData.endBlock();
                        }
                    }

                    @Override
                    public BaseNodeDescription getDescription() {
                        return null;
                    }
                };
            } else if (advice2 != null) {
                stackTrace = advice != null ? IbusNodesHelper.createStackTrace(DebugData.DebugNodeType.ADVICE_BEFORE, adviceId, adviceDescr) : null;
                beforeNode = new IbusNode(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(IbusMessage msg) {
                        DebugData debugData = msg.getDebugData();
                        debugData.startElement(adviceId, DebugData.DebugNodeType.ADVICE_BEFORE);
                        msg.beforeExecute(stackTrace);
                        try {
                            IbusSubrouteNode.this.log.debug(String.format("executing before of %s", advice2.getClass().getName()));
                            advice2.before(msg.getMessageContext());
                        }
                        catch (Throwable e) {
                            e = IbusNodesHelper.prepareException(e, msg);
                            IbusSubrouteNode.this.log.error(String.format("unable to perform before advice %s for %s", adviceId, IbusSubrouteNode.this.descr.getId()), e);
                            msg.setException(e);
                            IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by before advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                            debugData.message(String.format("exception was thrown for subroute %s, by before advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                        }
                        finally {
                            msg.afterExecute();
                            debugData.endBlock();
                        }
                    }

                    @Override
                    public BaseNodeDescription getDescription() {
                        return null;
                    }
                };
            }
            if (adviceDescr.getExceptionSubrouteRef() != null) {
                subNode = this.createAdviceNodeFromSubroute(adviceDescr.getExceptionSubrouteRef(), DebugData.DebugNodeType.ADVICE_ON_EXCEPTION);
                onExceptionNode = new IbusNode(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(IbusMessage msg) {
                        final Throwable t = msg.getException();
                        if (null == t) {
                            return;
                        }
                        DebugData debugData = msg.getDebugData();
                        debugData.startElement(adviceId, DebugData.DebugNodeType.ADVICE_ON_EXCEPTION);
                        try {
                            msg.setException(null);
                            final ValueHolder handled = new ValueHolder((Object)Boolean.FALSE);
                            MessageContext ctx = msg.getMessageContext();
                            Object savedCallback = ctx.getObject((Enum<?>)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
                            try {
                                ctx.putObject((Enum<?>)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK, (Object)new AdviceOnExceptionCallback(){

                                    @Override
                                    public void exceptionHandled(boolean value) {
                                        handled.setValue((Object)value);
                                    }

                                    @Override
                                    public Throwable getException() {
                                        return t;
                                    }
                                });
                                subNode.execute(msg);
                                Throwable e = msg.getException();
                                if (e != null) {
                                    IbusSubrouteNode.this.log.error(String.format("unable to perform on-exception advice %s for %s", adviceId, IbusSubrouteNode.this.descr.getId()), e);
                                    IbusSubrouteNode.this.log.error(String.format(IbusSubrouteNode.this.descr.getId(), adviceId), e);
                                    debugData.message(String.format("exception was thrown for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                                } else if (((Boolean)handled.getValue()).booleanValue()) {
                                    IbusSubrouteNode.this.log.debug(String.format("exception was handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId));
                                    debugData.message(String.format("exception was handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t);
                                    msg.setException(null);
                                } else {
                                    IbusSubrouteNode.this.log.warn(String.format("exception was NOT handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId));
                                    debugData.message(String.format("exception was NOT handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId));
                                    msg.setException(t);
                                }
                            }
                            finally {
                                if (savedCallback != null) {
                                    ctx.putObject((Enum<?>)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK, savedCallback);
                                } else {
                                    ctx.removeObject((Enum<?>)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
                                }
                            }
                        }
                        catch (Throwable e) {
                            msg.setException(e);
                            IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                            debugData.message(String.format("exception was thrown for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                        }
                        finally {
                            debugData.endBlock();
                        }
                    }

                    @Override
                    public BaseNodeDescription getDescription() {
                        return null;
                    }
                };
            } else if (advice2 != null) {
                stackTrace = advice != null ? IbusNodesHelper.createStackTrace(DebugData.DebugNodeType.ADVICE_ON_EXCEPTION, adviceId, adviceDescr) : null;
                onExceptionNode = new IbusNode(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(IbusMessage msg) {
                        Throwable t = msg.getException();
                        if (null == t) {
                            return;
                        }
                        DebugData debugData = msg.getDebugData();
                        debugData.startElement(adviceId, DebugData.DebugNodeType.ADVICE_ON_EXCEPTION);
                        msg.beforeExecute(stackTrace);
                        try {
                            IbusSubrouteNode.this.log.debug(String.format("executing handleException of %s", advice2.getClass().getName()));
                            if (advice2.handleException(t, msg.getMessageContext())) {
                                IbusSubrouteNode.this.log.debug(String.format("exception was handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId));
                                debugData.message(String.format("exception was handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t);
                                msg.setException(null);
                            } else {
                                IbusSubrouteNode.this.log.warn(String.format("exception was NOT handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId));
                                debugData.message(String.format("exception was NOT handled for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId));
                            }
                        }
                        catch (Throwable e) {
                            e = IbusNodesHelper.prepareException(e, msg);
                            IbusSubrouteNode.this.log.error(String.format("unable to perform on-exception advice %s for %s", adviceId, IbusSubrouteNode.this.descr.getId()), e);
                            msg.setException(e);
                            IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                            debugData.message(String.format("exception was thrown for subroute %s, by on-exception advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), e);
                        }
                        finally {
                            msg.afterExecute();
                            debugData.endBlock();
                        }
                    }

                    @Override
                    public BaseNodeDescription getDescription() {
                        return null;
                    }
                };
            }
            if (adviceDescr.getAfterSubrouteRef() != null) {
                subNode = this.createAdviceNodeFromSubroute(adviceDescr.getAfterSubrouteRef(), DebugData.DebugNodeType.ADVICE_AFTER);
                afterNode = new IbusNode(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(IbusMessage msg) {
                        DebugData debugData;
                        block10: {
                            block8: {
                                debugData = msg.getDebugData();
                                debugData.startElement(adviceId, DebugData.DebugNodeType.ADVICE_AFTER);
                                boolean adviceThrewException = false;
                                try {
                                    Throwable t = msg.getException();
                                    msg.setException(null);
                                    subNode.execute(msg);
                                    if (msg.getException() != null) {
                                        adviceThrewException = true;
                                    } else {
                                        msg.setException(t);
                                    }
                                    if (adviceThrewException) break block8;
                                }
                                catch (Throwable e) {
                                    block12: {
                                        block9: {
                                            try {
                                                adviceThrewException = true;
                                                msg.setException(e);
                                                if (adviceThrewException) break block9;
                                            }
                                            catch (Throwable throwable) {
                                                if (!adviceThrewException) {
                                                    IbusSubrouteNode.this.log.debug(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                                    debugData.message(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                                } else {
                                                    Throwable t2 = msg.getException();
                                                    IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                                    debugData.message(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                                }
                                                debugData.endBlock();
                                                throw throwable;
                                            }
                                            IbusSubrouteNode.this.log.debug(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                            debugData.message(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                            break block12;
                                        }
                                        Throwable t2 = msg.getException();
                                        IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                        debugData.message(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                    }
                                    debugData.endBlock();
                                }
                                IbusSubrouteNode.this.log.debug(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                debugData.message(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                break block10;
                            }
                            Throwable t2 = msg.getException();
                            IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                            debugData.message(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                        }
                        debugData.endBlock();
                    }

                    @Override
                    public BaseNodeDescription getDescription() {
                        return null;
                    }
                };
            } else if (advice2 != null) {
                stackTrace = advice != null ? IbusNodesHelper.createStackTrace(DebugData.DebugNodeType.ADVICE_AFTER, adviceId, adviceDescr) : null;
                afterNode = new IbusNode(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(IbusMessage msg) {
                        DebugData debugData;
                        block8: {
                            block6: {
                                debugData = msg.getDebugData();
                                debugData.startElement(adviceId, DebugData.DebugNodeType.ADVICE_AFTER);
                                msg.beforeExecute(stackTrace);
                                boolean adviceThrewException = false;
                                try {
                                    IbusSubrouteNode.this.log.debug(String.format("executing after of %s", advice2.getClass().getName()));
                                    advice2.after(msg.getMessageContext());
                                    msg.afterExecute();
                                    if (adviceThrewException) break block6;
                                }
                                catch (Throwable e) {
                                    block10: {
                                        block7: {
                                            try {
                                                e = IbusNodesHelper.prepareException(e, msg);
                                                IbusSubrouteNode.this.log.error(String.format("unable to perform after advice %s for %s", adviceId, IbusSubrouteNode.this.descr.getId()), e);
                                                msg.setException(e);
                                                adviceThrewException = true;
                                                msg.afterExecute();
                                                if (adviceThrewException) break block7;
                                            }
                                            catch (Throwable throwable) {
                                                msg.afterExecute();
                                                if (!adviceThrewException) {
                                                    IbusSubrouteNode.this.log.debug(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                                    debugData.message(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                                } else {
                                                    Throwable t2 = msg.getException();
                                                    IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                                    debugData.message(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                                }
                                                debugData.endBlock();
                                                throw throwable;
                                            }
                                            IbusSubrouteNode.this.log.debug(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                            debugData.message(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                            break block10;
                                        }
                                        Throwable t2 = msg.getException();
                                        IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                        debugData.message(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                                    }
                                    debugData.endBlock();
                                }
                                IbusSubrouteNode.this.log.debug(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                debugData.message(String.format("after advice %s for subroute %s was successfully executed", adviceId, IbusSubrouteNode.this.descr.getId()));
                                break block8;
                            }
                            Throwable t2 = msg.getException();
                            IbusSubrouteNode.this.log.error(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                            debugData.message(String.format("exception was thrown for subroute %s, by after advice %s", IbusSubrouteNode.this.descr.getId(), adviceId), t2);
                        }
                        debugData.endBlock();
                    }

                    @Override
                    public BaseNodeDescription getDescription() {
                        return null;
                    }
                };
            }
            result.add(new AdviceParts(beforeNode, onExceptionNode, afterNode));
        }
        return result;
    }

    private IbusNode createAdviceNodeFromSubroute(String subrouteId, DebugData.DebugNodeType debugNodeType) throws Exception {
        BaseNodeDescription node = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(subrouteId);
        if (node == null) {
            throw Xeption.forDeveloper((String)"can't find node {0}", (Object[])new Object[]{subrouteId});
        }
        return this.clb.getFactory(node.getType()).createNode(subrouteId, this.clb);
    }

    public String toString() {
        return String.format("subroute %s", this.descr.getId());
    }

    public static class IbusSubrouteNodeFactory
    implements IbusNode.IbusNodesFactory<IbusNode> {
        @Override
        public IbusNode createNode(final String nodeId, final IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return IbusNodesHelper.createNode(nodeId, NodeType.SUBROUTE, new IbusNodesHelper.BuilderCallback<IbusSubrouteNode>(){

                @Override
                public IbusSubrouteNode createNode() throws Exception {
                    return new IbusSubrouteNode(nodeId, clb);
                }
            }, clb);
        }
    }

    static class AdviceParts {
        final IbusNode beforeNode;
        final IbusNode onExceptionNode;
        final IbusNode afterNode;

        public AdviceParts(IbusNode bf, IbusNode en, IbusNode an) {
            this.beforeNode = bf;
            this.onExceptionNode = en;
            this.afterNode = an;
        }
    }
}

