/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.components.RoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import com.gridnine.xtrip.server.ibus.model.RoutingKeyMetadata;
import com.gridnine.xtrip.server.ibus.model.SwitchCaseDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchDefaultDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchDescription;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusSwitchNode
implements IbusNode {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SwitchDescription descr;
    private final RoutingKeyMetadata metadata;
    private final RoutingKeyProvider provider;
    private final Map<String, NodeInfo> cases = new HashMap<String, NodeInfo>();
    private final NodeInfo defaultRoute;

    IbusSwitchNode(String switchId, IbusNode.IbusNodesFactoryIntegrationBusCallback callback) throws Exception {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getNode(switchId, SwitchDescription.class);
        this.metadata = reg.getMetadata(this.descr.getMetadataRef(), RoutingKeyMetadata.class);
        if (null == this.metadata) {
            throw new IllegalStateException(String.format("metadata not defined for switch %s", this.descr.getId()));
        }
        this.provider = (RoutingKeyProvider)XHelper.getClass((String)this.metadata.getKeyProviderClass()).newInstance();
        this.provider.configure(this.descr.getParameters());
        for (Map.Entry<String, SwitchCaseDescription> entry : this.descr.getCases().entrySet()) {
            String key = entry.getKey();
            this.cases.put(key, new NodeInfo(entry.getValue().getRef(), this.createNode(entry.getValue().getRef(), callback), IbusNodesHelper.createStackTrace(DebugData.DebugNodeType.SWITCH_CASE, key, entry.getValue())));
        }
        SwitchDefaultDescription defaultRouteDecr = this.descr.getDefaultRoute();
        this.defaultRoute = defaultRouteDecr != null ? new NodeInfo(defaultRouteDecr.getRef(), this.createNode(defaultRouteDecr.getRef(), callback), IbusNodesHelper.createStackTrace(DebugData.DebugNodeType.SWITCH_OTHERWISE, defaultRouteDecr.getId(), defaultRouteDecr)) : null;
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    private IbusNode createNode(String nodeId, IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
        BaseNodeDescription node = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(nodeId);
        return clb.getFactory(node.getType()).createNode(nodeId, clb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IbusMessage msg) {
        String key;
        DebugData debugData = msg.getDebugData();
        MessageContext ctx = msg.getMessageContext();
        try {
            key = this.provider.getRoutingKey(ctx);
        }
        catch (Throwable e) {
            msg.setException(IbusNodesHelper.prepareException(e, msg));
            debugData.message("unable to calculate routing key", e);
            this.log.error("error calculating routing key for switch " + this.descr.getId(), e);
            return;
        }
        NodeInfo route = this.cases.get(key);
        if (route != null) {
            debugData.startElement(key, DebugData.DebugNodeType.SWITCH_CASE);
            msg.beforeExecute(route.getStackTrace());
        } else {
            route = this.defaultRoute;
            if (null == route) {
                return;
            }
            debugData.startElement("default", DebugData.DebugNodeType.SWITCH_OTHERWISE);
            msg.beforeExecute(route.getStackTrace());
        }
        try {
            route.getNode().execute(msg);
        }
        finally {
            msg.afterExecute();
            debugData.endBlock();
        }
    }

    public String toString() {
        return String.format("switch %s", this.descr.getId());
    }

    public static class IbusSwitchNodeFactory
    implements IbusNode.IbusNodesFactory<IbusNode> {
        @Override
        public IbusNode createNode(final String nodeId, final IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return IbusNodesHelper.createNode(nodeId, NodeType.SWITCH, new IbusNodesHelper.BuilderCallback<IbusSwitchNode>(){

                @Override
                public IbusSwitchNode createNode() throws Exception {
                    return new IbusSwitchNode(nodeId, clb);
                }
            }, clb);
        }
    }

    private static class NodeInfo {
        private final String id;
        private final IbusNode node;
        private final StackTraceElement stackTrace;

        public NodeInfo(String id, IbusNode node, StackTraceElement stackTrace) {
            this.id = id;
            this.node = node;
            this.stackTrace = stackTrace;
        }

        public String getId() {
            return this.id;
        }

        public IbusNode getNode() {
            return this.node;
        }

        public StackTraceElement getStackTrace() {
            return this.stackTrace;
        }
    }
}

