/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.BreakException;
import com.gridnine.xtrip.server.ibus.components.ConditionProvider;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.components.WhileLoopOverflowException;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import com.gridnine.xtrip.server.ibus.model.WhileLoopDescription;
import com.gridnine.xtrip.server.ibus.model.WhileLoopMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusWhileLoopNode
implements IbusNode {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConditionProvider provider;
    private final WhileLoopDescription descr;
    private final WhileLoopMetadata metadata;
    private final IbusNode body;

    IbusWhileLoopNode(String whileLoopId, IbusNode.IbusNodesFactoryIntegrationBusCallback callback) throws Exception {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getNode(whileLoopId, WhileLoopDescription.class);
        this.metadata = reg.getMetadata(this.descr.getMetadataRef(), WhileLoopMetadata.class);
        this.provider = (ConditionProvider)XHelper.getClass((String)this.metadata.getConditionProviderClass()).newInstance();
        this.provider.configure(this.descr.getParameters());
        this.body = this.createNode(callback);
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    private IbusNode createNode(IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
        String nodeId = this.descr.getSubrouteRef();
        BaseNodeDescription node = ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getNode(nodeId);
        return clb.getFactory(node.getType()).createNode(nodeId, clb);
    }

    @Override
    public void execute(IbusMessage msg) {
        DebugData debugData;
        int loopCount;
        MessageContext ctx = msg.getMessageContext();
        int loop = loopCount = this.descr.getMaxLoopCount();
        while (msg.getException() == null) {
            block10: {
                try {
                    if (!this.provider.matches(ctx)) {
                    }
                    break block10;
                }
                catch (Throwable e) {
                    msg.setException(IbusNodesHelper.prepareException(e, msg));
                    debugData = msg.getDebugData();
                    debugData.message("error occurred while evaluating condition", e);
                }
                break;
            }
            this.body.execute(msg);
            if (loopCount <= 0 || --loop != 0) continue;
        }
        Throwable t = msg.getException();
        if (t instanceof BreakException) {
            msg.setException(null);
        } else if (null == t && loopCount > 0 && 0 == loop) {
            try {
                if (this.provider.matches(ctx)) {
                    debugData = msg.getDebugData();
                    debugData.message(String.format("While loop condition does not match after %s iterations", loopCount));
                    msg.setException(IbusNodesHelper.prepareException((Throwable)((Object)new WhileLoopOverflowException(this.descr.getId(), loopCount)), msg));
                }
            }
            catch (Throwable e) {
                msg.setException(IbusNodesHelper.prepareException(e, msg));
                DebugData debugData2 = msg.getDebugData();
                debugData2.message("error occured while evaluating condition", e);
            }
        }
    }

    public String toString() {
        return String.format("while loop %s", this.descr.getId());
    }

    public static class IbusWhileLoopNodeFactory
    implements IbusNode.IbusNodesFactory<IbusNode> {
        @Override
        public IbusNode createNode(final String nodeId, final IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return IbusNodesHelper.createNode(nodeId, NodeType.WHILE_LOOP, new IbusNodesHelper.BuilderCallback<IbusWhileLoopNode>(){

                @Override
                public IbusWhileLoopNode createNode() throws Exception {
                    return new IbusWhileLoopNode(nodeId, clb);
                }
            }, clb);
        }
    }
}

