/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.nodes;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusNode;
import com.gridnine.xtrip.server.ibus.impl.standard.nodes.IbusNodesHelper;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.NodeType;
import com.gridnine.xtrip.server.ibus.model.WireTapDescription;

public class IbusWireTapNode
implements IbusNode {
    private final IbusNode.IbusNodesFactoryIntegrationBusCallback clb;
    private final WireTapDescription descr;

    IbusWireTapNode(String switchId, IbusNode.IbusNodesFactoryIntegrationBusCallback callback) throws Exception {
        this.clb = callback;
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = reg.getNode(switchId, WireTapDescription.class);
    }

    @Override
    public BaseNodeDescription getDescription() {
        return this.descr;
    }

    @Override
    public void execute(IbusMessage msg) {
        try {
            this.clb.wireTap(msg, this.descr.getEndPoint(), this.descr.getId(), this);
        }
        catch (Throwable e) {
            msg.setException(IbusNodesHelper.prepareException(e, msg));
        }
        DebugData debugData = msg.getDebugData();
        debugData.message("routing to wire tap " + this.descr.getId());
    }

    public String toString() {
        return String.format("wire tap %s", this.descr.getId());
    }

    public static class IbusWireTapNodeFactory
    implements IbusNode.IbusNodesFactory<IbusNode> {
        @Override
        public IbusNode createNode(final String nodeId, final IbusNode.IbusNodesFactoryIntegrationBusCallback clb) throws Exception {
            return IbusNodesHelper.createNode(nodeId, NodeType.WIRETAP, new IbusNodesHelper.BuilderCallback<IbusWireTapNode>(){

                @Override
                public IbusWireTapNode createNode() throws Exception {
                    return new IbusWireTapNode(nodeId, clb);
                }
            }, clb);
        }
    }
}

