/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.impl.standard.statistics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MulticallNodeStatistics {
    public static ConcurrentMap<MulticallTargetId, TargetData> TARGET_DATA = new ConcurrentHashMap<MulticallTargetId, TargetData>();

    public static class TargetData {
        private final AtomicInteger internalThreadCount = new AtomicInteger();
        private final AtomicInteger realThreadCount = new AtomicInteger();
        private final AtomicInteger maxThreads = new AtomicInteger();
        private final AtomicLong timeout = new AtomicLong();
        private final AtomicLong time = new AtomicLong();
        private final AtomicBoolean flag = new AtomicBoolean();
        private final AtomicInteger timeoutCount = new AtomicInteger();
        private final AtomicInteger timeoutCount2 = new AtomicInteger();
        private final AtomicInteger successedCount = new AtomicInteger();
        private final AtomicInteger successedCount2 = new AtomicInteger();
        private final AtomicInteger rejectedCount = new AtomicInteger();
        private final AtomicInteger rejectedCount2 = new AtomicInteger();
        private final AtomicLong minDuration = new AtomicLong();
        private final AtomicLong minDuration2 = new AtomicLong();
        private final AtomicLong maxDuration = new AtomicLong();
        private final AtomicLong maxDuration2 = new AtomicLong();
        private final AtomicLong averageDuration = new AtomicLong();
        private final AtomicLong averageDuration2 = new AtomicLong();

        public AtomicInteger getInternalThreadCount() {
            return this.internalThreadCount;
        }

        public AtomicInteger getRealThreadCount() {
            return this.realThreadCount;
        }

        public void timeout() {
            this.roll();
            this.timeoutCount2.incrementAndGet();
        }

        public void reject() {
            this.roll();
            this.rejectedCount2.incrementAndGet();
        }

        public void success(long duration) {
            this.roll();
            this.successedCount2.incrementAndGet();
            this.averageDuration2.addAndGet(duration);
            if (this.minDuration2.get() > duration) {
                this.minDuration2.set(duration);
            }
            if (this.maxDuration2.get() < duration) {
                this.maxDuration2.set(duration);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void roll() {
            long now = System.currentTimeMillis();
            long d = TimeUnit.MILLISECONDS.toSeconds(now - this.time.get());
            if (d > 120L) {
                if (this.flag.compareAndSet(false, true)) {
                    try {
                        this.time.set(now);
                        this.timeoutCount.set(0);
                        this.timeoutCount2.set(0);
                        this.successedCount.set(0);
                        this.successedCount2.set(0);
                        this.rejectedCount.set(0);
                        this.rejectedCount2.set(0);
                        this.minDuration.set(0L);
                        this.minDuration2.set(0L);
                        this.maxDuration.set(0L);
                        this.maxDuration2.set(0L);
                        this.averageDuration.set(0L);
                        this.averageDuration2.set(0L);
                    }
                    finally {
                        this.flag.set(false);
                    }
                }
            } else if (d > 60L && this.flag.compareAndSet(false, true)) {
                try {
                    this.time.set(now);
                    this.timeoutCount.set(this.timeoutCount2.getAndSet(0));
                    int sc = this.successedCount2.getAndSet(0);
                    long avg = this.averageDuration2.getAndSet(0L);
                    this.successedCount.set(sc);
                    this.rejectedCount.set(this.rejectedCount2.getAndSet(0));
                    this.minDuration.set(this.minDuration2.getAndSet(0L));
                    this.maxDuration.set(this.maxDuration2.getAndSet(0L));
                    this.averageDuration.set(sc != 0 ? avg / (long)sc : 0L);
                }
                finally {
                    this.flag.set(false);
                }
            }
        }

        public int getMaxThreads() {
            return this.maxThreads.get();
        }

        public void setMaxThreads(int maxThreads) {
            this.maxThreads.set(maxThreads);
        }

        public long getTimeout() {
            return this.timeout.get();
        }

        public void setTimeout(long timeout) {
            this.timeout.set(timeout);
        }

        public int getExecutedPerMinute() {
            this.roll();
            return this.successedCount.get();
        }

        public int getRejectedPerMinute() {
            this.roll();
            return this.rejectedCount.get();
        }

        public int getTimeOutErrorsPerMinute() {
            this.roll();
            return this.timeoutCount.get();
        }

        public long getMinExecutionTime() {
            this.roll();
            return this.minDuration.get();
        }

        public long getMaxExecutionTime() {
            this.roll();
            return this.maxDuration.get();
        }

        public long getAverageExecutionTime() {
            this.roll();
            return this.averageDuration.get();
        }
    }

    public static class MulticallTargetId {
        private final String multicallId;
        private final Object target;

        public MulticallTargetId(String multicallId, Object target) {
            this.multicallId = multicallId;
            this.target = target;
        }

        public String getMulticallId() {
            return this.multicallId;
        }

        public Object getTarget() {
            return this.target;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.multicallId == null ? 0 : this.multicallId.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MulticallTargetId other = (MulticallTargetId)obj;
            if (this.multicallId == null ? other.multicallId != null : !this.multicallId.equals(other.multicallId)) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }
    }
}

