/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.parser;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.model.AdapterDescription;
import com.gridnine.xtrip.server.ibus.model.AdviceDescription;
import com.gridnine.xtrip.server.ibus.model.AdviceMetadata;
import com.gridnine.xtrip.server.ibus.model.BaseElementMetadata;
import com.gridnine.xtrip.server.ibus.model.BaseItemDescription;
import com.gridnine.xtrip.server.ibus.model.DebugHandlerDescription;
import com.gridnine.xtrip.server.ibus.model.DebugHandlerMetadata;
import com.gridnine.xtrip.server.ibus.model.DirectEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.EmailInEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.EmailOutEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.IteratorDescription;
import com.gridnine.xtrip.server.ibus.model.IteratorMetadata;
import com.gridnine.xtrip.server.ibus.model.JmsInEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.JmsOutEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.MulticallDescription;
import com.gridnine.xtrip.server.ibus.model.MulticallMetadata;
import com.gridnine.xtrip.server.ibus.model.ParameterType;
import com.gridnine.xtrip.server.ibus.model.ProcessorDescription;
import com.gridnine.xtrip.server.ibus.model.ProcessorMetadata;
import com.gridnine.xtrip.server.ibus.model.RestfulInEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.RouteDescription;
import com.gridnine.xtrip.server.ibus.model.RouteMetadata;
import com.gridnine.xtrip.server.ibus.model.RoutingKeyMetadata;
import com.gridnine.xtrip.server.ibus.model.SubrouteDescription;
import com.gridnine.xtrip.server.ibus.model.SubrouteMetadata;
import com.gridnine.xtrip.server.ibus.model.SwitchCaseDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchDefaultDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchDescription;
import com.gridnine.xtrip.server.ibus.model.WhileLoopDescription;
import com.gridnine.xtrip.server.ibus.model.WhileLoopMetadata;
import com.gridnine.xtrip.server.ibus.model.WireTapDescription;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class IntegrationBusRegistryXmlProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> registeredIds = new HashSet<String>();
    private final Set<String> generatedIds = new HashSet<String>();
    private URL currentXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(URL xml, String local) throws Exception {
        this.log.debug("registering " + xml);
        this.registeredIds.clear();
        this.currentXml = xml;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream is = IoUtil.getResourceInputStream((URL)xml);){
                IoUtil.copyStream((InputStream)is, (OutputStream)baos, (int)256);
            }
            byte[] content = baos.toByteArray();
            String strContent = new String(content, "utf-8");
            if (!strContent.contains("<context ")) {
                return;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            Element rootElm = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }

                @Override
                public void fatalError(SAXParseException ex) throws SAXException {
                    throw ex;
                }

                @Override
                public void warning(SAXParseException ex) throws SAXException {
                }
            });
            Document doc = docBuilder.newDocument();
            DOMResult domResult = new DOMResult(doc);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(IntegrationBusRegistryXmlProcessor.class.getResource("integration-bus_1_0.xsd")));
            LocationAnnotator locationAnnotator = new LocationAnnotator(saxFactory.newSAXParser().getXMLReader(), doc);
            SAXSource saxSource = new SAXSource(locationAnnotator, new InputSource(bis));
            Transformer nullTransformer = TransformerFactory.newInstance().newTransformer();
            nullTransformer.transform(saxSource, domResult);
            rootElm = ((Document)domResult.getNode()).getDocumentElement();
            String packageName = rootElm.getAttribute("package");
            IntegrationBusRegistry registry = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
            for (Element elm : XmlUtil.getChildren((Element)rootElm)) {
                this.registerElement(elm, registry, packageName, local);
            }
        }
        catch (Throwable t) {
            this.log.error("failed registering ibus components from file " + xml, t);
            throw new Exception("failed registering ibus components from file " + xml, t);
        }
    }

    private String registerElement(Element elm, IntegrationBusRegistry registry, String packageName, String local) {
        String name = elm.getNodeName();
        if ("endpoint-direct".equals(name)) {
            return this.registerDirectEndPoint(registry, elm, packageName, local);
        }
        if ("endpoint-rest-in".equals(name)) {
            return this.registerRestfullInEndPoint(registry, elm, packageName, local);
        }
        if ("endpoint-email-in".equals(name)) {
            return this.registerEmailInEndPoint(registry, elm, packageName, local);
        }
        if ("endpoint-email-out".equals(name)) {
            return this.registerEmailOutEndPoint(registry, elm, packageName, local);
        }
        if ("endpoint-jms-in".equals(name)) {
            return this.registerJmsInEndPoint(registry, elm, packageName, local);
        }
        if ("endpoint-jms-out".equals(name)) {
            return this.registerJmsOutEndPoint(registry, elm, packageName, local);
        }
        if ("advice".equals(name)) {
            return this.registerAdvice(registry, elm, packageName, local);
        }
        if ("advice-metadata".equals(name)) {
            return this.registerAdviceMetadata(registry, elm, packageName, null, local);
        }
        if ("adapter".equals(name)) {
            return this.registerAdapter(registry, elm, packageName, local);
        }
        if ("debug-handler".equals(name)) {
            return this.registerDebugHandler(registry, elm, packageName, local);
        }
        if ("debug-handler-metadata".equals(name)) {
            return this.registerDebugHandlerMetadata(registry, elm, packageName, null, local);
        }
        if ("processor-metadata".equals(name)) {
            return this.registerProcessorMetadata(registry, elm, packageName, null, local);
        }
        if ("processor".equals(name)) {
            return this.registerProcessor(registry, elm, packageName, local);
        }
        if ("routing-key-metadata".equals(name)) {
            return this.registerRoutingKeyMetadata(registry, elm, packageName, null, local);
        }
        if ("switch".equals(name)) {
            return this.registerSwitch(registry, elm, packageName, local);
        }
        if ("wiretap".equals(name)) {
            return this.registerWireTap(registry, elm, packageName, local);
        }
        if ("subroute-metadata".equals(name)) {
            return this.registerSubrouteMetadata(registry, elm, packageName, null, local);
        }
        if ("subroute".equals(name)) {
            return this.registerSubroute(registry, elm, packageName, local);
        }
        if ("route-metadata".equals(name)) {
            return this.registerRouteMetadata(registry, elm, packageName, null, local);
        }
        if ("route".equals(name)) {
            return this.registerRoute(registry, elm, packageName, local);
        }
        if ("multicall".equals(name)) {
            return this.registerMulticall(registry, elm, packageName, local);
        }
        if ("multicall-metadata".equals(name)) {
            return this.registerMulticallMetadata(registry, elm, packageName, null, local);
        }
        if ("iterator".equals(name)) {
            return this.registerIterator(registry, elm, packageName, local);
        }
        if ("iterator-metadata".equals(name)) {
            return this.registerIteratorMetadata(registry, elm, packageName, null, local);
        }
        if ("while".equals(name)) {
            return this.registerWhileLoop(registry, elm, packageName, local);
        }
        if ("while-metadata".equals(name)) {
            return this.registerWhileLoopMetadata(registry, elm, packageName, null, local);
        }
        throw new IllegalArgumentException("illegal node name " + name);
    }

    private String registerRoute(IntegrationBusRegistry registry, Element elm, String packageName, String local) {
        Element debugHandlerElm;
        String endEndPoint;
        String startEndpointRef = elm.getAttribute("start-endpoint-ref");
        String id = this.buildId(packageName, elm, "id", startEndpointRef);
        RouteDescription descr = registry.getNode(id, RouteDescription.class);
        if (descr == null) {
            descr = new RouteDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerNode(descr);
        }
        if (!TextUtil.isBlank((String)startEndpointRef)) {
            descr.setStartPoint(this.buildRef(packageName, elm, "start-endpoint-ref"));
        }
        if (!TextUtil.isBlank((String)(endEndPoint = elm.getAttribute("end-endpoint-ref")))) {
            descr.setEndPoint(this.buildRef(packageName, elm, "end-endpoint-ref"));
        }
        if ((debugHandlerElm = XmlUtil.getElement((Element)elm, (String)"debug-handler")) != null) {
            descr.setDebugHandler(this.registerDebugHandler(registry, debugHandlerElm, packageName, local));
        } else {
            debugHandlerElm = XmlUtil.getElement((Element)elm, (String)"debug-handler-ref");
            if (debugHandlerElm != null) {
                descr.setDebugHandler(this.buildRef(packageName, debugHandlerElm, "ref"));
            }
        }
        String metadataId = null;
        Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
        if (metadata != null) {
            metadataId = this.registerRouteMetadata(registry, metadata, packageName, id, local);
            descr.setMetadataRef(metadataId);
        } else if (!TextUtil.isBlank((String)elm.getAttribute("metadata-ref"))) {
            descr.setMetadataRef(this.buildRef(packageName, elm, "metadata-ref"));
        }
        this.updateDescription(descr, elm, registry, packageName, local);
        return descr.getId();
    }

    private void setLocation(BaseItemDescription descr, Element elm) {
        LocationData locationData = (LocationData)elm.getUserData("locationDataKey");
        if (locationData != null) {
            descr.setLineNumber(locationData.getStartLine());
        }
    }

    private String registerAdapter(IntegrationBusRegistry registry, Element elm, String packageName, String local) {
        String id = this.buildId(packageName, elm, "id");
        AdapterDescription descr = registry.getRequestReplyAdapter(id);
        if (descr == null) {
            descr = new AdapterDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerRequestReplyAdapter(descr);
        }
        descr.setStartPoint(this.buildRef(packageName, elm, "start-endpoint-ref"));
        descr.setEndPoint(this.buildRef(packageName, elm, "end-endpoint-ref"));
        for (Element paramEl : XmlUtil.getElements((Element)elm, (String)"return-param")) {
            descr.getReturnParams().add(paramEl.getAttribute("name"));
        }
        return descr.getId();
    }

    private String registerDebugHandler(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        DebugHandlerDescription descr = registry.getDebugHandler(id);
        if (descr == null) {
            descr = new DebugHandlerDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerDebugHandler(descr);
        }
        String metadataId = null;
        Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
        metadataId = metadata != null ? this.registerDebugHandlerMetadata(registry, metadata, idsPreffix, id, local) : this.buildRef(idsPreffix, elm, "metadata-ref");
        descr.setMetadataRef(metadataId);
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private void updateDescription(SubrouteDescription descr, Element elm, IntegrationBusRegistry registry, String idsPreffix, String local) {
        if (descr.getId() == null) {
            descr.setId(this.buildId(idsPreffix, elm, "id"));
        }
        for (Element child : XmlUtil.getChildren((Element)elm)) {
            int idx;
            String ref;
            String name = child.getNodeName();
            if ("advice".equals(name) || "advice-ref".equals(name)) {
                String id = null;
                id = "advice".equals(name) ? this.registerAdvice(registry, child, idsPreffix, local) : this.buildRef(idsPreffix, child, "ref");
                if (!TextUtil.isBlank((String)child.getAttribute("insert-before"))) {
                    ref = this.buildRef(idsPreffix, child, "insert-before");
                    idx = descr.getAdvices().indexOf(ref);
                    if (idx == -1) {
                        throw Xeption.forDeveloper((String)"node {0} referenced in insert-before not found", (Object[])new Object[]{child.getAttribute("insert-before")});
                    }
                    descr.getAdvices().add(idx != -1 ? idx : descr.getAdvices().size(), id);
                    continue;
                }
                if (!TextUtil.isBlank((String)child.getAttribute("insert-after"))) {
                    ref = this.buildRef(idsPreffix, child, "insert-after");
                    idx = descr.getAdvices().indexOf(ref);
                    if (idx == -1) {
                        throw Xeption.forDeveloper((String)"node {0} referenced in insert-after not found", (Object[])new Object[]{child.getAttribute("insert-after")});
                    }
                    descr.getAdvices().add(idx != -1 ? idx + 1 : descr.getAdvices().size(), id);
                    continue;
                }
                if (!TextUtil.isBlank((String)child.getAttribute("insert-instead"))) {
                    ref = this.buildRef(idsPreffix, child, "insert-instead");
                    idx = descr.getAdvices().indexOf(ref);
                    if (idx == -1) {
                        throw Xeption.forDeveloper((String)"node {0} referenced in insert-instead not found", (Object[])new Object[]{child.getAttribute("insert-instead")});
                    }
                    descr.getAdvices().set(idx, id);
                    continue;
                }
                if ("true".equals(child.getAttribute("insert-first"))) {
                    descr.getAdvices().add(0, id);
                    continue;
                }
                descr.getAdvices().add(id);
                continue;
            }
            String nodeId = this.getNodeId(child, registry, idsPreffix, local);
            if (nodeId == null) continue;
            if (!TextUtil.isBlank((String)child.getAttribute("insert-before"))) {
                ref = this.buildRef(idsPreffix, child, "insert-before");
                idx = descr.getNodes().indexOf(ref);
                if (idx == -1) {
                    throw Xeption.forDeveloper((String)"node {0} referenced in insert-before not found", (Object[])new Object[]{child.getAttribute("insert-before")});
                }
                descr.getNodes().add(idx != -1 ? idx : descr.getNodes().size(), nodeId);
                continue;
            }
            if (!TextUtil.isBlank((String)child.getAttribute("insert-after"))) {
                ref = this.buildRef(idsPreffix, child, "insert-after");
                idx = descr.getNodes().indexOf(ref);
                if (idx == -1) {
                    throw Xeption.forDeveloper((String)"node {0} referenced in insert-after not found", (Object[])new Object[]{child.getAttribute("insert-after")});
                }
                descr.getNodes().add(idx != -1 ? idx + 1 : descr.getNodes().size(), nodeId);
                continue;
            }
            if (!TextUtil.isBlank((String)child.getAttribute("insert-instead"))) {
                ref = this.buildRef(idsPreffix, child, "insert-instead");
                idx = descr.getNodes().indexOf(ref);
                if (idx == -1) {
                    throw Xeption.forDeveloper((String)"node {0} referenced in insert-instead not found", (Object[])new Object[]{child.getAttribute("insert-instead")});
                }
                descr.getNodes().set(idx, nodeId);
                continue;
            }
            if ("true".equals(child.getAttribute("insert-first"))) {
                descr.getNodes().add(0, nodeId);
                continue;
            }
            descr.getNodes().add(nodeId);
        }
    }

    private String getNodeId(Element child, IntegrationBusRegistry registry, String idsPreffix, String local) {
        String name = child.getNodeName();
        if ("processor".equals(name)) {
            return this.registerProcessor(registry, child, idsPreffix, local);
        }
        if ("processor-ref".equals(name)) {
            return this.buildRef(idsPreffix, child, "ref");
        }
        if ("subroute".equals(name)) {
            return this.registerSubroute(registry, child, idsPreffix, local);
        }
        if ("subroute-ref".equals(name)) {
            return this.buildRef(idsPreffix, child, "ref");
        }
        if ("switch".equals(name)) {
            return this.registerSwitch(registry, child, idsPreffix, local);
        }
        if ("switch-ref".equals(name)) {
            return this.buildRef(idsPreffix, child, "ref");
        }
        if ("wiretap".equals(name)) {
            return this.registerWireTap(registry, child, idsPreffix, local);
        }
        if ("wiretap-ref".equals(name)) {
            return this.buildRef(idsPreffix, child, "ref");
        }
        if ("multicall".equals(name)) {
            return this.registerMulticall(registry, child, idsPreffix, local);
        }
        if ("multicall-ref".equals(name)) {
            return this.buildRef(idsPreffix, child, "ref");
        }
        if ("iterator".equals(name)) {
            return this.registerIterator(registry, child, idsPreffix, local);
        }
        if ("iterator-ref".equals(name)) {
            return this.buildRef(idsPreffix, child, "ref");
        }
        if ("while".equals(name)) {
            return this.registerWhileLoop(registry, child, idsPreffix, local);
        }
        if ("while-ref".equals(name)) {
            return this.buildRef(idsPreffix, child, "ref");
        }
        return null;
    }

    private String registerDirectEndPoint(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        DirectEndpointDescription descr = registry.getEndpoint(id, DirectEndpointDescription.class);
        if (descr == null) {
            descr = new DirectEndpointDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerEndpoint(descr);
            String compoundId = String.format("endpoint-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("endpoint with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerEmailOutEndPoint(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String keyStr;
        String id = this.buildId(idsPreffix, elm, "id");
        EmailOutEndpointDescription descr = registry.getEndpoint(id, EmailOutEndpointDescription.class);
        if (descr == null) {
            descr = new EmailOutEndpointDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerEndpoint(descr);
            String compoundId = String.format("endpoint-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("endpoint with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        if (!TextUtil.isBlank((String)(keyStr = XHelper.readString((Element)elm, (String)"@document-key")))) {
            descr.setDocumentKey(keyStr);
        }
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerEmailInEndPoint(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        EmailInEndpointDescription descr = registry.getEndpoint(id, EmailInEndpointDescription.class);
        if (descr == null) {
            descr = new EmailInEndpointDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerEndpoint(descr);
            String compoundId = String.format("endpoint-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("endpoint with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        this.updateParameters(descr, elm);
        descr.setSettingsUid(elm.getAttribute("settings-uid"));
        return descr.getId();
    }

    private String registerRestfullInEndPoint(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        RestfulInEndpointDescription descr = registry.getEndpoint(id, RestfulInEndpointDescription.class);
        if (descr == null) {
            descr = new RestfulInEndpointDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerEndpoint(descr);
            String compoundId = String.format("endpoint-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("endpoint with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        this.updateParameters(descr, elm);
        descr.setPath(elm.getAttribute("path"));
        descr.setDescription(XHelper.readString((Element)elm, (String)"description"));
        for (Element issueElm : XmlUtil.getElements((Element)elm, (String)"issue")) {
            descr.getIssues().put(issueElm.getAttribute("title"), XmlUtil.getValue((Element)issueElm));
        }
        for (Element issueElm : XmlUtil.getElements((Element)elm, (String)"issue-builder")) {
            descr.getIssueBuilderList().put(issueElm.getAttribute("title"), XmlUtil.getValue((Element)issueElm));
        }
        return descr.getId();
    }

    private String registerJmsInEndPoint(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        JmsInEndpointDescription descr = registry.getEndpoint(id, JmsInEndpointDescription.class);
        if (descr == null) {
            descr = new JmsInEndpointDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerEndpoint(descr);
            String compoundId = String.format("endpoint-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("endpoint with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setQueue(elm.getAttribute("queue"));
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerJmsOutEndPoint(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        JmsOutEndpointDescription descr = registry.getEndpoint(id, JmsOutEndpointDescription.class);
        if (descr == null) {
            descr = new JmsOutEndpointDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerEndpoint(descr);
            String compoundId = String.format("endpoint-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("endpoint with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setQueue(elm.getAttribute("queue"));
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private void updateParameters(BaseElementMetadata descr, Element elm) {
        descr.setDescription(XHelper.readString((Element)elm, (String)"description"));
        for (Element item : XmlUtil.getElements((Element)elm, (String)"param")) {
            descr.getParameters().put(item.getAttribute("name"), XHelper.readString((Element)item, (String)"."));
        }
    }

    private void updateParameters(BaseItemDescription descr, Element elm) {
        for (Element item : XmlUtil.getElements((Element)elm, (String)"param")) {
            descr.getParameters().put(item.getAttribute("name"), XHelper.readString((Element)item, (String)"."));
        }
    }

    private String registerWireTap(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        WireTapDescription descr = (WireTapDescription)registry.getNode(id);
        if (descr == null) {
            descr = new WireTapDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerNode(descr);
            String compoundId = String.format("node-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("node with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        this.updateParameters(descr, elm);
        descr.setEndPoint(this.buildRef(idsPreffix, elm, "endpoint-ref"));
        return descr.getId();
    }

    private String registerSwitch(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "key-provider", registry, new MetadataClassNameHandler<RoutingKeyMetadata>(){

            @Override
            public String getClassName(RoutingKeyMetadata metadata) {
                return metadata.getKeyProviderClass();
            }
        });
        SwitchDescription descr = (SwitchDescription)registry.getNode(id);
        if (descr == null) {
            descr = new SwitchDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerNode(descr);
            String compoundId = String.format("node-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("node with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        if (descr.getMetadataRef() == null) {
            Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
            String metadataId = null;
            metadataId = metadata != null ? this.registerRoutingKeyMetadata(registry, metadata, idsPreffix, id, local) : this.buildRef(idsPreffix, elm, "metadata-ref");
            descr.setMetadataRef(metadataId);
        }
        this.updateParameters(descr, elm);
        for (Element child : XmlUtil.getChildren((Element)elm)) {
            String name = child.getNodeName();
            if ("metadata".equals(name) || "param".equals(name)) continue;
            if ("case".equals(name)) {
                SwitchCaseDescription caseDescr;
                String caseId;
                Element[] caseChildren = XmlUtil.getChildren((Element)child);
                if (caseChildren.length != 1) {
                    throw new IllegalArgumentException("'case' should have only 1 child");
                }
                Element caseChild = caseChildren[0];
                String caseChildName = caseChild.getNodeName();
                if ("subroute".equals(caseChildName)) {
                    caseId = child.getAttribute("value");
                    caseDescr = new SwitchCaseDescription();
                    caseDescr.setId(caseId);
                    caseDescr.setFile(local);
                    this.setLocation(caseDescr, child);
                    caseDescr.setRef(this.registerSubroute(registry, caseChild, idsPreffix, local));
                    descr.getCases().put(caseId, caseDescr);
                    continue;
                }
                if ("subroute-ref".equals(caseChildName)) {
                    caseId = child.getAttribute("value");
                    caseDescr = new SwitchCaseDescription();
                    caseDescr.setId(caseId);
                    caseDescr.setFile(local);
                    this.setLocation(caseDescr, child);
                    caseDescr.setRef(this.buildRef(idsPreffix, caseChild, "ref"));
                    descr.getCases().put(caseId, caseDescr);
                    continue;
                }
                throw new IllegalArgumentException("unsupported 'case' child name " + caseChildName);
            }
            if ("default".equals(name)) {
                SwitchDefaultDescription defaultDescr;
                Element[] defChildren = XmlUtil.getChildren((Element)child);
                if (defChildren.length != 1) {
                    throw new IllegalArgumentException("'default' should have only 1 child");
                }
                Element defChild = defChildren[0];
                String defChildName = defChild.getNodeName();
                if ("subroute".equals(defChildName)) {
                    defaultDescr = new SwitchDefaultDescription();
                    defaultDescr.setId("default");
                    defaultDescr.setFile(local);
                    this.setLocation(defaultDescr, child);
                    defaultDescr.setRef(this.registerSubroute(registry, defChild, idsPreffix, local));
                    descr.setDefaultRoute(defaultDescr);
                    continue;
                }
                if ("subroute-ref".equals(defChildName)) {
                    defaultDescr = new SwitchDefaultDescription();
                    defaultDescr.setId("default");
                    defaultDescr.setFile(local);
                    this.setLocation(defaultDescr, child);
                    defaultDescr.setRef(this.buildRef(idsPreffix, defChild, "ref"));
                    descr.setDefaultRoute(defaultDescr);
                    continue;
                }
                throw new IllegalArgumentException("unsupported 'default' child name " + defChildName);
            }
            throw new IllegalArgumentException("unsupported name " + name);
        }
        return descr.getId();
    }

    private String registerSubroute(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        SubrouteDescription descr = (SubrouteDescription)registry.getNode(id);
        if (descr == null) {
            descr = new SubrouteDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerNode(descr);
            String compoundId = String.format("node-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("node with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        String metadataId = null;
        Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
        metadataId = metadata != null ? this.registerSubrouteMetadata(registry, metadata, idsPreffix, id, local) : this.buildRef(idsPreffix, elm, "metadata-ref");
        if (metadataId != null) {
            descr.setMetadataRef(metadataId);
        }
        this.updateDescription(descr, elm, registry, idsPreffix, local);
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerProcessor(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "class", registry, new MetadataClassNameHandler<ProcessorMetadata>(){

            @Override
            public String getClassName(ProcessorMetadata metadata) {
                return metadata.getImplementationClassName();
            }
        });
        try {
            String idStr;
            ProcessorDescription descr = (ProcessorDescription)registry.getNode(id);
            if (descr == null) {
                descr = new ProcessorDescription();
                descr.setId(id);
                descr.setFile(local);
                this.setLocation(descr, elm);
                registry.registerNode(descr);
                String compoundId = String.format("node-%s", id);
                if (this.registeredIds.contains(compoundId)) {
                    throw new IllegalArgumentException(String.format("node with id %s is already registered in xml %s", id, this.currentXml));
                }
                this.registeredIds.add(compoundId);
            }
            String metadataId = null;
            Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
            metadataId = metadata != null ? this.registerProcessorMetadata(registry, metadata, idsPreffix, TextUtil.isBlank((String)(idStr = metadata.getAttribute("id"))) ? id : this.buildId(idsPreffix, metadata, "id"), local) : this.buildRef(idsPreffix, elm, "metadata-ref");
            if (metadataId != null) {
                descr.setMetadataRef(metadataId);
            }
            this.updateParameters(descr, elm);
            return descr.getId();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to register processor " + id + ": " + e.getMessage(), e);
        }
    }

    private String generateIdFromClassName(String className) {
        String simpleName;
        String result = simpleName = className.substring(className.lastIndexOf(".") + 1);
        int n = 0;
        while (this.generatedIds.contains(result)) {
            result = simpleName + ++n;
        }
        this.generatedIds.add(result);
        return result;
    }

    private String registerMulticall(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "targets-provider", registry, new MetadataClassNameHandler<MulticallMetadata>(){

            @Override
            public String getClassName(MulticallMetadata metadata) {
                return metadata.getTargetsProviderImpl();
            }
        });
        MulticallDescription descr = registry.getNode(id, MulticallDescription.class);
        if (descr == null) {
            descr = new MulticallDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerNode(descr);
            String compoundId = String.format("node-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("node with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        String metadataId = descr.getMetadataRef();
        Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
        if (metadata != null) {
            metadataId = this.registerMulticallMetadata(registry, metadata, idsPreffix, id, local);
        } else {
            String metadataRef = XHelper.readString((Element)elm, (String)"@metadata-ref");
            if (!TextUtil.isBlank((String)metadataRef)) {
                metadataId = this.buildRef(idsPreffix, elm, "metadata-ref");
            }
        }
        descr.setMetadataRef(metadataId);
        this.updateParameters(descr, elm);
        for (Element child : XmlUtil.getChildren((Element)elm)) {
            String name = child.getNodeName();
            if ("metadata".equals(name) || "param".equals(name)) continue;
            if ("subroute".equals(name)) {
                descr.setSubrouteRef(this.registerSubroute(registry, child, idsPreffix, local));
                continue;
            }
            if ("subroute-ref".equals(name)) {
                descr.setSubrouteRef(this.buildRef(idsPreffix, child, "ref"));
                continue;
            }
            throw new IllegalArgumentException(String.format("unsupported name %s in multicall %s", name, descr.getId()));
        }
        return descr.getId();
    }

    private String registerIterator(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        IteratorDescription descr = registry.getNode(id, IteratorDescription.class);
        if (descr == null) {
            descr = new IteratorDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerNode(descr);
            String compoundId = String.format("node-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("node with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        String metadataId = descr.getMetadataRef();
        Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
        if (metadata != null) {
            metadataId = this.registerIteratorMetadata(registry, metadata, idsPreffix, id, local);
        } else {
            String metadataRef = XHelper.readString((Element)elm, (String)"@metadata-ref");
            String targetKey = XHelper.readString((Element)elm, (String)"@target-key");
            if (!TextUtil.isBlank((String)metadataRef)) {
                metadataId = this.buildRef(idsPreffix, elm, "metadata-ref");
            }
            if (!TextUtil.isBlank((String)targetKey)) {
                descr.setTargetKey(targetKey);
            }
        }
        descr.setMetadataRef(metadataId);
        this.updateParameters(descr, elm);
        for (Element child : XmlUtil.getChildren((Element)elm)) {
            String name = child.getNodeName();
            if ("metadata".equals(name) || "param".equals(name)) continue;
            if ("subroute".equals(name)) {
                descr.setSubrouteRef(this.registerSubroute(registry, child, idsPreffix, local));
                continue;
            }
            if ("subroute-ref".equals(name)) {
                descr.setSubrouteRef(this.buildRef(idsPreffix, child, "ref"));
                continue;
            }
            throw new IllegalArgumentException(String.format("unsupported name %s in multicall %s", name, descr.getId()));
        }
        return descr.getId();
    }

    private String registerWhileLoop(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id = this.buildId(idsPreffix, elm, "id");
        WhileLoopDescription descr = registry.getNode(id, WhileLoopDescription.class);
        if (descr == null) {
            descr = new WhileLoopDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerNode(descr);
            String compoundId = String.format("node-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("node with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        String metadataId = descr.getMetadataRef();
        Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
        if (metadata != null) {
            metadataId = this.registerWhileLoopMetadata(registry, metadata, idsPreffix, id, local);
        } else {
            String metadataRef = XHelper.readString((Element)elm, (String)"@metadata-ref");
            if (!TextUtil.isBlank((String)metadataRef)) {
                metadataId = this.buildRef(idsPreffix, elm, "metadata-ref");
            }
        }
        descr.setMetadataRef(metadataId);
        String maxLoopCount = XHelper.readString((Element)elm, (String)"@max-loop-count");
        if (!TextUtil.isBlank((String)maxLoopCount)) {
            descr.setMaxLoopCount(Integer.parseInt(maxLoopCount));
        }
        this.updateParameters(descr, elm);
        for (Element child : XmlUtil.getChildren((Element)elm)) {
            String name = child.getNodeName();
            if ("metadata".equals(name) || "param".equals(name)) continue;
            if ("subroute".equals(name)) {
                descr.setSubrouteRef(this.registerSubroute(registry, child, idsPreffix, local));
                continue;
            }
            if ("subroute-ref".equals(name)) {
                descr.setSubrouteRef(this.buildRef(idsPreffix, child, "ref"));
                continue;
            }
            throw new IllegalArgumentException(String.format("unsupported name %s in multicall %s", name, descr.getId()));
        }
        return descr.getId();
    }

    private String registerAdviceMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        AdviceMetadata descr = (AdviceMetadata)registry.getMetadata(id);
        if (descr == null) {
            descr = new AdviceMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        if (!TextUtil.isBlank((String)elm.getAttribute("class"))) {
            descr.setImplementationClassName(elm.getAttribute("class"));
        }
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerSubrouteMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        SubrouteMetadata descr = (SubrouteMetadata)registry.getMetadata(id);
        if (descr == null) {
            descr = new SubrouteMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        for (Element item : XmlUtil.getElements((Element)elm, (String)"local-variable")) {
            descr.getLocalVariables().add(item.getAttribute("name"));
        }
        for (Element item : XmlUtil.getElements((Element)elm, (String)"input-param")) {
            descr.getInputParams().add(item.getAttribute("name"));
        }
        for (Element item : XmlUtil.getElements((Element)elm, (String)"affected-param")) {
            descr.getAffectedParams().add(item.getAttribute("name"));
        }
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerRouteMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        RouteMetadata descr = (RouteMetadata)registry.getMetadata(id);
        if (descr == null) {
            descr = new RouteMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        for (Element item : XmlUtil.getElements((Element)elm, (String)"local-variable")) {
            descr.getLocalVariables().add(item.getAttribute("name"));
        }
        for (Element item : XmlUtil.getElements((Element)elm, (String)"input-param")) {
            descr.getInputParams().add(item.getAttribute("name"));
        }
        for (Element item : XmlUtil.getElements((Element)elm, (String)"affected-param")) {
            descr.getAffectedParams().add(item.getAttribute("name"));
        }
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerRoutingKeyMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String idStr = elm.getAttribute("id");
        String id = TextUtil.isBlank((String)idStr) ? givenId : this.buildId(idsPreffix, elm, "id");
        RoutingKeyMetadata descr = (RoutingKeyMetadata)registry.getMetadata(id);
        if (descr == null) {
            descr = new RoutingKeyMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setKeyProviderClass(elm.getAttribute("key-provider"));
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerDebugHandlerMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        DebugHandlerMetadata descr = (DebugHandlerMetadata)registry.getMetadata(id);
        if (descr == null) {
            descr = new DebugHandlerMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setImplementationClassName(elm.getAttribute("class"));
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerMulticallMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        MulticallMetadata descr = (MulticallMetadata)registry.getMetadata(id);
        if (descr == null) {
            descr = new MulticallMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setTargetsProviderImpl(elm.getAttribute("targets-provider"));
        descr.setTargetKey(elm.getAttribute("target-key"));
        descr.setResultKey(elm.getAttribute("result-key"));
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerIteratorMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        IteratorMetadata descr = registry.getMetadata(id, IteratorMetadata.class);
        if (descr == null) {
            descr = new IteratorMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setTargetsProviderImpl(elm.getAttribute("targets-provider"));
        descr.setTargetKey(elm.getAttribute("target-key"));
        descr.setSizeKey(elm.getAttribute("size-key"));
        descr.setIndexKey(elm.getAttribute("index-key"));
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerWhileLoopMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        WhileLoopMetadata descr = registry.getMetadata(id, WhileLoopMetadata.class);
        if (descr == null) {
            descr = new WhileLoopMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setConditionProviderClass(elm.getAttribute("condition-provider"));
        this.updateParameters(descr, elm);
        return descr.getId();
    }

    private String registerProcessorMetadata(IntegrationBusRegistry registry, Element elm, String idsPreffix, String givenId, String local) {
        String id = TextUtil.isBlank((String)givenId) ? this.buildId(idsPreffix, elm, "id") : givenId;
        ProcessorMetadata descr = (ProcessorMetadata)registry.getMetadata(id);
        if (descr == null) {
            descr = new ProcessorMetadata();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerMetadata(descr);
            String compoundId = String.format("metadata-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("metadata with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        descr.setImplementationClassName(elm.getAttribute("class"));
        this.updateParameters(descr, elm);
        for (Element paramElm : XmlUtil.getElements((Element)elm, (String)"input-param")) {
            this.addParameter(descr.getInputParameters(), paramElm);
        }
        for (Element paramElm : XmlUtil.getElements((Element)elm, (String)"affected-param")) {
            this.addParameter(descr.getAffectedParameters(), paramElm);
        }
        return descr.getId();
    }

    private void addParameter(Map<String, ParameterType> inputParameters, Element paramElm) {
        String name = paramElm.getAttribute("name");
        if (TextUtil.isBlank((String)name)) {
            return;
        }
        String typeStr = paramElm.getAttribute("type");
        ParameterType type = ParameterType.OTHER;
        if (!TextUtil.isBlank((String)typeStr)) {
            type = ParameterType.valueOf(typeStr);
        }
        inputParameters.put(name, type);
    }

    private String registerAdvice(IntegrationBusRegistry registry, Element elm, String idsPreffix, String local) {
        String id2 = this.buildId(idsPreffix, elm, "id");
        String id = this.buildId(idsPreffix, elm, "class", registry, new MetadataClassNameHandler<AdviceMetadata>(){

            @Override
            public String getClassName(AdviceMetadata metadata) {
                return metadata.getImplementationClassName();
            }
        });
        AdviceDescription descr = registry.getAdvice(id);
        if (descr == null) {
            descr = new AdviceDescription();
            descr.setId(id);
            descr.setFile(local);
            this.setLocation(descr, elm);
            registry.registerAdvice(descr);
            String compoundId = String.format("advice-%s", id);
            if (this.registeredIds.contains(compoundId)) {
                throw new IllegalStateException(String.format("advice with id %s is already registered in xml %s", id, this.currentXml));
            }
            this.registeredIds.add(compoundId);
        }
        String metadataId = null;
        Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
        if (metadata != null) {
            metadataId = this.registerAdviceMetadata(registry, metadata, idsPreffix, id, local);
        } else if (!TextUtil.isBlank((String)elm.getAttribute("metadata-ref"))) {
            metadataId = this.buildRef(idsPreffix, elm, "metadata-ref");
        }
        descr.setMetadataRef(metadataId);
        this.updateParameters(descr, elm);
        registry.registerAdvice(descr);
        descr.setBeforeSubrouteRef(this.getAdviceSubroute(descr.getBeforeSubrouteRef(), elm, "before", registry, idsPreffix, local));
        descr.setAfterSubrouteRef(this.getAdviceSubroute(descr.getAfterSubrouteRef(), elm, "after", registry, idsPreffix, local));
        descr.setExceptionSubrouteRef(this.getAdviceSubroute(descr.getExceptionSubrouteRef(), elm, "on-exception", registry, idsPreffix, local));
        return descr.getId();
    }

    private String getAdviceSubroute(String currentId, Element elm, String name, IntegrationBusRegistry registry, String idsPreffix, String local) {
        Element element = XmlUtil.getElement((Element)elm, (String)name);
        if (element != null) {
            return this.registerSubroute(registry, element, idsPreffix, local);
        }
        element = XmlUtil.getElement((Element)elm, (String)String.format("%s-ref", name));
        if (element != null) {
            return this.buildRef(idsPreffix, element, "ref");
        }
        return currentId;
    }

    private String buildRef(String idsPreffix, Element elm, String path) {
        String res = elm.getAttribute(path);
        if (TextUtil.isBlank((String)res)) {
            return null;
        }
        if (res.contains(":")) {
            return res;
        }
        if (TextUtil.isBlank((String)idsPreffix)) {
            return res;
        }
        return String.format("%s:%s", idsPreffix, res);
    }

    private String buildId(String idsPreffix, Element elm, String path) {
        String id = elm.getAttribute(path);
        if (TextUtil.isBlank((String)id)) {
            id = "auto-" + UUIDGenerator.generate((boolean)true).toString();
        }
        if (id.contains(":")) {
            return id;
        }
        if (!TextUtil.isBlank((String)idsPreffix)) {
            return String.format("%s:%s", idsPreffix, id);
        }
        return id;
    }

    private String buildId(String idsPreffix, Element elm, String path, String prefferId) {
        String id = elm.getAttribute(path);
        if (TextUtil.isBlank((String)id) && TextUtil.isBlank((String)(id = prefferId))) {
            id = "auto-" + UUIDGenerator.generate((boolean)true).toString();
        }
        if (id.contains(":")) {
            return id;
        }
        if (!TextUtil.isBlank((String)idsPreffix)) {
            return String.format("%s:%s", idsPreffix, id);
        }
        return id;
    }

    private <M extends BaseElementMetadata> String buildId(String idsPreffix, Element elm, String classNamePath, IntegrationBusRegistry registry, MetadataClassNameHandler<M> handler) {
        String id = elm.getAttribute("id");
        if (TextUtil.isBlank((String)id)) {
            String metadataId = this.buildRef(idsPreffix, elm, "metadata-ref");
            if (metadataId != null) {
                BaseElementMetadata mtd = registry.getMetadata(metadataId);
                if (mtd == null) {
                    throw new IllegalStateException(String.format("error processing xml %s: metadata with id %s is not registered", this.currentXml, metadataId));
                }
                id = this.generateIdFromClassName(handler.getClassName(mtd));
            } else {
                String className;
                Element metadata = XmlUtil.getElement((Element)elm, (String)"metadata");
                if (metadata != null && !TextUtil.isBlank((String)(className = metadata.getAttribute(classNamePath)))) {
                    id = this.generateIdFromClassName(className);
                }
            }
        }
        if (TextUtil.isBlank((String)id)) {
            id = "auto-" + UUIDGenerator.generate((boolean)true).toString();
        }
        if (!id.contains(":") && !TextUtil.isBlank((String)idsPreffix)) {
            id = String.format("%s:%s", idsPreffix, id);
        }
        return id;
    }

    public class LocationAnnotator
    extends XMLFilterImpl {
        private Locator locator;
        protected final ArrayDeque<Locator> locatorStack;
        protected final UserDataHandler dataHandler;

        public LocationAnnotator(XMLReader xmlReader, Document dom) {
            super(xmlReader);
            this.locatorStack = new ArrayDeque();
            this.dataHandler = new LocationDataHandler();
            EventListener modListener = new EventListener(){

                @Override
                public void handleEvent(Event e) {
                    EventTarget target = ((MutationEvent)e).getTarget();
                    Locator startLocator = LocationAnnotator.this.locatorStack.getLast();
                    LocationData location = new LocationData(startLocator.getLineNumber(), startLocator.getColumnNumber());
                    ((Element)((Object)target)).setUserData("locationDataKey", location, LocationAnnotator.this.dataHandler);
                }
            };
            ((EventTarget)((Object)dom)).addEventListener("DOMNodeInserted", modListener, true);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(uri, localName, qName, atts);
            this.locatorStack.addLast(new LocatorImpl(this.locator));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            this.locatorStack.removeLast();
        }

        protected class LocationDataHandler
        implements UserDataHandler {
            protected LocationDataHandler() {
            }

            @Override
            public void handle(short operation, String key, Object data, Node src, Node dst) {
                LocationData locatonData;
                if (src != null && dst != null && (locatonData = (LocationData)src.getUserData("locationDataKey")) != null) {
                    dst.setUserData("locationDataKey", locatonData, LocationAnnotator.this.dataHandler);
                }
            }
        }
    }

    public class LocationData {
        public static final String LOCATION_DATA_KEY = "locationDataKey";
        private final int startLine;
        private final int startColumn;

        public LocationData(int startLine, int startColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getStartColumn() {
            return this.startColumn;
        }
    }

    static interface MetadataClassNameHandler<M extends BaseElementMetadata> {
        public String getClassName(M var1);
    }
}

