/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Map;

public class AddItemToCollectionProcessor
extends BaseProcessor {
    private String itemKey;
    private String collectionKey;
    private Class cls;
    private boolean createCollectionIfNull;

    @Override
    public void configure(Map<String, String> parameters) {
        try {
            this.itemKey = IbusConfigurationHelper.getMandatoryParameter(parameters, "item-key");
            this.collectionKey = IbusConfigurationHelper.getMandatoryParameter(parameters, "collection-key");
            this.cls = Class.forName(IbusConfigurationHelper.getMandatoryParameter(parameters, "cls"));
            this.createCollectionIfNull = "true".equals(parameters.get("create-collection-if-null"));
        }
        catch (Throwable throwable) {
            throw Xeption.forDeveloper((String)"error config", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        Object item = ctx.getMandatoryObject(this.itemKey);
        if (!this.cls.isInstance(item)) {
            throw Xeption.forDeveloper((String)"invalid item {0} class: {1} but expected {2}", (Object[])new Object[]{this.itemKey, item.getClass(), this.cls});
        }
        ArrayList collection = (ArrayList)ctx.getObject(this.collectionKey);
        if (collection == null) {
            if (!this.createCollectionIfNull) {
                throw Xeption.forDeveloper((String)"Collection {0} is null", (Object[])new Object[]{this.collectionKey});
            }
            collection = new ArrayList();
            ctx.putObject(this.collectionKey, collection);
        }
        collection.add(item);
    }
}

