/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class AddMessageToContext
extends BaseProcessor {
    private String messageKey = null;
    private String messageText = null;
    private MessageType messageType = MessageType.MESSAGE;

    @Override
    public void configure(Map<String, String> parameters) {
        this.messageKey = IbusConfigurationHelper.getOptionalParameter(parameters, "message-key");
        if (TextUtil.isBlank((String)this.messageKey)) {
            this.messageText = IbusConfigurationHelper.getMandatoryParameter(parameters, "value");
            String messageTypeStr = IbusConfigurationHelper.getOptionalParameter(parameters, "type");
            if (!TextUtil.isBlank((String)messageTypeStr)) {
                this.messageType = MessageType.valueOf((String)messageTypeStr);
            }
        }
    }

    @Override
    public void process(MessageContext ctx) throws Exception {
        if (TextUtil.nonBlank((String)this.messageKey)) {
            ctx.addMessage((Message)ctx.getMandatoryObject(this.messageKey));
        } else {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)this.messageType, (String)this.messageText, (Object[])new Object[0]));
        }
    }
}

