/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.BooleanUtils;

public class AssetLockAdvice
extends BaseAdvice {
    private String ctxName;
    private String tag;
    private String operation;
    private boolean reload;
    private boolean noCache;

    @Override
    public void configure(Map<String, String> params) throws Exception {
        this.ctxName = IbusConfigurationHelper.getMandatoryParameter(params, "context-key");
        this.tag = IbusConfigurationHelper.getOptionalParameter(params, "tag");
        this.operation = IbusConfigurationHelper.getOptionalParameter(params, "operation");
        this.reload = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(params, "reload", Boolean.FALSE.toString()));
        this.noCache = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(params, "no-cache", Boolean.FALSE.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void before(MessageContext ctx) throws Exception {
        Deque lockStack = IbusHelper.getObjectN(ctx, (Enum)IBusStandardContextKeys.LOCK_STACK, () -> new LinkedList());
        BaseAsset asset = (BaseAsset)ctx.getObject(this.ctxName);
        if (asset == null) {
            lockStack.addLast(null);
            return;
        }
        LockManager lockManager = LockUtil.getLockManager();
        boolean success = false;
        NamedLock lock = lockManager.getLock((Object)(TextUtil.isBlank((String)this.tag) ? LockUtil.getLockKey((BaseAsset)asset) : LockUtil.getLockKey((BaseAsset)asset, (String)this.tag)));
        try {
            if (!lock.tryLock((String)MiscUtil.orElse((Object)this.operation, (Object)ctx.getRouteId()), 30L, TimeUnit.MINUTES)) {
                throw Xeption.forEndUser((String)L10n.get((String)Messages.ExceptionMessages_UnableToLock), (Object[])new Object[0]);
            }
            try {
                BaseAsset reloadAsset;
                lockStack.addLast(lock);
                if (this.reload && Objects.nonNull(reloadAsset = AssetsStorage.get().load(asset.getClass(), asset.getUid(), this.noCache))) {
                    ctx.putObject(this.ctxName, (Object)reloadAsset);
                }
                success = true;
            }
            finally {
                if (!success) {
                    lock.unlock();
                }
            }
        }
        finally {
            if (!success) {
                lock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(MessageContext ctx) throws Exception {
        Deque lockStack = (Deque)ctx.getMandatoryObject((Enum<?>)IBusStandardContextKeys.LOCK_STACK);
        try {
            NamedLock lock = (NamedLock)lockStack.removeLast();
            if (null == lock) {
                return;
            }
            try {
                lock.unlock();
            }
            finally {
                lock.close();
            }
        }
        finally {
            if (lockStack.isEmpty()) {
                ctx.putObject((Enum<?>)IBusStandardContextKeys.LOCK_STACK, (Object)null);
            }
        }
    }
}

