/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class ContextKeyProvider
extends BaseRoutingKeyProvider {
    private String key;
    private String ifNull;
    private String ifEmptyCollection;
    private boolean toString;

    @Override
    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, "key");
        this.ifNull = IbusConfigurationHelper.getOptionalParameter(parameters, "if-null");
        this.ifEmptyCollection = IbusConfigurationHelper.getOptionalParameter(parameters, "if-empty-collection");
        this.toString = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "to-string", Boolean.TRUE.toString()));
    }

    @Override
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Object object = ctx.getObject(this.key);
        if (object == null && TextUtil.isBlank((String)this.ifNull)) {
            Objects.requireNonNull(object);
        }
        if (object != null) {
            if (object instanceof Enum) {
                return ((Enum)object).name();
            }
            if (object instanceof String) {
                String s = (String)object;
                return TextUtil.isBlank((String)s) ? this.ifNull : (this.toString ? s : "java.lang.Object");
            }
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                if (!TextUtil.isBlank((String)this.ifEmptyCollection) && !iterable.iterator().hasNext()) {
                    return this.ifEmptyCollection;
                }
                return "java.lang.Iterable";
            }
            if (object instanceof Map) {
                return "java.util.Map";
            }
            return this.toString ? object.toString() : "java.lang.Object";
        }
        return this.ifNull;
    }
}

