/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class ContextKeyTargetsProvider
extends BaseTargetsProvider<Object> {
    private String key;
    private boolean emptyIfNull;
    private MapOperation mapOperation;

    @Override
    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, "key");
        this.emptyIfNull = BooleanUtils.toBoolean((String)IbusConfigurationHelper.getOptionalParameter(parameters, "empty-if-null"));
        String buffer = IbusConfigurationHelper.getOptionalParameter(parameters, "map");
        if (!TextUtil.isBlank((String)buffer)) {
            this.mapOperation = MapOperation.valueOf(buffer);
        }
    }

    @Override
    public Collection<Object> getTargets(MessageContext ctx) throws Exception {
        Object res = ctx.getObject(this.key);
        if (res == null && this.emptyIfNull) {
            return Collections.emptyList();
        }
        if (this.mapOperation != null) {
            Map map = (Map)res;
            switch (this.mapOperation) {
                case KEYS: {
                    return map.keySet();
                }
                case VALUES: {
                    return map.values();
                }
                case ENTRIES: {
                    return map.entrySet();
                }
            }
            throw Xeption.forDeveloper((String)"usupported={0}", (Object[])new Object[]{this.mapOperation.name()});
        }
        return (Collection)res;
    }

    public static enum MapOperation {
        KEYS,
        VALUES,
        ENTRIES;

    }
}

