/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ContextValueShifterAdvice
extends BaseAdvice {
    private Map<String, String> keys = new HashMap<String, String>();

    @Override
    public void configure(Map<String, String> params) throws Exception {
        params.forEach((key, value) -> {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.keys.put((String)key, (String)value);
        });
    }

    @Override
    public void before(MessageContext ctx) throws Exception {
        this.keys.forEach((key, value) -> this.shift(ctx, (String)key, (String)value));
    }

    @Override
    public void after(MessageContext ctx) throws Exception {
        this.keys.forEach((key, value) -> this.shift(ctx, (String)value, (String)key));
    }

    private void shift(MessageContext ctx, String from, String to) {
        Object mandatoryObject = ctx.getMandatoryObject(from);
        ctx.putObject(to, mandatoryObject);
    }
}

