/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDebugHandler
implements DebugHandler {
    private static final long serialVersionUID = -5176662796894290777L;
    private String loggerName = this.getClass().getName();
    private boolean debugDataDisabled;

    @Override
    public boolean isDebugDataDisabled(MessageContext ctx) {
        return this.debugDataDisabled;
    }

    @Override
    public void configure(Map<String, String> properties) {
        this.loggerName = properties.get("loggerName");
        this.debugDataDisabled = "true".equals(properties.get("debug-data-disabled"));
        if (this.loggerName == null) {
            this.loggerName = this.getClass().getName();
        }
    }

    @Override
    public boolean isTraceData(String processorId, MessageContext ctx) {
        return LoggerFactory.getLogger((String)TextUtil.concatWithDelimeter((String)".", (String[])new String[]{"DUMP.com.gridnine.xtrip.server.ibus", this.loggerName, processorId.replace(":", ".")})).isDebugEnabled();
    }

    @Override
    public void save(DebugData data, MessageContext ctx) {
        Logger log = LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.ibus.".concat(this.loggerName));
        if (log.isDebugEnabled()) {
            log.debug(data.buildDebugInfo(true));
        }
    }
}

