/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.standard;

import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.lockmanager.LockKeyBuilder;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class EntityContainerLockAdvice
extends BaseAdvice {
    private String ctxName;
    private String tag;
    private String operation;
    private boolean reload;
    private boolean noCache;
    private boolean load;
    private String loadKey;

    @Override
    public void configure(Map<String, String> params) throws Exception {
        this.ctxName = IbusConfigurationHelper.getMandatoryParameter(params, "context-key");
        this.loadKey = IbusConfigurationHelper.getOptionalParameter(params, "load-key");
        this.tag = IbusConfigurationHelper.getOptionalParameter(params, "tag");
        this.operation = IbusConfigurationHelper.getOptionalParameter(params, "operation");
        this.reload = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(params, "reload", Boolean.FALSE.toString()));
        this.load = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(params, "load", Boolean.FALSE.toString()));
        this.noCache = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(params, "no-cache", Boolean.TRUE.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void before(MessageContext ctx) throws Exception {
        Deque containersCacheStack = IbusHelper.getObjectN(ctx, (Enum)IBusStandardContextKeys.CONTAINERS_CACHE_STACK, LinkedList::new);
        Deque lockStack = IbusHelper.getObjectN(ctx, (Enum)IBusStandardContextKeys.LOCK_STACK, LinkedList::new);
        ConcurrentHashMap containersCache = new ConcurrentHashMap();
        Map oldcontainersCache = (Map)ctx.getObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE);
        if (oldcontainersCache != null) {
            containersCache.putAll(oldcontainersCache);
        }
        containersCacheStack.addLast(containersCache);
        ctx.putObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE, (Object)containersCache);
        Object obj = ctx.getObject(this.ctxName);
        if (Objects.isNull(obj)) {
            lockStack.addLast(null);
            return;
        }
        if (EntityIndex.class.isInstance(obj)) {
            obj = ((EntityIndex)obj).getSource();
        }
        String lockKey = LockKeyBuilder.newInstance(obj).tag(this.tag).build();
        LockManager lockManager = LockUtil.getLockManager();
        NamedLock namedLock = lockManager.getLock((Object)lockKey);
        boolean success = false;
        try {
            boolean tryLock = namedLock.tryLock(this.operation, 30L, TimeUnit.MINUTES);
            if (!tryLock) {
                throw Xeption.forEndUser((String)L10n.get((String)Messages.ExceptionMessages_UnableToLock), (Object[])new Object[0]);
            }
            lockStack.addLast(namedLock);
            this.reload(obj, ctx);
            success = true;
        }
        finally {
            if (!success) {
                namedLock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(MessageContext ctx) throws Exception {
        Deque containersCacheStack = (Deque)ctx.getMandatoryObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE_STACK);
        containersCacheStack.removeLast();
        ctx.removeObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE);
        if (!containersCacheStack.isEmpty()) {
            ctx.putObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE, containersCacheStack.getLast());
        } else {
            ctx.removeObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE_STACK);
        }
        Deque lockStack = (Deque)ctx.getMandatoryObject((Enum<?>)IBusStandardContextKeys.LOCK_STACK);
        try (NamedLock removeNamedLock = (NamedLock)lockStack.removeLast();){
            if (Objects.nonNull(removeNamedLock)) {
                removeNamedLock.unlock();
            }
        }
        finally {
            if (CollectionUtil.isEmpty((Collection)lockStack)) {
                ctx.removeObject((Enum<?>)IBusStandardContextKeys.LOCK_STACK);
            }
        }
    }

    private void reload(Object obj, MessageContext ctx) {
        EntityContainer cachedContainer;
        if (!this.reload && !this.load) {
            return;
        }
        EntityReference reference = null;
        EntityContainer container = null;
        String resultKey = (String)MiscUtil.orElse((Object)this.loadKey, (Object)this.ctxName);
        if (EntityContainer.class.isInstance(obj)) {
            container = (EntityContainer)obj;
            reference = container.toReference();
        } else if (EntityReference.class.isInstance(obj)) {
            reference = (EntityReference)obj;
        }
        if (Objects.isNull(reference)) {
            return;
        }
        Map containersCache = (Map)ctx.getMandatoryObject((Enum<?>)IBusStandardContextKeys.CONTAINERS_CACHE);
        if (Objects.nonNull(container) && (cachedContainer = (EntityContainer)containersCache.get(reference)) == container) {
            ctx.putObject(resultKey, (Object)cachedContainer);
            return;
        }
        EntityStorageLoadParameters loadParameters = (EntityStorageLoadParameters)((EntityStorageLoadParameters)new EntityStorageLoadParameters().context("irrelevance-tolerant-query", (Object)Boolean.FALSE)).noCache(this.noCache);
        container = EntityStorage.get().load(reference.getType(), reference.getUid(), loadParameters);
        containersCache.put(reference, container);
        obj = container;
        if (Objects.nonNull(obj)) {
            ctx.putObject(resultKey, obj);
        }
    }
}

